/*
 * Decompiled with CFR 0.152.
 */
package net.lizistired.cavedust;

import com.minelittlepony.common.util.GamePaths;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.lizistired.cavedust.CaveDustConfig;
import net.lizistired.cavedust.utils.KeybindingHelper;
import net.lizistired.cavedust.utils.MathHelper;
import net.lizistired.cavedust.utils.ParticleSpawnUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveDust
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cavedust");
    private static CaveDust instance;
    private static CaveDustConfig config;
    public static int WHITE_ASH_ID;
    public static int PARTICLE_AMOUNT;

    public static CaveDust getInstance() {
        return instance;
    }

    public CaveDust() {
        instance = this;
    }

    public CaveDustConfig getConfig() {
        return config;
    }

    public void onInitializeClient() {
        Path CaveDustFolder = GamePaths.getConfigDirectory().resolve("cavedust");
        config = new CaveDustConfig(CaveDustFolder.getParent().resolve("cavedust.json"), this);
        config.load();
        KeybindingHelper.registerKeyBindings();
        ClientTickEvents.END_CLIENT_TICK.register(this::createCaveDust);
    }

    private void createCaveDust(class_310 client) {
        if (KeybindingHelper.keyBinding1.method_1436()) {
            this.getConfig().toggleCaveDust();
            LOGGER.info("Toggled dust");
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)("debug.cavedust.toggle." + config.getCaveDustEnabled())), false);
        }
        if (KeybindingHelper.keyBinding2.method_1436()) {
            this.getConfig().load();
            LOGGER.info("Reloaded config");
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.cavedust.reload"), false);
        }
        if (client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        double probabilityNormalized = MathHelper.normalize(config.getLowerLimit(), config.getUpperLimit(), client.field_1724.method_31478());
        PARTICLE_AMOUNT = (int)(probabilityNormalized * (double)config.getParticleMultiplier() * (double)config.getParticleMultiplierMultiplier());
        for (int i = 0; i < PARTICLE_AMOUNT; ++i) {
            try {
                int x = (int)(client.field_1724.method_19538().method_10216() + (double)((int)MathHelper.generateRandomDouble(config.getDimensionsX() * -1.0f, config.getDimensionsX())));
                int y = (int)(client.field_1724.method_19538().method_10214() + (double)((int)MathHelper.generateRandomDouble(config.getDimensionsY() * -1.0f, config.getDimensionsY())));
                int z = (int)(client.field_1724.method_19538().method_10215() + (double)((int)MathHelper.generateRandomDouble(config.getDimensionsZ() * -1.0f, config.getDimensionsZ())));
                class_2338 particlePos = new class_2338(x, y, z);
                if (!ParticleSpawnUtil.shouldParticlesSpawn(client, config, particlePos) || !client.field_1687.method_8320(particlePos).method_26215()) continue;
                world.method_8406(config.getParticle(), (double)x, (double)y, (double)z, (double)config.getVelocityRandomnessRandom(), (double)config.getVelocityRandomnessRandom(), (double)config.getVelocityRandomnessRandom());
                continue;
            }
            catch (NullPointerException e) {
                LOGGER.error(String.valueOf(e));
                this.getConfig().setParticleID(WHITE_ASH_ID);
            }
        }
    }

    static {
        WHITE_ASH_ID = class_7923.field_41180.method_10206((Object)class_2398.field_23956);
        PARTICLE_AMOUNT = 0;
    }
}

