/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.Config;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public final class DynamicFPSConfig {
    private Map<PowerState, Config> configs;
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("dynamic_fps.json");
    private static final Codec<Map<PowerState, Config>> STATES_CODEC = Codec.unboundedMap(PowerState.CODEC, Config.CODEC);
    private static final Codec<DynamicFPSConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)STATES_CODEC.fieldOf("states").forGetter(DynamicFPSConfig::configs)).apply((Applicative)instance, DynamicFPSConfig::new));

    private DynamicFPSConfig(Map<PowerState, Config> configs) {
        this.configs = new EnumMap<PowerState, Config>(configs);
        for (PowerState state : PowerState.values()) {
            if (!state.configurable) continue;
            this.configs.computeIfAbsent(state, DynamicFPSConfig::getDefaultConfig);
        }
    }

    public Config get(PowerState state) {
        switch (state) {
            case FOCUSED: {
                return Config.ACTIVE;
            }
            case SUSPENDED: {
                return Config.SUSPENDED;
            }
        }
        return this.configs.get((Object)state);
    }

    private Map<PowerState, Config> configs() {
        return this.configs;
    }

    public static DynamicFPSConfig load() {
        String data;
        try {
            data = Files.readString(PATH);
        }
        catch (NoSuchFileException e) {
            return new DynamicFPSConfig(new EnumMap<PowerState, Config>(PowerState.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Dynamic FPS config.", e);
        }
        JsonElement root = JsonParser.parseString((String)data);
        DataResult parsed = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)root);
        return (DynamicFPSConfig)parsed.getOrThrow(false, RuntimeException::new);
    }

    public void save() {
        DataResult data = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        JsonElement root = (JsonElement)data.getOrThrow(false, RuntimeException::new);
        try {
            Files.writeString(PATH, (CharSequence)root.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save Dynamic FPS config.", e);
        }
    }

    public static Config getDefaultConfig(PowerState state) {
        switch (state) {
            case HOVERED: {
                return new Config(60, 1.0f, GraphicsState.DEFAULT, true, false);
            }
            case UNFOCUSED: {
                return new Config(1, 0.25f, GraphicsState.DEFAULT, false, false);
            }
            case INVISIBLE: {
                return new Config(0, 0.0f, GraphicsState.DEFAULT, false, false);
            }
        }
        throw new RuntimeException("Getting default configuration for unhandled power state " + state.toString());
    }
}

