/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.Register;
import io.github.mortuusars.exposure.advancement.trigger.FrameExposedTrigger;
import io.github.mortuusars.exposure.block.FlashBlock;
import io.github.mortuusars.exposure.block.LightroomBlock;
import io.github.mortuusars.exposure.block.entity.FlashBlockEntity;
import io.github.mortuusars.exposure.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.command.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.command.argument.ExposureSizeArgument;
import io.github.mortuusars.exposure.command.argument.ShaderLocationArgument;
import io.github.mortuusars.exposure.command.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.item.PhotographFrameItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.SignedAlbumItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.menu.ItemRenameMenu;
import io.github.mortuusars.exposure.menu.LecternAlbumMenu;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographAgingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_2135;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Exposure {
    public static final String ID = "exposure";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final float CROP_FACTOR = 1.142857f;

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
        Camera.registerCameraGetter(Exposure.resource("camera_in_hand"), player -> CameraInHand.ofPlayer(player, CameraItem.class));
    }

    public static void initServer(MinecraftServer server) {
        ExposureServer.init(server);
    }

    public static class_2960 resource(String path) {
        return new class_2960(ID, path);
    }

    public static class Blocks {
        public static final Supplier<LightroomBlock> LIGHTROOM = Register.block("lightroom", () -> new LightroomBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15977).method_9632(2.5f).method_9626(class_2498.field_11547).method_9631(state -> 15)));
        public static final Supplier<FlashBlock> FLASH = Register.block("flash", () -> new FlashBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10124).method_9629(-1.0f, 3600000.8f).method_42327().method_31710(class_3620.field_16008).method_22488().method_9634().method_9631(state -> 15)));

        static void init() {
        }
    }

    public static class BlockEntityTypes {
        public static final Supplier<class_2591<LightroomBlockEntity>> LIGHTROOM = Register.blockEntityType("lightroom", () -> Register.newBlockEntityType(LightroomBlockEntity::new, Blocks.LIGHTROOM.get()));
        public static final Supplier<class_2591<FlashBlockEntity>> FLASH = Register.blockEntityType("flash", () -> Register.newBlockEntityType(FlashBlockEntity::new, Blocks.FLASH.get()));

        static void init() {
        }
    }

    public static class EntityTypes {
        public static final Supplier<class_1299<PhotographEntity>> PHOTOGRAPH = Register.entityType("photograph", PhotographEntity::new, class_1311.field_17715, 0.5f, 0.5f, 128, false, Integer.MAX_VALUE);
        public static final Supplier<class_1299<PhotographFrameEntity>> PHOTOGRAPH_FRAME = Register.entityType("photograph_frame", PhotographFrameEntity::new, class_1311.field_17715, 0.5f, 0.5f, 128, false, Integer.MAX_VALUE);

        static void init() {
        }
    }

    public static class Items {
        public static final Supplier<CameraItem> CAMERA = Register.item("camera", () -> new CameraItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<FilmRollItem> BLACK_AND_WHITE_FILM = Register.item("black_and_white_film", () -> new FilmRollItem(FilmType.BLACK_AND_WHITE, class_3532.method_15353((float)0.8f, (float)0.8f, (float)0.9f), new class_1792.class_1793().method_7889(16)));
        public static final Supplier<FilmRollItem> COLOR_FILM = Register.item("color_film", () -> new FilmRollItem(FilmType.COLOR, class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f), new class_1792.class_1793().method_7889(16)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_BLACK_AND_WHITE_FILM = Register.item("developed_black_and_white_film", () -> new DevelopedFilmItem(FilmType.BLACK_AND_WHITE, new class_1792.class_1793().method_7889(1)));
        public static final Supplier<DevelopedFilmItem> DEVELOPED_COLOR_FILM = Register.item("developed_color_film", () -> new DevelopedFilmItem(FilmType.COLOR, new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographItem> PHOTOGRAPH = Register.item("photograph", () -> new PhotographItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<ChromaticSheetItem> CHROMATIC_SHEET = Register.item("chromatic_sheet", () -> new ChromaticSheetItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographItem> AGED_PHOTOGRAPH = Register.item("aged_photograph", () -> new PhotographItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<InterplanarProjectorItem> INTERPLANAR_PROJECTOR = Register.item("interplanar_projector", () -> new InterplanarProjectorItem(new class_1792.class_1793()));
        public static final Supplier<StackedPhotographsItem> STACKED_PHOTOGRAPHS = Register.item("stacked_photographs", () -> new StackedPhotographsItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<AlbumItem> ALBUM = Register.item("album", () -> new AlbumItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<SignedAlbumItem> SIGNED_ALBUM = Register.item("signed_album", () -> new SignedAlbumItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PhotographFrameItem> PHOTOGRAPH_FRAME = Register.item("photograph_frame", () -> new PhotographFrameItem(new class_1792.class_1793()));
        public static final Supplier<class_1747> LIGHTROOM = Register.item("lightroom", () -> new class_1747((class_2248)Blocks.LIGHTROOM.get(), new class_1792.class_1793()));

        static void init() {
        }
    }

    public static class MenuTypes {
        public static final Supplier<class_3917<CameraAttachmentsMenu>> CAMERA = Register.menuType("camera", CameraAttachmentsMenu::fromBuffer);
        public static final Supplier<class_3917<AlbumMenu>> ALBUM = Register.menuType("album", AlbumMenu::fromBuffer);
        public static final Supplier<class_3917<LecternAlbumMenu>> LECTERN_ALBUM = Register.menuType("lectern_album", LecternAlbumMenu::fromBuffer);
        public static final Supplier<class_3917<LightroomMenu>> LIGHTROOM = Register.menuType("lightroom", LightroomMenu::fromBuffer);
        public static final Supplier<class_3917<ItemRenameMenu>> ITEM_RENAME = Register.menuType("item_rename", ItemRenameMenu::fromBuffer);

        static void init() {
        }
    }

    public static class RecipeSerializers {
        public static final Supplier<class_1865<?>> FILM_DEVELOPING = Register.recipeSerializer("film_developing", FilmDevelopingRecipe.Serializer::new);
        public static final Supplier<class_1865<?>> PHOTOGRAPH_CLONING = Register.recipeSerializer("photograph_copying", PhotographCopyingRecipe.Serializer::new);
        public static final Supplier<class_1865<?>> PHOTOGRAPH_AGING = Register.recipeSerializer("photograph_aging", PhotographAgingRecipe.Serializer::new);

        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<class_3414> VIEWFINDER_OPEN = SoundEvents.register("item", "camera.viewfinder_open");
        public static final Supplier<class_3414> VIEWFINDER_CLOSE = SoundEvents.register("item", "camera.viewfinder_close");
        public static final Supplier<class_3414> SHUTTER_OPEN = SoundEvents.register("item", "camera.shutter_open");
        public static final Supplier<class_3414> SHUTTER_CLOSE = SoundEvents.register("item", "camera.shutter_close");
        public static final Supplier<class_3414> SHUTTER_TICKING = SoundEvents.register("item", "camera.shutter_ticking");
        public static final Supplier<class_3414> FILM_ADVANCING = SoundEvents.register("item", "camera.film_advance");
        public static final Supplier<class_3414> FILM_ADVANCE_LAST = SoundEvents.register("item", "camera.film_advance_last");
        public static final Supplier<class_3414> FILM_REMOVED = SoundEvents.register("item", "camera.film_removed");
        public static final Supplier<class_3414> CAMERA_GENERIC_CLICK = SoundEvents.register("item", "camera.generic_click");
        public static final Supplier<class_3414> CAMERA_BUTTON_CLICK = SoundEvents.register("item", "camera.button_click");
        public static final Supplier<class_3414> CAMERA_RELEASE_BUTTON_CLICK = SoundEvents.register("item", "camera.release_button_click");
        public static final Supplier<class_3414> CAMERA_DIAL_CLICK = SoundEvents.register("item", "camera.dial_click");
        public static final Supplier<class_3414> CAMERA_LENS_RING_CLICK = SoundEvents.register("item", "camera.lens_ring_click");
        public static final Supplier<class_3414> LENS_INSERT = SoundEvents.register("item", "camera.lens_insert");
        public static final Supplier<class_3414> LENS_REMOVE = SoundEvents.register("item", "camera.lens_remove");
        public static final Supplier<class_3414> FILTER_INSERT = SoundEvents.register("item", "camera.filter_insert");
        public static final Supplier<class_3414> FILTER_REMOVE = SoundEvents.register("item", "camera.filter_remove");
        public static final Supplier<class_3414> FLASH = SoundEvents.register("item", "camera.flash");
        public static final Supplier<class_3414> INTERPLANAR_PROJECT = SoundEvents.register("item", "camera.interplanar_projector.project");
        public static final Supplier<class_3414> PHOTOGRAPH_PLACE = SoundEvents.register("item", "photograph.place");
        public static final Supplier<class_3414> PHOTOGRAPH_BREAK = SoundEvents.register("item", "photograph.break");
        public static final Supplier<class_3414> PHOTOGRAPH_RUSTLE = SoundEvents.register("item", "photograph.rustle");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_PLACE = SoundEvents.register("item", "photograph_frame.place");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_BREAK = SoundEvents.register("item", "photograph_frame.break");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_ADD_ITEM = SoundEvents.register("item", "photograph_frame.add_item");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_REMOVE_ITEM = SoundEvents.register("item", "photograph_frame.remove_item");
        public static final Supplier<class_3414> PHOTOGRAPH_FRAME_ROTATE_ITEM = SoundEvents.register("item", "photograph_frame.rotate_item");
        public static final Supplier<class_3414> LIGHTROOM_PRINT = SoundEvents.register("block", "lightroom.print");

        private static Supplier<class_3414> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> class_3414.method_47908((class_2960)Exposure.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static final Supplier<class_2314<ExposureSizeArgument, class_2319.class_7219>> EXPOSURE_SIZE = Register.commandArgumentType("exposure_size", ExposureSizeArgument.class, class_2319.method_41999(ExposureSizeArgument::new));
        public static final Supplier<class_2314<ExposureLookArgument, class_2319.class_7219>> EXPOSURE_LOOK = Register.commandArgumentType("exposure_look", ExposureLookArgument.class, class_2319.method_41999(ExposureLookArgument::new));
        public static final Supplier<class_2314<ShaderLocationArgument, class_2319.class_7219>> SHADER_LOCATION = Register.commandArgumentType("shader_location", ShaderLocationArgument.class, class_2319.method_41999(ShaderLocationArgument::new));
        public static final Supplier<class_2314<TextureLocationArgument, class_2319.class_7219>> TEXTURE_LOCATION = Register.commandArgumentType("texture_location", TextureLocationArgument.class, class_2319.method_41999(TextureLocationArgument::new));

        public static void init() {
        }
    }

    public static class Tags {

        public static class Blocks {
            public static final class_6862<class_2248> CHROMATIC_REFRACTORS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Exposure.resource("chromatic_refractors"));
        }

        public static class Items {
            public static final class_6862<class_1792> FILM_ROLLS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("film_rolls"));
            public static final class_6862<class_1792> DEVELOPED_FILM_ROLLS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("developed_film_rolls"));
            public static final class_6862<class_1792> CYAN_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("cyan_printing_dyes"));
            public static final class_6862<class_1792> MAGENTA_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("magenta_printing_dyes"));
            public static final class_6862<class_1792> YELLOW_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("yellow_printing_dyes"));
            public static final class_6862<class_1792> BLACK_PRINTING_DYES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("black_printing_dyes"));
            public static final class_6862<class_1792> PHOTO_PAPERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("photo_papers"));
            public static final class_6862<class_1792> PHOTO_AGERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("photo_agers"));
            public static final class_6862<class_1792> FLASHES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("flashes"));
            public static final class_6862<class_1792> LENSES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("lenses"));
            public static final class_6862<class_1792> FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("filters"));
            public static final class_6862<class_1792> RED_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("red_filters"));
            public static final class_6862<class_1792> GREEN_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("green_filters"));
            public static final class_6862<class_1792> BLUE_FILTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Exposure.resource("blue_filters"));
        }
    }

    public static class Advancements {
        public static FrameExposedTrigger FILM_FRAME_EXPOSED = new FrameExposedTrigger();
        public static class_2135 PHOTOGRAPH_ENDERMAN_EYES = new class_2135(Exposure.resource("photograph_enderman_eyes"));

        public static void register() {
            class_174.method_767((class_179)FILM_FRAME_EXPOSED);
            class_174.method_767((class_179)PHOTOGRAPH_ENDERMAN_EYES);
        }
    }

    public static class Stats {
        private static final Map<class_2960, class_3446> STATS = new HashMap<class_2960, class_3446>();
        public static final class_2960 INTERACT_WITH_LIGHTROOM = Stats.register(Exposure.resource("interact_with_lightroom"), class_3446.field_16975);
        public static final class_2960 FILM_FRAMES_EXPOSED = Stats.register(Exposure.resource("film_frames_exposed"), class_3446.field_16975);
        public static final class_2960 FLASHES_TRIGGERED = Stats.register(Exposure.resource("flashes_triggered"), class_3446.field_16975);

        private static class_2960 register(class_2960 location, class_3446 formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)location, (Object)location);
                class_3468.field_15419.method_14955(location, formatter);
            });
        }
    }
}

