/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.block.FlashBlock;
import io.github.mortuusars.exposure.camera.AttachmentSound;
import io.github.mortuusars.exposure.camera.AttachmentType;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.CaptureManager;
import io.github.mortuusars.exposure.camera.capture.FileCapture;
import io.github.mortuusars.exposure.camera.capture.ScreenshotCapture;
import io.github.mortuusars.exposure.camera.capture.component.BaseComponent;
import io.github.mortuusars.exposure.camera.capture.component.BlackAndWhiteComponent;
import io.github.mortuusars.exposure.camera.capture.component.BrightnessComponent;
import io.github.mortuusars.exposure.camera.capture.component.ExposureStorageSaveComponent;
import io.github.mortuusars.exposure.camera.capture.component.FlashComponent;
import io.github.mortuusars.exposure.camera.capture.component.SelectiveChannelBlackAndWhiteComponent;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuide;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuides;
import io.github.mortuusars.exposure.camera.infrastructure.EntitiesInFrame;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.item.IFilmItem;
import io.github.mortuusars.exposure.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.OnFrameAddedS2CP;
import io.github.mortuusars.exposure.network.packet.client.StartExposureS2CP;
import io.github.mortuusars.exposure.network.packet.server.CameraAddFrameC2SP;
import io.github.mortuusars.exposure.network.packet.server.OpenCameraAttachmentsPacketC2SP;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import io.github.mortuusars.exposure.sound.OnePerPlayerSoundsClient;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.ColorChannel;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.LevelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1751;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1801;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraItem
extends class_1792 {
    public static final AttachmentType FILM_ATTACHMENT = new AttachmentType("Film", 0, stack -> stack.method_7909() instanceof FilmRollItem, AttachmentSound.FILM);
    public static final AttachmentType FLASH_ATTACHMENT = new AttachmentType("Flash", 1, stack -> stack.method_31573(Exposure.Tags.Items.FLASHES), AttachmentSound.FLASH);
    public static final AttachmentType LENS_ATTACHMENT = new AttachmentType("Lens", 2, stack -> stack.method_31573(Exposure.Tags.Items.LENSES), AttachmentSound.LENS);
    public static final AttachmentType FILTER_ATTACHMENT = new AttachmentType("Filter", 3, stack -> stack.method_31573(Exposure.Tags.Items.FILTERS), AttachmentSound.FILTER);
    public static final List<AttachmentType> ATTACHMENTS = List.of(FILM_ATTACHMENT, FLASH_ATTACHMENT, LENS_ATTACHMENT, FILTER_ATTACHMENT);
    public static final List<ShutterSpeed> SHUTTER_SPEEDS = List.of(new ShutterSpeed("15\""), new ShutterSpeed("8\""), new ShutterSpeed("4\""), new ShutterSpeed("2\""), new ShutterSpeed("1\""), new ShutterSpeed("2"), new ShutterSpeed("4"), new ShutterSpeed("8"), new ShutterSpeed("15"), new ShutterSpeed("30"), new ShutterSpeed("60"), new ShutterSpeed("125"), new ShutterSpeed("250"), new ShutterSpeed("500"));

    public CameraItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 1000;
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return false;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            FilmRollItem filmRollItem;
            class_1792 patt0$temp = f.method_7909();
            return patt0$temp instanceof FilmRollItem && (filmRollItem = (FilmRollItem)patt0$temp).method_31567((class_1799)f);
        }).orElse(false);
    }

    public int method_31569(@NotNull class_1799 stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return 0;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            Integer n;
            class_1792 patt0$temp = f.method_7909();
            if (patt0$temp instanceof FilmRollItem) {
                FilmRollItem filmRollItem = (FilmRollItem)patt0$temp;
                n = filmRollItem.method_31569((class_1799)f);
            } else {
                n = 0;
            }
            return n;
        }).orElse(0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return 0;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            Integer n;
            class_1792 patt0$temp = f.method_7909();
            if (patt0$temp instanceof FilmRollItem) {
                FilmRollItem filmRollItem = (FilmRollItem)patt0$temp;
                n = filmRollItem.method_31571((class_1799)f);
            } else {
                n = 0;
            }
            return n;
        }).orElse(0);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (otherStack.method_7960() && ((Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_ATTACHMENTS_SCREEN.get()).booleanValue()) {
            if (!(slot.field_7871 instanceof class_1661)) {
                return false;
            }
            if (player.method_7337() && player.method_37908().method_8608()) {
                Packets.sendToServer(new OpenCameraAttachmentsPacketC2SP(slot.method_34266()));
                return true;
            }
            this.openCameraAttachmentsMenu(player, slot.method_34266());
            return true;
        }
        if (PlatformHelper.canShear(otherStack) && !this.isTooltipRemoved(stack)) {
            if (otherStack.method_7963()) {
                otherStack.method_7956(1, (class_1309)player, pl -> pl.method_20236(class_1268.field_5808));
            }
            if (player.method_37908().field_9236) {
                player.method_43077(class_3417.field_14975);
            }
            this.setTooltipRemoved(stack, true);
            return true;
        }
        if (this.isTooltipRemoved(stack) && (otherStack.method_7909() instanceof class_1751 || otherStack.method_7909() instanceof class_1840 || otherStack.method_7909() instanceof class_1843 || otherStack.method_7909() instanceof class_1801)) {
            this.setTooltipRemoved(stack, false);
            if (player.method_37908().field_9236) {
                player.method_43077(class_3417.field_17484);
            }
            return true;
        }
        if (((Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get()).booleanValue()) {
            for (AttachmentType attachmentType : this.getAttachmentTypes(stack)) {
                if (!attachmentType.matches(otherStack)) continue;
                Optional<class_1799> current = this.getAttachment(stack, attachmentType);
                if (otherStack.method_7947() > 1 && current.isPresent()) {
                    if (player.method_37908().method_8608()) {
                        OnePerPlayerSoundsClient.play(player, Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), class_3419.field_15248, 0.9f, 1.0f);
                    }
                    return true;
                }
                this.setAttachment(stack, attachmentType, otherStack.method_7971(1));
                access.method_32332(current.orElse(otherStack));
                attachmentType.sound().playOnePerPlayer(player, false);
                return true;
            }
        }
        return false;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> components, @NotNull class_1836 isAdvanced) {
        if (((Boolean)Config.Client.CAMERA_SHOW_FILM_FRAMES_IN_TOOLTIP.get()).booleanValue()) {
            this.getAttachment(stack, FILM_ATTACHMENT).ifPresent(f -> {
                class_1792 patt0$temp = f.method_7909();
                if (patt0$temp instanceof FilmRollItem) {
                    FilmRollItem filmRollItem = (FilmRollItem)patt0$temp;
                    int exposed = filmRollItem.getExposedFramesCount((class_1799)f);
                    int max = filmRollItem.getMaxFrameCount((class_1799)f);
                    components.add((class_2561)class_2561.method_43469((String)"item.exposure.camera.tooltip.film_roll_frames", (Object[])new Object[]{exposed, max}));
                }
            });
        }
        if (!this.isTooltipRemoved(stack) && ((Boolean)Config.Client.CAMERA_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            boolean rClickAttachments = (Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_ATTACHMENTS_SCREEN.get();
            boolean rClickHotswap = (Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get();
            if (rClickAttachments || rClickHotswap) {
                if (class_437.method_25442()) {
                    if (rClickAttachments) {
                        components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_attachments_screen"));
                    }
                    if (rClickHotswap) {
                        components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_hotswap"));
                    }
                    components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_remove_tooltip"));
                } else {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
                }
            }
        }
    }

    public boolean isActive(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10577("Active");
    }

    public void setActive(class_1799 stack, boolean active) {
        stack.method_7948().method_10556("Active", active);
    }

    public void activate(class_1657 player, class_1799 stack) {
        if (!this.isActive(stack)) {
            this.setActive(stack, true);
            player.method_32876(class_5712.field_28739);
            this.playCameraSound(player, Exposure.SoundEvents.VIEWFINDER_OPEN.get(), 0.35f, 0.9f, 0.2f);
        }
    }

    public void deactivate(class_1657 player, class_1799 stack) {
        if (this.isActive(stack)) {
            this.setActive(stack, false);
            player.method_32876(class_5712.field_28739);
            this.playCameraSound(player, Exposure.SoundEvents.VIEWFINDER_CLOSE.get(), 0.35f, 0.9f, 0.2f);
        }
    }

    public boolean isInSelfieMode(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10577("Selfie");
    }

    public void setSelfieMode(class_1799 stack, boolean selfie) {
        stack.method_7948().method_10556("Selfie", selfie);
    }

    public boolean isTooltipRemoved(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10577("TooltipRemoved");
    }

    public void setTooltipRemoved(class_1799 stack, boolean removed) {
        stack.method_7948().method_10556("TooltipRemoved", removed);
    }

    public void setSelfieModeWithEffects(class_1657 player, class_1799 stack, boolean selfie) {
        if (this.isInSelfieMode(stack) != selfie) {
            this.setSelfieMode(stack, selfie);
            player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), class_3419.field_15248, 1.0f, 1.5f);
        }
    }

    public boolean isShutterOpen(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10577("ShutterOpen");
    }

    public void setShutterOpen(class_1937 level, class_1799 stack, ShutterSpeed shutterSpeed, boolean flashHasFired) {
        class_2487 tag = stack.method_7948();
        tag.method_10556("ShutterOpen", true);
        tag.method_10569("ShutterTicks", Math.max(shutterSpeed.getTicks(), 1));
        tag.method_10544("ShutterCloseTimestamp", level.method_8510() + (long)Math.max(shutterSpeed.getTicks(), 1));
        if (flashHasFired) {
            tag.method_10556("FlashHasFired", true);
        }
    }

    public void setShutterClosed(class_1799 stack) {
        @Nullable class_2487 tag = stack.method_7969();
        if (tag != null) {
            tag.method_10551("ShutterOpen");
            tag.method_10551("ShutterTicks");
            tag.method_10551("ShutterCloseTimestamp");
            tag.method_10551("ExposingFrame");
            tag.method_10551("FlashHasFired");
        }
    }

    public void openShutter(class_1657 player, class_1937 level, class_1799 stack, ShutterSpeed shutterSpeed, boolean flashHasFired) {
        this.setShutterOpen(player.method_37908(), stack, shutterSpeed, flashHasFired);
        player.method_32876(class_5712.field_28146);
        this.playCameraSound(null, player, Exposure.SoundEvents.SHUTTER_OPEN.get(), 0.7f, 1.1f, 0.2f);
        if (shutterSpeed.getMilliseconds() > 500.0f) {
            OnePerPlayerSounds.playForAllClients(player, Exposure.SoundEvents.SHUTTER_TICKING.get(), class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void closeShutter(class_1657 player, class_1799 stack) {
        long closedAtTimestamp = stack.method_7969() != null ? stack.method_7969().method_10537("ShutterCloseTimestamp") : -1L;
        boolean flashHasFired = stack.method_7969() != null && stack.method_7969().method_10577("FlashHasFired");
        this.setShutterClosed(stack);
        if (player.method_37908().method_8510() - closedAtTimestamp < 60L) {
            player.method_32876(class_5712.field_28146);
            player.method_7357().method_7906((class_1792)this, flashHasFired ? 10 : 2);
            this.playCameraSound(player, player, Exposure.SoundEvents.SHUTTER_CLOSE.get(), 0.7f, 1.1f, 0.2f);
            this.getFilm(stack).ifPresent(f -> {
                boolean lastFrame;
                float fullness = (float)((FilmRollItem)f.getItem()).getExposedFramesCount(f.getStack()) / (float)((FilmRollItem)f.getItem()).getMaxFrameCount(f.getStack());
                boolean bl = lastFrame = fullness == 1.0f;
                if (lastFrame) {
                    OnePerPlayerSounds.play(player, Exposure.SoundEvents.FILM_ADVANCE_LAST.get(), class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    OnePerPlayerSounds.play(player, Exposure.SoundEvents.FILM_ADVANCING.get(), class_3419.field_15248, 1.0f, 0.9f + 0.1f * fullness);
                }
            });
        }
    }

    public void playCameraSound(@NotNull class_1657 player, class_3414 sound, float volume, float pitch) {
        this.playCameraSound(player, sound, volume, pitch, 0.0f);
    }

    public void playCameraSound(@NotNull class_1657 player, class_3414 sound, float volume, float pitch, float pitchVariety) {
        this.playCameraSound(player, player, sound, volume, pitch, pitchVariety);
    }

    public void playCameraSound(@Nullable class_1657 player, @NotNull class_1657 originPlayer, class_3414 sound, float volume, float pitch, float pitchVariety) {
        if (pitchVariety > 0.0f) {
            pitch = pitch - pitchVariety / 2.0f + originPlayer.method_6051().method_43057() * pitchVariety;
        }
        originPlayer.method_37908().method_43129(player, (class_1297)originPlayer, sound, class_3419.field_15248, volume, pitch);
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        boolean inHand;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (this.isShutterOpen(stack)) {
            if (stack.method_7969() != null && stack.method_7969().method_10545("ShutterTicks")) {
                int ticks = stack.method_7969().method_10550("ShutterTicks");
                if (ticks <= 0) {
                    this.closeShutter(player, stack);
                } else {
                    stack.method_7969().method_10569("ShutterTicks", --ticks);
                }
            } else {
                this.closeShutter(player, stack);
            }
        }
        boolean inOffhand = player.method_6079().equals(stack);
        boolean bl = inHand = isSelected || inOffhand;
        if (!inHand) {
            this.deactivate(player, stack);
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null) {
            class_1268 hand = context.method_20287();
            if (hand == class_1268.field_5808 && Camera.getCamera(player).filter(c -> c instanceof CameraInHand).map(c -> ((CameraInHand)c).getHand() == class_1268.field_5810).orElse(false).booleanValue()) {
                return class_1269.field_5811;
            }
            return this.useCamera(player, hand);
        }
        return class_1269.field_21466;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        if (hand == class_1268.field_5808 && Camera.getCamera(player).filter(c -> c instanceof CameraInHand).map(c -> ((CameraInHand)c).getHand() == class_1268.field_5810).orElse(false).booleanValue()) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        this.useCamera(player, hand);
        return class_1271.method_22428((Object)player.method_5998(hand));
    }

    public class_1269 useCamera(class_1657 player, class_1268 hand) {
        if (player.method_7357().method_7904((class_1792)this)) {
            return class_1269.field_5814;
        }
        class_1799 cameraStack = player.method_5998(hand);
        if (cameraStack.method_7960() || cameraStack.method_7909() != this) {
            return class_1269.field_5811;
        }
        boolean active = this.isActive(cameraStack);
        if (!active && player.method_21823()) {
            if (this.isShutterOpen(cameraStack)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"item.exposure.camera.camera_attachments.fail.shutter_open").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            int cameraSlot = this.getMatchingSlotInInventory(player.method_31548(), cameraStack);
            if (cameraSlot < 0) {
                return class_1269.field_5814;
            }
            this.openCameraAttachmentsMenu(player, cameraSlot);
            return class_1269.field_5812;
        }
        if (!active) {
            this.activate(player, cameraStack);
            player.method_7357().method_7906((class_1792)this, 4);
            if (player.method_37908().field_9236) {
                CameraItemClientExtensions.releaseUseButton();
            }
            return class_1269.field_21466;
        }
        if (!(player instanceof class_3222)) {
            return class_1269.field_21466;
        }
        this.playCameraSound(null, player, Exposure.SoundEvents.CAMERA_RELEASE_BUTTON_CLICK.get(), 0.3f, 1.0f, 0.1f);
        Optional<ItemAndStack<FilmRollItem>> filmAttachment = this.getFilm(cameraStack);
        if (filmAttachment.isEmpty()) {
            return class_1269.field_5814;
        }
        ItemAndStack<FilmRollItem> film = filmAttachment.get();
        boolean exposingFilm = film.getItem().canAddFrame(film.getStack());
        if (!exposingFilm) {
            return class_1269.field_5814;
        }
        if (this.isShutterOpen(cameraStack)) {
            return class_1269.field_5814;
        }
        int lightLevel = LevelUtil.getLightLevelAt(player.method_37908(), player.method_24515());
        boolean shouldFlashFire = this.shouldFlashFire(player, cameraStack, lightLevel);
        ShutterSpeed shutterSpeed = this.getShutterSpeed(cameraStack);
        if (PlatformHelper.fireShutterOpeningEvent(player, cameraStack, lightLevel, shouldFlashFire)) {
            return class_1269.field_5814;
        }
        boolean flashHasFired = shouldFlashFire && this.tryUseFlash(player, cameraStack);
        this.openShutter(player, player.method_37908(), cameraStack, shutterSpeed, flashHasFired);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Packets.sendToClient(new StartExposureS2CP(this.createExposureId(player), hand, flashHasFired, lightLevel), serverPlayer);
        }
        return class_1269.field_21466;
    }

    public void exposeFrameClientside(class_1657 player, class_1268 hand, String exposureId, boolean flashHasFired, int lightLevel) {
        Preconditions.checkState((boolean)player.method_37908().field_9236, (Object)"Should only be called on client.");
        class_1799 cameraStack = player.method_5998(hand);
        if (PlatformHelper.fireShutterOpeningEvent(player, cameraStack, lightLevel, flashHasFired)) {
            return;
        }
        boolean projectingFile = this.hasInterplanarProjectorFilter(cameraStack) && ExposureClient.isShaderActive();
        class_2487 frame = new class_2487();
        if (projectingFile) {
            frame.method_10556("Projected", true);
        }
        frame.method_10582("Id", exposureId);
        frame.method_10582("Timestamp", class_156.method_44893());
        if (!projectingFile) {
            boolean isBW;
            frame.method_10569("FocalLength", class_3532.method_15386((float)this.getFocalLength(cameraStack)));
            frame.method_10569("LightLevel", lightLevel);
            frame.method_10548("SunAngle", player.method_37908().method_8442(0.0f));
            if (flashHasFired) {
                frame.method_10556("Flash", true);
            }
            if (this.isInSelfieMode(cameraStack)) {
                frame.method_10556("Selfie", true);
            }
            if (ExposureClient.isShaderActive() && (isBW = this.getAttachment(cameraStack, FILM_ATTACHMENT).map(f -> {
                IFilmItem filmItem;
                class_1792 patt0$temp = f.method_7909();
                return patt0$temp instanceof IFilmItem && (filmItem = (IFilmItem)patt0$temp).getType() == FilmType.BLACK_AND_WHITE;
            }).orElse(false).booleanValue())) {
                this.getAttachment(cameraStack, FILTER_ATTACHMENT).flatMap(ColorChannel::fromStack).ifPresent(c -> {
                    frame.method_10556("Chromatic", true);
                    frame.method_10582("ChromaticChannel", c.method_15434());
                });
            }
        }
        List<UUID> entitiesInFrame = projectingFile ? Collections.emptyList() : EntitiesInFrame.get(player, Viewfinder.getCurrentFov(), 12, this.isInSelfieMode(cameraStack)).stream().map(class_1297::method_5667).toList();
        Packets.sendToServer(new CameraAddFrameC2SP(hand, frame, entitiesInFrame));
        this.startCapture(player, cameraStack, exposureId, flashHasFired);
    }

    protected void startCapture(class_1657 player, class_1799 cameraStack, String exposureId, boolean flashHasFired) {
        Capture capture;
        Optional<ItemAndStack> projector = this.getAttachment(cameraStack, FILTER_ATTACHMENT).map(filter -> filter.method_7909() instanceof InterplanarProjectorItem ? new ItemAndStack((class_1799)filter) : null);
        if (projector.isPresent() && ExposureClient.isShaderActive()) {
            ItemAndStack filter2 = projector.get();
            String filepath = ((InterplanarProjectorItem)((Object)filter2.getItem())).getFilename(filter2.getStack()).orElse("");
            capture = this.createFileCapture(player, cameraStack, exposureId, filepath, ((InterplanarProjectorItem)((Object)filter2.getItem())).isDithered(filter2.getStack())).onCapturingFailed(() -> {
                Capture regularCapture = this.createRegularCapture(player, cameraStack, exposureId, flashHasFired);
                regularCapture.onImageCaptured(() -> class_310.method_1551().execute(() -> {
                    player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), class_3419.field_15248, 0.8f, 0.6f);
                    for (int i = 0; i < 32; ++i) {
                        player.method_37908().method_8406((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + player.method_6051().method_43058() * 2.0, player.method_23321(), player.method_6051().method_43059(), 0.0, player.method_6051().method_43059());
                    }
                }));
                CaptureManager.enqueue(regularCapture);
            }).onImageCaptured(() -> class_310.method_1551().execute(() -> {
                player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), class_3419.field_15248, 0.8f, 1.1f);
                for (int i = 0; i < 32; ++i) {
                    player.method_37908().method_8406((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + player.method_6051().method_43058() * 2.0, player.method_23321(), player.method_6051().method_43059(), 0.0, player.method_6051().method_43059());
                }
            }));
        } else {
            capture = this.createRegularCapture(player, cameraStack, exposureId, flashHasFired);
            if (flashHasFired) {
                capture.onImageCaptured(() -> this.spawnClientsideFlashEffects(player, cameraStack));
            }
        }
        CaptureManager.enqueue(capture);
    }

    protected Capture createRegularCapture(class_1657 player, class_1799 cameraStack, String exposureId, boolean flash) {
        ItemAndStack<FilmRollItem> film = this.getFilm(cameraStack).orElseThrow();
        int frameSize = film.getItem().getFrameSize(film.getStack());
        float brightnessStops = this.getShutterSpeed(cameraStack).getStopsDifference(ShutterSpeed.DEFAULT);
        Capture capture = new ScreenshotCapture().setFilmType(film.getItem().getType()).setSize(frameSize).setBrightnessStops(brightnessStops).setConverter(new DitheringColorConverter());
        capture.addComponent(new BaseComponent());
        capture.addComponent(new ExposureStorageSaveComponent(exposureId, true));
        if (flash) {
            capture.addComponent(new FlashComponent());
        }
        if (brightnessStops != 0.0f) {
            capture.addComponent(new BrightnessComponent(brightnessStops));
        }
        if (film.getItem().getType() == FilmType.BLACK_AND_WHITE) {
            Optional<class_1799> filter = this.getAttachment(cameraStack, FILTER_ATTACHMENT);
            filter.flatMap(ColorChannel::fromStack).ifPresentOrElse(channel -> capture.addComponent(new SelectiveChannelBlackAndWhiteComponent((ColorChannel)((Object)channel))), () -> capture.addComponent(new BlackAndWhiteComponent()));
        }
        return capture;
    }

    protected Capture createFileCapture(class_1657 player, class_1799 cameraStack, String exposureId, String filepath, boolean dither) {
        ItemAndStack<FilmRollItem> film = this.getFilm(cameraStack).orElseThrow();
        FilmType filmType = film.getItem().getType();
        int frameSize = film.getItem().getFrameSize(film.getStack());
        Capture capture = new FileCapture(filepath, error -> player.method_7353((class_2561)error.getCasualTranslation().method_27692(class_124.field_1061), false)).setFilmType(filmType).setSize(frameSize).addComponent(new ExposureStorageSaveComponent(exposureId, true)).setConverter(dither ? new DitheringColorConverter() : new SimpleColorConverter()).cropFactor(1.0f).setAsyncCapturing(true);
        if (filmType == FilmType.BLACK_AND_WHITE) {
            capture.addComponent(new BlackAndWhiteComponent());
        }
        return capture;
    }

    public void addFrame(class_3222 player, class_1799 cameraStack, class_2487 frameTag, List<class_1297> entities) {
        frameTag.method_10582("Photographer", player.method_5820());
        frameTag.method_25927("PhotographerId", player.method_5667());
        if (!frameTag.method_10577("Projected")) {
            this.addFrameData(player, cameraStack, frameTag, entities);
        }
        PlatformHelper.fireModifyFrameDataEvent(player, cameraStack, frameTag, entities);
        player.method_7281(Exposure.Stats.FILM_FRAMES_EXPOSED);
        Exposure.Advancements.FILM_FRAME_EXPOSED.trigger(player, new ItemAndStack<CameraItem>(cameraStack), frameTag, entities);
        this.addFrameToFilm(cameraStack, frameTag);
        this.onFrameAdded(player, cameraStack, frameTag, entities);
        PlatformHelper.fireFrameAddedEvent(player, cameraStack, frameTag);
        Packets.sendToClient(new OnFrameAddedS2CP(frameTag), player);
    }

    public void onFrameAdded(class_3222 player, class_1799 cameraStack, class_2487 frame, List<class_1297> entities) {
        if (frame.method_10577("Projected")) {
            this.getAttachment(cameraStack, FILTER_ATTACHMENT).ifPresent(filter -> {
                class_1792 patt0$temp = filter.method_7909();
                if (!(patt0$temp instanceof InterplanarProjectorItem)) {
                    return;
                }
                InterplanarProjectorItem interplanarProjector = (InterplanarProjectorItem)patt0$temp;
                player.method_37908().method_43129((class_1657)player, (class_1297)player, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), class_3419.field_15248, 0.8f, 1.0f);
                if (interplanarProjector.isConsumable((class_1799)filter)) {
                    filter.method_7934(1);
                    this.setAttachment(cameraStack, FILTER_ATTACHMENT, (class_1799)filter);
                }
            });
        }
    }

    public void addFrameToFilm(class_1799 cameraStack, class_2487 frame) {
        ItemAndStack<FilmRollItem> film = this.getFilm(cameraStack).orElseThrow(() -> new IllegalStateException("Camera should have film inserted. " + String.valueOf(cameraStack)));
        film.getItem().addFrame(film.getStack(), frame);
        this.setFilm(cameraStack, film.getStack());
    }

    protected boolean shouldFlashFire(class_1657 player, class_1799 cameraStack, int lightLevel) {
        if (this.getAttachment(cameraStack, FLASH_ATTACHMENT).isEmpty()) {
            return false;
        }
        return switch (this.getFlashMode(cameraStack)) {
            default -> throw new IncompatibleClassChangeError();
            case FlashMode.OFF -> false;
            case FlashMode.ON -> true;
            case FlashMode.AUTO -> lightLevel < 8;
        };
    }

    public boolean tryUseFlash(class_1657 player, class_1799 cameraStack) {
        class_1937 level = player.method_37908();
        class_2338 playerHeadPos = player.method_24515().method_10084();
        class_2338 flashPos = null;
        if (level.method_8320(playerHeadPos).method_26215() || level.method_8316(playerHeadPos).method_33659((class_3611)class_3612.field_15910)) {
            flashPos = playerHeadPos;
        } else {
            for (class_2350 direction : class_2350.values()) {
                class_2338 pos = playerHeadPos.method_10093(direction);
                if (!level.method_8320(pos).method_26215() && !level.method_8316(pos).method_33659((class_3611)class_3612.field_15910)) continue;
                flashPos = pos;
            }
        }
        if (flashPos == null) {
            return false;
        }
        level.method_8652(flashPos, (class_2680)Exposure.Blocks.FLASH.get().method_9564().method_11657((class_2769)FlashBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(flashPos).method_33659((class_3611)class_3612.field_15910))), 11);
        level.method_43129(null, (class_1297)player, Exposure.SoundEvents.FLASH.get(), class_3419.field_15248, 1.0f, 1.0f);
        player.method_32876(class_5712.field_28727);
        player.method_7281(Exposure.Stats.FLASHES_TRIGGERED);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_243 pos = player.method_19538();
                pos = pos.method_1031(0.0, 1.0, 0.0).method_1019(player.method_5720().method_18805(0.5, 0.0, 0.5));
                class_2675 packet = new class_2675((class_2394)class_2398.field_17909, false, pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f, 0.0f, 0.0f, 0);
                for (class_3222 pl : serverLevel.method_18456()) {
                    if (pl.equals((Object)serverPlayer)) continue;
                    pl.field_13987.method_14364((class_2596)packet);
                    class_5819 r = serverLevel.method_8409();
                    for (int i = 0; i < 4; ++i) {
                        pl.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_11207, false, pos.field_1352 + (double)(r.method_43057() * 0.5f) - 0.25, pos.field_1351 + (double)(r.method_43057() * 0.5f) + (double)0.2f, pos.field_1350 + (double)(r.method_43057() * 0.5f) - 0.25, 0.0f, 0.0f, 0.0f, 0.0f, 0));
                    }
                }
            }
        }
        return true;
    }

    public void addFrameData(class_3222 player, class_1799 cameraStack, class_2487 frame, List<class_1297> entitiesInFrame) {
        class_1937 level = player.method_37908();
        class_2499 pos = new class_2499();
        pos.add((Object)class_2497.method_23247((int)player.method_24515().method_10263()));
        pos.add((Object)class_2497.method_23247((int)player.method_24515().method_10264()));
        pos.add((Object)class_2497.method_23247((int)player.method_24515().method_10260()));
        frame.method_10566("Pos", (class_2520)pos);
        frame.method_10569("DayTime", (int)level.method_8532());
        frame.method_10582("Dimension", player.method_37908().method_27983().method_29177().toString());
        player.method_37908().method_23753(player.method_24515()).method_40230().map(class_5321::method_29177).ifPresent(biome -> frame.method_10582("Biome", biome.toString()));
        int surfaceHeight = level.method_8624(class_2902.class_2903.field_13194, player.method_31477(), player.method_31479());
        level.method_8533();
        int skyLight = level.method_8314(class_1944.field_9284, player.method_24515());
        if (player.method_5869()) {
            frame.method_10556("Underwater", true);
        }
        if (player.method_31478() < surfaceHeight && skyLight < 2) {
            frame.method_10556("InCave", true);
        } else if (!player.method_5869()) {
            class_1959.class_1963 precipitation = ((class_1959)level.method_23753(player.method_24515()).comp_349()).method_48162(player.method_24515());
            if (level.method_8546() && precipitation != class_1959.class_1963.field_9384) {
                frame.method_10582("Weather", precipitation == class_1959.class_1963.field_9383 ? "Snowstorm" : "Thunder");
            } else if (level.method_8419() && precipitation != class_1959.class_1963.field_9384) {
                frame.method_10582("Weather", precipitation == class_1959.class_1963.field_9383 ? "Snow" : "Rain");
            } else {
                frame.method_10582("Weather", "Clear");
            }
        }
        this.addStructuresInfo(player, frame);
        if (!entitiesInFrame.isEmpty()) {
            class_2499 entities = new class_2499();
            for (class_1297 entity : entitiesInFrame) {
                class_2487 entityInfoTag;
                class_1560 enderMan;
                if (entity instanceof class_1560 && player.equals((Object)(enderMan = (class_1560)entity).method_5968()) && enderMan.method_7026((class_1657)player)) {
                    Exposure.Advancements.PHOTOGRAPH_ENDERMAN_EYES.method_9141(player);
                }
                if ((entityInfoTag = this.createEntityInFrameTag(entity, (class_1657)player, cameraStack)).method_33133()) continue;
                entities.add((Object)entityInfoTag);
                frame.method_10556(entityInfoTag.method_10558("Id"), true);
            }
            if (!entities.isEmpty()) {
                frame.method_10566("Entities", (class_2520)entities);
            }
        }
    }

    protected void addStructuresInfo(@NotNull class_3222 player, class_2487 frame) {
        Map allStructuresAt = player.method_51469().method_27056().method_41037(player.method_24515());
        ArrayList<class_3195> inside = new ArrayList<class_3195>();
        for (class_3195 structure : allStructuresAt.keySet()) {
            class_3449 structureAt = player.method_51469().method_27056().method_28388(player.method_24515(), structure);
            if (!structureAt.method_16657()) continue;
            inside.add(structure);
        }
        class_2378 structures = player.method_51469().method_30349().method_30530(class_7924.field_41246);
        class_2499 structuresTag = new class_2499();
        for (class_3195 structure : inside) {
            class_2960 key = structures.method_10221((Object)structure);
            if (key == null) continue;
            structuresTag.add((Object)class_2519.method_23256((String)key.toString()));
        }
        if (!structuresTag.isEmpty()) {
            frame.method_10566("Structures", (class_2520)structuresTag);
        }
    }

    protected class_2487 createEntityInFrameTag(class_1297 entity, class_1657 photographer, class_1799 cameraStack) {
        class_2487 tag = new class_2487();
        class_2960 entityRL = class_7923.field_41177.method_10221((Object)entity.method_5864());
        tag.method_10582("Id", entityRL.toString());
        class_2499 pos = new class_2499();
        pos.add((Object)class_2497.method_23247((int)((int)entity.method_23317())));
        pos.add((Object)class_2497.method_23247((int)((int)entity.method_23318())));
        pos.add((Object)class_2497.method_23247((int)((int)entity.method_23321())));
        tag.method_10566("Pos", (class_2520)pos);
        tag.method_10548("Distance", photographer.method_5739(entity));
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            tag.method_10582("Name", player.method_5820());
        }
        return tag;
    }

    public void openCameraAttachmentsMenu(class_1657 player, final int cameraSlotIndex) {
        final class_1799 stack = player.method_31548().method_5438(cameraSlotIndex);
        Preconditions.checkState((boolean)(stack.method_7909() instanceof CameraItem), (Object)("Cannot open Camera Attachments UI: " + String.valueOf(stack) + " is not a CameraItem."));
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_3908 menuProvider = new class_3908(){

                @NotNull
                public class_2561 method_5476() {
                    return stack.method_7938() ? stack.method_7964() : class_2561.method_43471((String)"container.exposure.camera");
                }

                @NotNull
                public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                    return new CameraAttachmentsMenu(containerId, playerInventory, cameraSlotIndex);
                }
            };
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.writeInt(cameraSlotIndex));
        }
    }

    protected int getMatchingSlotInInventory(class_1661 inventory, class_1799 stack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }

    protected String createExposureId(class_1657 player) {
        return player.method_5477().getString() + "_" + player.method_37908().method_8510();
    }

    public FocalRange getFocalRange(class_1799 cameraStack) {
        return this.getAttachment(cameraStack, LENS_ATTACHMENT).map(FocalRange::ofStack).orElse(this.getDefaultFocalRange());
    }

    public FocalRange getDefaultFocalRange() {
        return FocalRange.getDefault();
    }

    public void spawnClientsideFlashEffects(@NotNull class_1657 player, class_1799 cameraStack) {
        Preconditions.checkState((boolean)player.method_37908().field_9236, (Object)"This methods should only be called client-side.");
        class_1937 level = player.method_37908();
        class_243 pos = player.method_19538();
        class_243 lookAngle = player.method_5720();
        pos = pos.method_1031(0.0, 1.0, 0.0).method_1019(lookAngle.method_18805((double)0.8f, (double)0.8f, (double)0.8f));
        class_5819 r = level.method_8409();
        for (int i = 0; i < 3; ++i) {
            level.method_8406((class_2394)class_2398.field_11207, pos.field_1352 + (double)r.method_43057() - 0.5, pos.field_1351 + (double)r.method_43057() + (double)0.15f, pos.field_1350 + (double)r.method_43057() - 0.5, lookAngle.field_1352 * (double)0.025f + (double)(r.method_43057() * 0.025f), lookAngle.field_1351 * (double)0.025f + (double)(r.method_43057() * 0.025f), lookAngle.field_1350 * (double)0.025f + (double)(r.method_43057() * 0.025f));
        }
    }

    public List<AttachmentType> getAttachmentTypes(class_1799 cameraStack) {
        return ATTACHMENTS;
    }

    public Optional<AttachmentType> getAttachmentTypeForSlot(class_1799 cameraStack, int slot) {
        List<AttachmentType> attachmentTypes = this.getAttachmentTypes(cameraStack);
        for (AttachmentType attachmentType : attachmentTypes) {
            if (attachmentType.slot() != slot) continue;
            return Optional.of(attachmentType);
        }
        return Optional.empty();
    }

    public Optional<ItemAndStack<FilmRollItem>> getFilm(class_1799 cameraStack) {
        return this.getAttachment(cameraStack, FILM_ATTACHMENT).map(ItemAndStack::new);
    }

    public void setFilm(class_1799 cameraStack, class_1799 filmStack) {
        this.setAttachment(cameraStack, FILM_ATTACHMENT, filmStack);
    }

    public Optional<class_1799> getAttachment(class_1799 cameraStack, AttachmentType attachmentType) {
        class_1799 itemStack;
        if (cameraStack.method_7969() != null && cameraStack.method_7969().method_10573(attachmentType.id(), 10) && !(itemStack = class_1799.method_7915((class_2487)cameraStack.method_7969().method_10562(attachmentType.id()))).method_7960()) {
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    public void setAttachment(class_1799 cameraStack, AttachmentType attachmentType, class_1799 attachmentStack) {
        Preconditions.checkState((attachmentStack.method_7960() || attachmentType.matches(attachmentStack) ? 1 : 0) != 0, (Object)(String.valueOf(attachmentStack) + " is not valid for the '" + String.valueOf(attachmentType) + "' attachment type."));
        class_2487 cameraTag = cameraStack.method_7948();
        boolean hasChanged = this.getAttachment(cameraStack, attachmentType).map(stack -> !stack.equals(attachmentStack)).orElse(!attachmentStack.method_7960());
        if (attachmentStack.method_7960()) {
            cameraTag.method_10551(attachmentType.id());
        } else {
            cameraTag.method_10566(attachmentType.id(), (class_2520)attachmentStack.method_7953(new class_2487()));
        }
        if (hasChanged) {
            this.onAttachmentChanged(cameraStack, attachmentType);
        }
    }

    public void onAttachmentChanged(class_1799 cameraStack, AttachmentType attachmentType) {
        if (attachmentType == LENS_ATTACHMENT) {
            this.setZoom(cameraStack, this.getFocalRange(cameraStack).min());
        }
    }

    public List<ShutterSpeed> getAllShutterSpeeds(class_1799 cameraStack) {
        return SHUTTER_SPEEDS;
    }

    public ShutterSpeed getShutterSpeed(class_1799 cameraStack) {
        return ShutterSpeed.loadOrDefault(cameraStack.method_7948());
    }

    public void setShutterSpeed(class_1799 cameraStack, ShutterSpeed shutterSpeed) {
        shutterSpeed.save(cameraStack.method_7948());
    }

    public float getFocalLength(class_1799 cameraStack) {
        return cameraStack.method_7985() ? cameraStack.method_7948().method_10583("Zoom") : (float)this.getFocalRange(cameraStack).min();
    }

    public void setZoom(class_1799 cameraStack, double focalLength) {
        cameraStack.method_7948().method_10549("Zoom", focalLength);
    }

    public CompositionGuide getCompositionGuide(class_1799 cameraStack) {
        if (!cameraStack.method_7985() || !cameraStack.method_7948().method_10573("CompositionGuide", 8)) {
            return CompositionGuides.NONE;
        }
        return CompositionGuides.byIdOrNone(cameraStack.method_7948().method_10558("CompositionGuide"));
    }

    public void setCompositionGuide(class_1799 cameraStack, CompositionGuide guide) {
        cameraStack.method_7948().method_10582("CompositionGuide", guide.getId());
    }

    public FlashMode getFlashMode(class_1799 cameraStack) {
        if (!cameraStack.method_7985() || !cameraStack.method_7948().method_10573("FlashMode", 8)) {
            return FlashMode.OFF;
        }
        return FlashMode.byIdOrOff(cameraStack.method_7948().method_10558("FlashMode"));
    }

    public void setFlashMode(class_1799 cameraStack, FlashMode flashMode) {
        cameraStack.method_7948().method_10582("FlashMode", flashMode.getId());
    }

    public boolean hasInterplanarProjectorFilter(class_1799 cameraStack) {
        return this.getAttachment(cameraStack, FILTER_ATTACHMENT).map(stack -> stack.method_7909() instanceof InterplanarProjectorItem).orElse(false);
    }
}

