/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.render.image.RenderedImageProvider;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ExposureRenderer
implements AutoCloseable {
    private final Map<String, ExposureInstance> cache = new HashMap<String, ExposureInstance>();

    public int getSize() {
        return 256;
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        this.render(imageProvider, modifier, poseStack, bufferSource, 0.0f, 0.0f, this.getSize(), this.getSize(), packedLight, r, g, b, a);
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, class_4587 poseStack, class_4597 bufferSource, float x, float y, float width, float height, int packedLight, int r, int g, int b, int a) {
        this.render(imageProvider, modifier, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, class_4587 poseStack, class_4597 bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        this.getOrCreateExposureInstance(imageProvider, modifier).draw(poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
    }

    private ExposureInstance getOrCreateExposureInstance(RenderedImageProvider imageProvider, IPixelModifier modifier) {
        String instanceId = imageProvider.getInstanceId() + modifier.getIdSuffix();
        return this.cache.compute(instanceId, (expId, expData) -> {
            if (expData == null) {
                return new ExposureInstance((String)expId, imageProvider.get(), modifier);
            }
            expData.replaceData(imageProvider.get());
            return expData;
        });
    }

    public void clearData() {
        for (ExposureInstance instance : this.cache.values()) {
            instance.close();
        }
        this.cache.clear();
    }

    public void clearDataSingle(@NotNull String exposureId, boolean allVariants) {
        Iterator<Map.Entry<String, ExposureInstance>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ExposureInstance> entry = it.next();
            if (!(allVariants ? entry.getKey().startsWith(exposureId) : entry.getKey().equals(exposureId))) continue;
            entry.getValue().close();
            it.remove();
            if (allVariants) continue;
            break;
        }
    }

    @Override
    public void close() {
        this.clearData();
    }

    static class ExposureInstance
    implements AutoCloseable {
        private final class_1921 renderType;
        private IImage exposure;
        private class_1043 texture;
        private final IPixelModifier pixelModifier;
        private boolean requiresUpload = true;

        ExposureInstance(String id, IImage exposure, IPixelModifier modifier) {
            this.exposure = exposure;
            this.texture = new class_1043(exposure.getWidth(), exposure.getHeight(), true);
            this.pixelModifier = modifier;
            String textureId = ExposureInstance.createTextureId(id);
            class_2960 resourcelocation = class_310.method_1551().method_1531().method_4617(textureId, this.texture);
            this.renderType = class_1921.method_23028((class_2960)resourcelocation);
        }

        private static String createTextureId(String exposureId) {
            Object id = "exposure/" + exposureId.toLowerCase();
            id = ((String)id).replace(':', '_');
            Pattern pattern = Pattern.compile("[^a-z0-9_.-]");
            Matcher matcher = pattern.matcher((CharSequence)id);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, String.valueOf(matcher.group().hashCode()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private void replaceData(IImage exposure) {
            boolean hasChanged = !this.exposure.getImageId().equals(exposure.getImageId());
            this.exposure = exposure;
            if (hasChanged) {
                this.texture = new class_1043(exposure.getWidth(), exposure.getHeight(), true);
            }
            this.requiresUpload |= hasChanged;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            if (this.texture.method_4525() == null) {
                return;
            }
            for (int y = 0; y < this.exposure.getHeight(); ++y) {
                for (int x = 0; x < this.exposure.getWidth(); ++x) {
                    int ABGR = this.exposure.getPixelABGR(x, y);
                    ABGR = this.pixelModifier.modifyPixel(ABGR);
                    this.texture.method_4525().method_4305(x, y, ABGR);
                }
            }
            this.texture.method_4524();
        }

        void draw(class_4587 poseStack, class_4597 bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            class_4588 vertexconsumer = bufferSource.getBuffer(this.renderType);
            vertexconsumer.method_22918(matrix4f, minX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(minU, maxV).method_22916(packedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, maxX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, maxV).method_22916(packedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, maxX, minY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, minV).method_22916(packedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, minX, minY, 0.0f).method_1336(r, g, b, a).method_22913(minU, minV).method_22916(packedLight).method_1344();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

