/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class PhotographEntityRenderer<T extends PhotographEntity>
extends class_897<T> {
    public PhotographEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull T pEntity) {
        return class_1723.field_21668;
    }

    public boolean shouldRender(T livingEntity, class_4604 camera, double camX, double camY, double camZ) {
        return super.method_3933(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)((PhotographEntity)((Object)entity)).getRotation() * 360.0f / 4.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22904(-0.5, -0.5, 0.02625);
        float scale = 1.0f / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.method_22905(scale, scale, -scale);
        boolean isGlowing = ((PhotographEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        class_1799 item = ((PhotographEntity)((Object)entity)).getItem();
        PhotographRenderer.render(item, !entity.method_5767(), true, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.method_22909();
    }

    public int getPhotographBrightness(T entity) {
        if (entity.method_5735() == class_2350.field_11036) {
            return 255;
        }
        int lightLevel = entity.method_37908().method_8314(class_1944.field_9282, entity.method_24515());
        float shadeFactor = entity.method_37908().method_24852(entity.method_5735(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.05f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.7f));
        return Math.min(255, shadedBrightness + lightUp);
    }
}

