/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.entity.model.predicates.AltitudeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.AndEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BabyEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BiomeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.DimensionEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import com.supermartijn642.fusion.entity.model.predicates.NotEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.OrEntityModelPredicate;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.PredicateRegistryImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");
    private static final RenderMaterial[] RENDER_MATERIALS = new RenderMaterial[(6 | BaseTextureData.RenderType.values().length << 3) + 1];
    private static String fusionVersion;

    public void onInitializeClient() {
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "base"), DefaultTextureTypes.BASE);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "scrolling"), DefaultTextureTypes.SCROLLING);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "random"), DefaultTextureTypes.RANDOM);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "continuous"), DefaultTextureTypes.CONTINUOUS);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "base"), DefaultModelTypes.BASE);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_direction"), IsDirectionConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_block_in_front"), MatchBlockInFrontConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_state"), MatchStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_state_in_front"), MatchStateInFrontConnectionPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "and"), AndItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "or"), OrItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "not"), NotItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "count"), CountItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "durability"), DurabilityItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "enchantment"), EnchantmentItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new class_2960("fusion", "potion"), PotionItemPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "and"), AndEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "or"), OrEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "not"), NotEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "altitude"), AltitudeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "is_baby"), BabyEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "biome"), BiomeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new class_2960("fusion", "dimension"), DimensionEntityModelPredicate.SERIALIZER);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> TextureTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> ModelTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> PredicateRegistryImpl.finalizeRegistration());
    }

    public static RenderMaterial getRenderTypeMaterial(Boolean ambientOcclusion, BaseTextureData.RenderType renderType, boolean emissive) {
        int index = (ambientOcclusion == null ? 2 : (ambientOcclusion != false ? 1 : 0)) | (emissive ? 1 : 0) << 2 | (renderType == null ? 0 : renderType.ordinal() + 1) << 3;
        RenderMaterial material = RENDER_MATERIALS[index];
        if (material == null) {
            MaterialFinder materialFinder = RendererAccess.INSTANCE.getRenderer().materialFinder();
            if (ambientOcclusion != null) {
                materialFinder.ambientOcclusion(ambientOcclusion != false ? TriState.TRUE : TriState.FALSE);
            }
            if (renderType != null) {
                BlendMode mode = renderType == BaseTextureData.RenderType.OPAQUE ? BlendMode.SOLID : (renderType == BaseTextureData.RenderType.CUTOUT ? BlendMode.CUTOUT : (renderType == BaseTextureData.RenderType.TRANSLUCENT ? BlendMode.TRANSLUCENT : null));
                materialFinder.blendMode(mode);
            }
            if (emissive) {
                materialFinder.emissive(true);
            }
            FusionClient.RENDER_MATERIALS[index] = material = materialFinder.find();
        }
        return material;
    }

    public static String getFusionVersion() {
        if (fusionVersion == null) {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("fusion").orElseThrow()).getMetadata().getVersion().getFriendlyString();
            if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
                version = version.substring(0, version.length() - version.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
            }
            fusionVersion = version;
        }
        return fusionVersion;
    }
}

