/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicate;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PotionItemPredicate
implements ItemPredicate {
    public static final Serializer<PotionItemPredicate> SERIALIZER = new Serializer<PotionItemPredicate>(){

        @Override
        public PotionItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("potion") && json.get("potion").isJsonPrimitive() && json.getAsJsonPrimitive("potion").isString())) {
                throw new JsonParseException("Potion-predicate must have string property 'enchantment'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("potion").getAsString())) {
                throw new JsonParseException("Property 'enchantment' must be a valid identifier, not '" + json.get("potion").getAsString() + "'!");
            }
            class_2960 potionIdentifier = new class_2960(json.get("potion").getAsString());
            class_1842 potion = (class_1842)class_7923.field_41179.method_10223(potionIdentifier);
            if (potion == null || potion == class_1847.field_8984) {
                throw new JsonParseException("Unknown potion '" + String.valueOf(potionIdentifier) + "'!");
            }
            return new PotionItemPredicate(potion);
        }

        @Override
        public JsonObject serialize(PotionItemPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("potion", class_7923.field_41179.method_10221((Object)value.potion).toString());
            return json;
        }
    };
    private final class_1842 potion;

    public PotionItemPredicate(class_1842 potion) {
        this.potion = potion;
    }

    @Override
    public boolean test(class_1799 stack) {
        return class_1844.method_8063((class_1799)stack) == this.potion;
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

