/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.common.config.RecipeSorterStage;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeSortUtil;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.layouts.IRecipeLayoutList;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import org.jetbrains.annotations.Nullable;

public class LazySortedRecipeLayoutList
implements IRecipeLayoutList {
    @Nullable
    private final class_1703 container;
    @Nullable
    private final class_1657 player;
    private final List<RecipeLayoutWithButtons<?>> results;
    private final List<RecipeLayoutWithButtons<?>> craftMissing;
    private final Iterator<? extends RecipeLayoutWithButtons<?>> unsortedIterator;
    private final int size;
    private final boolean matchingCraftable;

    LazySortedRecipeLayoutList(Set<RecipeSorterStage> recipeSorterStages, @Nullable class_1703 container, @Nullable class_1657 player, List<? extends RecipeLayoutWithButtons<?>> unsortedList) {
        boolean matchingBookmarks = recipeSorterStages.contains((Object)RecipeSorterStage.BOOKMARKED);
        this.matchingCraftable = recipeSorterStages.contains((Object)RecipeSorterStage.CRAFTABLE);
        this.container = container;
        this.player = player;
        this.results = new ArrayList();
        this.craftMissing = new ArrayList();
        this.size = unsortedList.size();
        if (matchingBookmarks) {
            unsortedList = new ArrayList(unsortedList);
            Iterator<RecipeLayoutWithButtons<?>> iterator = unsortedList.iterator();
            while (iterator.hasNext()) {
                RecipeLayoutWithButtons<?> layoutWithButtons = iterator.next();
                if (!layoutWithButtons.bookmarkButton().isBookmarked()) continue;
                this.results.add(layoutWithButtons);
                iterator.remove();
            }
        }
        if (!this.matchingCraftable) {
            this.results.addAll(unsortedList);
            this.unsortedIterator = Collections.emptyIterator();
        } else {
            this.unsortedIterator = unsortedList.iterator();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<RecipeLayoutWithButtons<?>> subList(int from, int to) {
        this.ensureResults(to - 1);
        return this.results.subList(from, to);
    }

    private void ensureResults(int index) {
        while (index >= this.results.size()) {
            if (this.calculateNextResult()) continue;
            return;
        }
    }

    @Override
    public Optional<RecipeLayoutWithButtons<?>> findFirst() {
        this.ensureResults(0);
        if (this.results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.results.get(0));
    }

    @Override
    public void tick() {
        this.calculateNextResult();
    }

    private boolean calculateNextResult() {
        if (this.matchingCraftable) {
            while (this.unsortedIterator.hasNext()) {
                int missingCountHint;
                RecipeLayoutWithButtons<?> next = this.unsortedIterator.next();
                RecipeTransferButton transferButton = next.transferButton();
                if (!transferButton.isInitialized()) {
                    transferButton.update(this.container, this.player);
                }
                if ((missingCountHint = transferButton.getMissingCountHint()) == 0) {
                    this.results.add(next);
                    return true;
                }
                this.craftMissing.add(next);
            }
            if (!this.craftMissing.isEmpty()) {
                this.craftMissing.sort(RecipeSortUtil.getCraftableComparator());
                this.results.addAll(this.craftMissing);
                this.craftMissing.clear();
                return true;
            }
        }
        return false;
    }
}

