/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_3255;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record McMetaFile(@NotNull class_1079 animation, JsonObject moddedStuff) {
    private static List<Field> FIELDS = null;
    private static final int VANILLA_FIELDS = 5;

    public static McMetaFile of(@NotNull class_1079 vanillaMcmeta) {
        return new McMetaFile(vanillaMcmeta, new JsonObject());
    }

    public static McMetaFile of(@NotNull class_1079 vanillaMcmeta, JsonObject moddedStuff) {
        return new McMetaFile(vanillaMcmeta, moddedStuff);
    }

    @Nullable
    public static McMetaFile read(class_3298 resource) throws IOException {
        try (InputStream metadataStream = resource.method_14482();){
            byte[] bytes = metadataStream.readAllBytes();
            class_1079 metadata = (class_1079)class_3255.method_14392((class_3270)class_1079.field_5337, (InputStream)new ByteArrayInputStream(bytes));
            if (metadata == null) {
                McMetaFile mcMetaFile = null;
                return mcMetaFile;
            }
            JsonObject moddedObj = McMetaFile.readModdedObj(bytes);
            McMetaFile mcMetaFile = McMetaFile.of(metadata, moddedObj);
            return mcMetaFile;
        }
    }

    private static JsonObject readModdedObj(byte[] bytes) {
        JsonObject jo = class_3518.method_15285((String)new String(bytes));
        for (String key : new String[]{"frametime", "width", "height", "interpolate", "frames"}) {
            jo.remove(key);
        }
        return jo;
    }

    public JsonObject toJson() {
        JsonObject obj = this.moddedStuff.deepCopy();
        JsonObject animObj = new JsonObject();
        animObj.addProperty("frametime", (Number)this.animation.method_4684());
        animObj.addProperty("interpolate", Boolean.valueOf(this.animation.method_4685()));
        animObj.addProperty("height", (Number)this.animation.field_5336);
        animObj.addProperty("width", (Number)this.animation.field_5338);
        JsonArray frames = new JsonArray();
        this.animation.method_33460((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", (Number)t);
                o.addProperty("index", (Number)i);
                frames.add((JsonElement)o);
            } else {
                frames.add((Number)i);
            }
        });
        animObj.add("frames", (JsonElement)frames);
        obj.add("animation", (JsonElement)animObj);
        return obj;
    }

    public McMetaFile cloneWithSize(int frameWidth, int frameHeight) {
        ArrayList frameData = new ArrayList();
        this.animation.method_33460((i, t) -> frameData.add(new class_1080(i, t)));
        class_1079 newMetadata = new class_1079(frameData, frameWidth, frameHeight, this.animation.method_4684(), this.animation.method_4685());
        JsonObject newModdedStuff = this.moddedStuff.deepCopy();
        return new McMetaFile(newMetadata, newModdedStuff);
    }

    public static void copyAllMixinAddedFields(class_1079 from, class_1079 to) {
        if (FIELDS == null) {
            FIELDS = new ArrayList<Field>();
            Field[] f = class_1079.class.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if (i <= 4) continue;
                Field field = f[i];
                FIELDS.add(field);
                field.setAccessible(true);
            }
        }
        for (Field field : FIELDS) {
            try {
                field.set(to, field.get(from));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

