/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LUVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.XYZColor;

public final class ColorSpaces {
    private static final float SCALE_X = 0.95047f;
    private static final float SCALE_Y = 1.0f;
    private static final float SCALE_Z = 1.08883f;
    private static final float SCALE_L = 100.0f;
    private static final float SCALE_A = 255.0f;
    private static final float SCALE_B = 255.0f;
    private static final float UN = 0.2009f;
    private static final float VN = 0.461f;

    public static HSVColor RGBtoHSV(RGBColor color) {
        float hue;
        float cmin;
        float cmax;
        float r = color.red();
        float g = color.green();
        float b = color.blue();
        if (b > (cmax = Math.max(r, g))) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = cmax;
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new HSVColor(hue, saturation, brightness, color.alpha());
    }

    public static RGBColor HSVtoRGB(HSVColor color) {
        float hue = color.hue();
        float saturation = color.saturation();
        float brightness = color.value();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (saturation == 0.0f) {
            g = b = (float)((int)(brightness * 255.0f + 0.5f));
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        return new RGBColor(r, g, b, color.alpha());
    }

    public static HSLColor RGBtoHSL(RGBColor color) {
        float h;
        float s;
        float r = color.red();
        float g = color.green();
        float b = color.blue();
        float max = r > g && r > b ? r : Math.max(g, b);
        float min = r < g && r < b ? r : Math.min(g, b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = r > g && r > b ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (g > b ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new HSLColor(h, s, l, color.alpha());
    }

    public static RGBColor HSLtoRGB(HSLColor color) {
        float r;
        float g;
        float b;
        float h = color.hue();
        float s = color.saturation();
        float l = color.lightness();
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorSpaces.hueToRgb(p, q, h + 0.33333334f);
            g = ColorSpaces.hueToRgb(p, q, h);
            b = ColorSpaces.hueToRgb(p, q, h - 0.33333334f);
        }
        return new RGBColor(r, g, b, color.alpha());
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static XYZColor RGBtoXYZ(RGBColor color) {
        float red = color.red();
        float green = color.green();
        float blue = color.blue();
        double r = red > 0.04045f ? Math.pow((red + 0.055f) / 1.055f, 2.4f) : (double)(red / 12.92f);
        double g = green > 0.04045f ? Math.pow((green + 0.055f) / 1.055f, 2.4f) : (double)(green / 12.92f);
        double b = blue > 0.04045f ? Math.pow((blue + 0.055f) / 1.055f, 2.4f) : (double)(blue / 12.92f);
        float x = (float)((double)0.4124f * r + (double)0.3576f * g + (double)0.1805f * b);
        float y = (float)((double)0.2126f * r + (double)0.7152f * g + (double)0.0722f * b);
        float z = (float)((double)0.0193f * r + (double)0.1192f * g + (double)0.9505f * b);
        return new XYZColor(x, y, z, color.alpha());
    }

    public static RGBColor XYZtoRGB(XYZColor color) {
        float x = color.x();
        float y = color.y();
        float z = color.z();
        float r = 3.2406f * x - 1.5372f * y - 0.4986f * z;
        float g = -0.9689f * x + 1.8758f * y + 0.0415f * z;
        float b = 0.0557f * x - 0.204f * y + 1.057f * z;
        r = r > 0.0031308f ? (float)((double)1.055f * Math.pow(r, 0.4166666567325592) - (double)0.055f) : 12.92f * r;
        g = g > 0.0031308f ? (float)((double)1.055f * Math.pow(g, 0.4166666567325592) - (double)0.055f) : 12.92f * g;
        b = b > 0.0031308f ? (float)((double)1.055f * Math.pow(b, 0.4166666567325592) - (double)0.055f) : 12.92f * b;
        return new RGBColor(r, g, b, color.alpha());
    }

    public static LABColor XYZtoLAB(XYZColor color) {
        float x = color.x() / 0.95047f;
        float y = color.y() / 1.0f;
        float z = color.z() / 1.08883f;
        x = x > 0.008856f ? (float)Math.cbrt(x) : 7.787f * x + 0.13793103f;
        y = y > 0.008856f ? (float)Math.cbrt(y) : 7.787f * y + 0.13793103f;
        z = z > 0.008856f ? (float)Math.cbrt(z) : 7.787f * z + 0.13793103f;
        float l = 116.0f * y - 16.0f;
        float a = 500.0f * (x - y);
        float b = 200.0f * (y - z);
        return new LABColor(l / 100.0f, a / 255.0f, b / 255.0f, color.alpha());
    }

    public static XYZColor LABtoXYZ(LABColor color) {
        float y0 = (color.luminance() * 100.0f + 16.0f) / 116.0f;
        float x0 = color.a() * 255.0f / 500.0f + y0;
        float z0 = y0 - color.b() * 255.0f / 200.0f;
        float x3 = x0 * x0 * x0;
        float x = (float)((x3 > 0.008856f ? (double)x3 : (double)(x0 - 0.13793103f) / 7.787) * (double)0.95047f);
        float y3 = y0 * y0 * y0;
        float y = (float)((y3 > 0.008856f ? (double)y3 : (double)(y0 - 0.13793103f) / 7.787) * 1.0);
        float z3 = z0 * z0 * z0;
        float z = (float)((z3 > 0.008856f ? (double)z3 : (double)(z0 - 0.13793103f) / 7.787) * (double)1.08883f);
        return new XYZColor(x, y, z, color.alpha());
    }

    public static HCLColor LABtoHCL(LABColor color) {
        float l = color.luminance();
        float a = color.a();
        float b = color.b();
        float c = (float)Math.sqrt(a * a + b * b);
        float h = (float)Math.atan2(b, a);
        for (h = (float)((double)h / (Math.PI * 2)); h < 0.0f; h += 1.0f) {
        }
        if (c < 0.0f || h < 0.0f || c > 1.0f || h > 1.0f) {
            boolean bl = true;
        }
        return new HCLColor(h, c, l, color.alpha());
    }

    public static LABColor HCLtoLAB(HCLColor color) {
        float h = color.hue();
        float c = color.chroma();
        float l = color.luminance();
        float a = (float)((double)c * Math.cos((double)h * Math.PI * 2.0));
        float b = (float)((double)c * Math.sin((double)h * Math.PI * 2.0));
        return new LABColor(l, a, b, color.alpha());
    }

    public static LUVColor XYZtoLUV(XYZColor color) {
        float X = color.x();
        float Y = color.y();
        float Z = color.z();
        float P = X + 15.0f * Y + 3.0f * Z;
        float uP = 4.0f * X / P;
        float vP = 9.0f * Y / P;
        float f = 0.20689656f;
        float F = f * f * f;
        float L = (float)(Y <= F ? Math.pow(9.666666984558105, 3.0) * (double)Y : 116.0 * Math.cbrt(Y) - 16.0);
        float u = 13.0f * L * (uP - 0.2009f);
        float v = 13.0f * L * (vP - 0.461f);
        return new LUVColor(L / 255.0f, u / 255.0f, v / 255.0f, color.alpha());
    }

    public static XYZColor LUVtoXYZ(LUVColor color) {
        float L = color.luminance() * 255.0f;
        float u = color.u() * 255.0f;
        float v = color.v() * 255.0f;
        float uP = 0.2009f + u / (13.0f * L);
        float vP = 0.461f + v / (13.0f * L);
        float Y = (float)(L <= 8.0f ? (double)L * Math.pow(0.1034482792019844, 3.0) : Math.pow((L + 16.0f) / 116.0f, 3.0));
        float X = Y * 9.0f * uP / (4.0f * vP);
        float Z = Y * (12.0f - 3.0f * uP - 20.0f * vP) / (4.0f * vP);
        return new XYZColor(X, Y, Z, color.alpha());
    }

    public static HCLVColor LUVtoHCLV(LUVColor color) {
        float l = color.luminance();
        float a = color.u();
        float b = color.v();
        float c = (float)Math.sqrt(a * a + b * b);
        float h = (float)Math.atan2(b, a);
        for (h = (float)((double)h / (Math.PI * 2)); h < 0.0f; h += 1.0f) {
        }
        return new HCLVColor(h, c, l, color.alpha());
    }

    public static LUVColor HCLVtoLUV(HCLVColor color) {
        float h = color.hue();
        float c = color.chroma();
        float l = color.luminance();
        float u = (float)((double)c * Math.cos((double)h * Math.PI * 2.0));
        float v = (float)((double)c * Math.sin((double)h * Math.PI * 2.0));
        return new LUVColor(l, u, v, color.alpha());
    }
}

