/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.mixin.MobEntityVariantsMixin;
import com.github.nyuppo.networking.MMVNetworkingConstants;
import com.github.nyuppo.variant.MobVariant;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1452;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1452.class})
public abstract class PigVariantsMixin
extends MobEntityVariantsMixin {
    private MobVariant variant = Variants.getDefaultVariant(class_1299.field_6085);
    private boolean isMuddy = false;
    private int muddyTimeLeft = -1;

    @Override
    protected void onWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10582("VariantID", this.variant.getIdentifier().toString());
        nbt.method_10556("IsMuddy", this.isMuddy);
        nbt.method_10569("MuddyTimeLeft", this.muddyTimeLeft);
    }

    @Override
    protected void onReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.variant = !nbt.method_10558("VariantID").isEmpty() ? (nbt.method_10558("VariantID").contains(":") ? Variants.getVariant(class_1299.field_6093, new class_2960(nbt.method_10558("VariantID"))) : Variants.getVariant(class_1299.field_6093, MoreMobVariants.id(nbt.method_10558("VariantID")))) : Variants.getRandomVariant(class_1299.field_6093, ((class_1452)this).method_6051().method_43055(), (class_6880<class_1959>)((class_1452)this).method_37908().method_23753(((class_1452)this).method_24515()), null, Float.valueOf(((class_1452)this).method_37908().method_30272()));
        this.isMuddy = nbt.method_10577("IsMuddy");
        this.muddyTimeLeft = nbt.method_10550("MuddyTimeLeft");
        MinecraftServer server = ((class_1297)this).method_5682();
        if (server != null) {
            server.method_3760().method_14571().forEach(player -> {
                class_2540 updateBuf = PacketByteBufs.create();
                updateBuf.writeInt(((class_1297)this).method_5628());
                updateBuf.method_10814(this.variant.getIdentifier().toString());
                updateBuf.writeBoolean(this.isMuddy);
                updateBuf.method_10804(this.muddyTimeLeft);
                updateBuf.method_10814("");
                ServerPlayNetworking.send((class_3222)player, (class_2960)MMVNetworkingConstants.SERVER_RESPOND_VARIANT_ID, (class_2540)updateBuf);
            });
        }
    }

    @Override
    protected void onInitialize(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt, CallbackInfoReturnable<class_1315> ci) {
        this.variant = Variants.getRandomVariant(class_1299.field_6093, ((class_1452)this).method_6051().method_43055(), (class_6880<class_1959>)world.method_23753(((class_1452)this).method_24515()), null, Float.valueOf(world.method_30272()));
        if (world.method_23753(((class_1452)this).method_24515()).method_40220(class_6908.field_36532) && world.method_8409().method_43058() < 0.02) {
            this.isMuddy = true;
        }
    }

    @Override
    protected void onTick(CallbackInfo ci) {
        if (VariantSettings.getEnableMuddyPigs()) {
            int muddyPigTimeout = VariantSettings.getMuddyPigTimeout();
            if (this.muddyTimeLeft == -1) {
                if (((class_1452)this).method_37908().method_8320(((class_1452)this).method_24515()).method_26164(MoreMobVariants.PIG_MUD_BLOCKS) || ((class_1452)this).method_37908().method_8320(((class_1452)this).method_24515().method_10074()).method_26164(MoreMobVariants.PIG_MUD_BLOCKS)) {
                    this.isMuddy = true;
                    if (muddyPigTimeout > 0) {
                        this.muddyTimeLeft = 20 * muddyPigTimeout;
                    }
                } else if (((class_1452)this).method_5721()) {
                    this.isMuddy = false;
                    this.muddyTimeLeft = -1;
                }
            }
            if (muddyPigTimeout > 0 && this.muddyTimeLeft > 0) {
                --this.muddyTimeLeft;
                if (this.muddyTimeLeft == 0) {
                    this.isMuddy = false;
                    this.muddyTimeLeft = -1;
                }
            }
        }
    }

    @Inject(method={"createChild(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/passive/PassiveEntity;)Lnet/minecraft/entity/passive/PigEntity;"}, at={@At(value="RETURN")})
    private void onCreateChild(class_3218 world, class_1296 entity, CallbackInfoReturnable<class_1452> ci) {
        class_1452 child = (class_1452)ci.getReturnValue();
        MobVariant variant = Variants.getChildVariant(class_1299.field_6093, world, (class_1296)((class_1452)this), entity);
        class_2487 childNbt = new class_2487();
        child.method_5647(childNbt);
        childNbt.method_10582("VariantID", variant.getIdentifier().toString());
        child.method_5749(childNbt);
    }
}

