/*
 * Decompiled with CFR 0.152.
 */
package opekope2.util;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import opekope2.filter.EqualityFilter;
import opekope2.filter.Filter;
import opekope2.filter.RangeFilter;
import opekope2.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lopekope2/util/NumberOrRange;", "", "Lopekope2/filter/Filter;", "", "", "toFilter", "()Lopekope2/filter/Filter;", "<init>", "()V", "Companion", "Number", "Range", "Lopekope2/util/NumberOrRange$Number;", "Lopekope2/util/NumberOrRange$Range;", "optigui"})
public abstract class NumberOrRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex regex = new Regex("^(?:(?<start>\\d+|\\(-?\\d+\\))-(?<end>\\d+|\\(-?\\d+\\))?|(?<value>-?\\d+))$");

    private NumberOrRange() {
    }

    @NotNull
    public abstract Filter<Integer, Unit> toFilter();

    @JvmStatic
    @Nullable
    public static final NumberOrRange tryParse(@NotNull String numberRange) {
        return Companion.tryParse(numberRange);
    }

    public /* synthetic */ NumberOrRange(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lopekope2/util/NumberOrRange$Number;", "Lopekope2/util/NumberOrRange;", "Lopekope2/filter/Filter;", "", "", "toFilter", "()Lopekope2/filter/Filter;", "", "toString", "()Ljava/lang/String;", "value", "I", "getValue", "()I", "<init>", "(I)V", "optigui"})
    public static final class Number
    extends NumberOrRange {
        private final int value;

        public Number(int value) {
            super(null);
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public Filter<Integer, Unit> toFilter() {
            return new EqualityFilter<Integer>(this.value);
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u0004\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lopekope2/util/NumberOrRange$Range;", "Lopekope2/util/NumberOrRange;", "Lopekope2/filter/Filter;", "", "", "toFilter", "()Lopekope2/filter/Filter;", "", "toString", "()Ljava/lang/String;", "end", "Ljava/lang/Integer;", "getEnd", "()Ljava/lang/Integer;", "start", "I", "getStart", "()I", "<init>", "(ILjava/lang/Integer;)V", "optigui"})
    public static final class Range
    extends NumberOrRange {
        private final int start;
        @Nullable
        private final Integer end;

        public Range(int start, @Nullable Integer end) {
            super(null);
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        @Nullable
        public final Integer getEnd() {
            return this.end;
        }

        @Override
        @NotNull
        public Filter<Integer, Unit> toFilter() {
            return this.end == null ? (Filter)RangeFilter.Companion.atLeast(this.start) : (Filter)RangeFilter.Companion.between(this.start, this.end);
        }

        @NotNull
        public String toString() {
            Object startString = this.start < 0 ? "(" + this.start + ")" : String.valueOf(this.start);
            String endString = this.end == null ? "" : (this.end < 0 ? "(" + this.end + ")" : String.valueOf(this.end));
            return (String)startString + "-" + endString;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u0012\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lopekope2/util/NumberOrRange$Companion;", "", "", "numberRange", "Lopekope2/util/NumberOrRange;", "tryParse", "(Ljava/lang/String;)Lopekope2/util/NumberOrRange;", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "getRegex$annotations", "()V", "<init>", "optigui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getRegex$annotations() {
        }

        @JvmStatic
        @Nullable
        public final NumberOrRange tryParse(@NotNull String numberRange) {
            NumberOrRange numberOrRange;
            Integer value;
            Intrinsics.checkNotNullParameter((Object)numberRange, (String)"numberRange");
            MatchResult matchResult = regex.matchEntire((CharSequence)numberRange);
            if (matchResult == null) {
                return null;
            }
            MatchResult result = matchResult;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"start");
            Integer start = object != null && (object = object.getValue()) != null && (object = UtilKt.trimParentheses((String)object)) != null ? StringsKt.toIntOrNull((String)object) : null;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"end");
            Integer end = object2 != null && (object2 = object2.getValue()) != null && (object2 = UtilKt.trimParentheses((String)object2)) != null ? StringsKt.toIntOrNull((String)object2) : null;
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"value");
            Integer n = object3 != null && (object3 = object3.getValue()) != null ? StringsKt.toIntOrNull((String)object3) : (value = null);
            if (value == null) {
                Integer n2 = start;
                Intrinsics.checkNotNull((Object)n2);
                numberOrRange = new Range(n2, end);
            } else {
                numberOrRange = new Number(value);
            }
            return numberOrRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

