/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.oreharvester_common_forge.config.ConfigHandler;
import com.natamus.oreharvester_common_forge.data.Variables;
import com.natamus.oreharvester_common_forge.util.Util;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class OreMineEvents {
    public static boolean onOreHarvest(Level level, Player player, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        Block block;
        if (level.f_46443_) {
            return true;
        }
        Pair cachePair = new Pair((Object)level, (Object)player);
        if (!Variables.harvestSpeedCache.containsKey(cachePair)) {
            if (ConfigHandler.oreHarvestWithoutSneak ? player.m_6047_() : !player.m_6047_()) {
                return true;
            }
        } else {
            Variables.harvestSpeedCache.remove(cachePair);
        }
        if (!Util.isOre(block = blockState.m_60734_())) {
            return true;
        }
        ItemStack handStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!Variables.allowedPickaxes.contains(handStack.m_41720_())) {
            return true;
        }
        List<BlockPos> oresAround = Util.getOresNextToEachOther(level, blockPos, block);
        int oreCount = oresAround.size();
        if (oreCount < 0) {
            return true;
        }
        if (ConfigHandler.dropOresAtFirstBrokenBlock) {
            Item oreItem = Util.getOreDrop(level, blockState, block, handStack, player, Vec3.m_82512_((Vec3i)blockPos));
            if (!Variables.lastDropLocations.containsKey(oreItem)) {
                Variables.lastDropLocations.put(oreItem, new CopyOnWriteArrayList());
            }
            BlockPos immutableBlockPos = blockPos.m_7949_();
            Variables.lastDropLocations.get(oreItem).add(immutableBlockPos);
            Variables.lastAction.put(immutableBlockPos, new Date());
        }
        int durabilityLoseCount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilityStartCount = -1;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        for (BlockPos orePos : oresAround) {
            BlockState logstate = level.m_8055_(orePos);
            Block log = logstate.m_60734_();
            BlockFunctions.dropBlock((Level)level, (BlockPos)orePos, (Entity)player, (ItemStack)handStack);
            if (player.m_7500_()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedOre) {
                if (durabilityStartCount == -1) {
                    durabilityStartCount = durabilityLoseCount;
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)handStack, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                } else if (--durabilityLoseCount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)handStack, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                    durabilityLoseCount = durabilityStartCount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedOre) continue;
            player.m_36399_(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        return false;
    }

    public static float onHarvestBreakSpeed(Level level, Player player, float digSpeed, BlockState state) {
        if (!ConfigHandler.increaseHarvestingTimePerOre) {
            return digSpeed;
        }
        Block block = state.m_60734_();
        if (!Util.isOre(block)) {
            return digSpeed;
        }
        if (ConfigHandler.oreHarvestWithoutSneak ? player.m_6047_() : !player.m_6047_()) {
            return digSpeed;
        }
        ItemStack handStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!Variables.allowedPickaxes.contains(handStack.m_41720_())) {
            return digSpeed;
        }
        int oreCount = -1;
        Date now = new Date();
        Pair keyPair = new Pair((Object)level, (Object)player);
        if (Variables.harvestSpeedCache.containsKey(keyPair)) {
            Pair<Date, Integer> valuePair = Variables.harvestSpeedCache.get(keyPair);
            long ms = now.getTime() - ((Date)valuePair.getFirst()).getTime();
            if (ms < 1000L) {
                oreCount = (Integer)valuePair.getSecond();
            } else {
                Variables.harvestSpeedCache.remove(keyPair);
            }
        }
        BlockPos blockPos = null;
        HitResult hitResult = player.m_19907_(20.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            blockPos = ((BlockHitResult)hitResult).m_82425_();
        }
        if (blockPos == null) {
            return digSpeed;
        }
        boolean recheck = false;
        if (oreCount < 0) {
            List<BlockPos> oresAround = Util.getOresNextToEachOther(level, blockPos, block);
            oreCount = oresAround.size();
            if (oreCount == 0) {
                return digSpeed;
            }
            Variables.harvestSpeedCache.put((Pair<Level, Player>)keyPair, (Pair<Date, Integer>)new Pair((Object)now, (Object)oreCount));
            recheck = true;
        }
        return digSpeed / (1.0f + (float)oreCount * (float)ConfigHandler.increasedHarvestingTimePerOreModifier);
    }
}

