/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_746;
import net.minecraft.class_758;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<class_2960, class_4763> vanillaEffects = new HashMap<class_2960, class_4763>();
    private final Map<class_2960, BiomeEffectModifier> effectsToApply = new HashMap<class_2960, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<class_1959, BiomeEffectModifier> fogParametersModifiers = new HashMap<class_1959, BiomeEffectModifier>();
    private static float lastFogDistanceMult = 1.0f;
    private static float lastFogEndMult = 1.0f;

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            Optional<BiomeEffectModifier> effect = Parsed.parseOptional(BiomeEffectModifier.CODEC, json, ops, id, "biome modifier");
            effect.ifPresent(e -> this.addEffect(id, (BiomeEffectModifier)e, access));
        }
    }

    private void addEffect(class_2960 pathId, BiomeEffectModifier mod, class_5455 access) {
        class_2378 registry = access.method_30530(class_7924.field_41236);
        for (class_6880 biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge(((class_5321)biome.method_40230().get()).method_29177(), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(class_5455 registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        class_2378 biomeReg = (class_2378)registryAccess.method_33310(class_7924.field_41236).get();
        this.addAllWaterColors((class_2378<class_1959>)biomeReg, registryAccess);
        for (Map.Entry<class_2960, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            class_2960 biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.method_17966(biomeId);
            if (!biome.isPresent()) continue;
            class_4763 old = modifier.apply((class_1959)biome.get());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((class_1959)biome.get(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        this.needsDynamicApplication = true;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_2378 biomeReg = (class_2378)level.method_30349().method_33310(class_7924.field_41236).get();
            for (Map.Entry<class_2960, class_4763> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.method_17966(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (class_4763)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    public void addAllWaterColors(class_2378<class_1959> biomeReg, class_5455 registryAccess) {
        FluidPropertyModifier water;
        if (Polytone.sodiumOn && (water = Polytone.FLUID_MODIFIERS.getModifier((class_3611)class_3612.field_15910)) != null) {
            for (Map.Entry e : biomeReg.method_29722()) {
                class_322 class_3222;
                class_2960 id = ((class_5321)e.getKey()).method_29177();
                class_1959 b = (class_1959)e.getValue();
                BiomeEffectModifier original = this.effectsToApply.get(id);
                if (original != null && !original.waterColor().isEmpty() || !((class_3222 = water.getTint()) instanceof Colormap)) continue;
                Colormap cl = (Colormap)class_3222;
                int col = cl.getColor(b, 0.0, 0.0);
                BiomeEffectModifier dummy = BiomeEffectModifier.ofWaterColor(col);
                this.addEffect(id, dummy, registryAccess);
            }
        }
    }

    @Nullable
    public class_241 modifyFogParameters(float originalNearPlane, float originalFarPlane) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return null;
        }
        if (class_758.method_42588((class_1297)player, (float)0.0f) != null) {
            return null;
        }
        class_1937 level = player.method_37908();
        class_6880 biome = level.method_23753(player.method_24515());
        BiomeEffectModifier fogMod = this.fogParametersModifiers.get(biome.comp_349());
        class_241 fogScalars = null;
        if (fogMod != null) {
            fogScalars = fogMod.modifyFogParameters(level);
        }
        if (fogScalars == null && (class_3532.method_15379((float)(lastFogDistanceMult - 1.0f)) > 0.02f || class_3532.method_15379((float)(lastFogEndMult - 1.0f)) > 0.02f)) {
            fogScalars = new class_241(1.0f, 1.0f);
        }
        if (fogScalars != null) {
            float deltaTime = ClientFrameTicker.getDeltaTime();
            float interpolationFactor = deltaTime * 0.1f;
            lastFogDistanceMult = class_3532.method_16439((float)interpolationFactor, (float)lastFogDistanceMult, (float)fogScalars.field_1343);
            lastFogEndMult = class_3532.method_16439((float)interpolationFactor, (float)lastFogEndMult, (float)fogScalars.field_1342);
            float distance = originalFarPlane - originalNearPlane;
            return new class_241((originalFarPlane - distance * lastFogDistanceMult) * lastFogEndMult, originalFarPlane * lastFogEndMult);
        }
        return null;
    }
}

