/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_4970;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockPropertiesManager
extends PartialReloader<Resources> {
    private final Map<class_2248, BlockPropertyModifier> vanillaProperties = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, BlockPropertyModifier> modifiers = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, ClientTickModifier> particleAndSoundEmitters = new Object2ObjectOpenHashMap();
    private final Map<class_2960, String> optifineColormapsToBlocks = new HashMap<class_2960, String>();

    public BlockPropertiesManager() {
        super("block_modifiers", "block_properties");
    }

    @Nullable
    public class_243 maybeModify(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        Optional<class_4970.class_8176> of;
        BlockPropertyModifier modifier = this.modifiers.get(state.method_26204());
        if (modifier != null && (of = modifier.offsetType()).isPresent()) {
            return of.get().evaluate(state, blockGetter, pos);
        }
        return null;
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/colormap");
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        Map<class_2960, Properties> ofProperties = PropertiesUtils.gatherProperties(resourceManager, "optifine/colormap");
        HashMap<class_2960, JsonElement> ofJsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)"optifine/colormap", (Gson)GSON, ofJsons);
        ofJsons.forEach((k, v) -> ofProperties.put((class_2960)k, PropertiesUtils.jsonToProperties(v)));
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new Resources((Map<class_2960, JsonElement>)ImmutableMap.copyOf(jsons), (Map<class_2960, ArrayImage>)ImmutableMap.copyOf(textures), (Map<class_2960, Properties>)ImmutableMap.copyOf(LegacyHelper.convertPaths(ofProperties)));
    }

    @Override
    protected void parseWithLevel(Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage.Group> textures = ArrayImage.groupTextures(resources.textures());
        HashMap<class_2960, ArrayImage> textureCopy = new HashMap<class_2960, ArrayImage>(resources.textures);
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, Parsed<BlockPropertyModifier>> parsedModifiers = new HashMap<class_2960, Parsed<BlockPropertyModifier>>();
        parsedModifiers.putAll(LegacyHelper.convertBlockProperties(resources.ofProperties, textureCopy));
        parsedModifiers.putAll(LegacyHelper.convertInlinedPalettes(this.optifineColormapsToBlocks));
        LegacyHelper.convertOfBlockToFluidProp(parsedModifiers, textureCopy);
        LegacyHelper.convertOfBlockToDimensionProperties(parsedModifiers, textureCopy);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            Parsed<BlockPropertyModifier> prop = Parsed.parse(BlockPropertyModifier.CODEC, BlockPropertyModifier.PARTIAL_CODEC, json, ops, id2, "block modifier");
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate block modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, prop);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (class_2960)entry.getKey();
            Parsed result = (Parsed)entry.getValue();
            BlockPropertyModifier modifier = (BlockPropertyModifier)result.getResultOrPartial();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                ArrayImage.Group text = textures.get(id);
                IndexCompoundColorGetter defaultSampler = IndexCompoundColorGetter.createDefault((Set<Integer>)text.keySet(), true);
                modifier = modifier.merge(BlockPropertyModifier.ofBlockColor(defaultSampler));
            }
            IColorGetter tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTextureGroup(textures, id, tint, usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            ArrayImage.Group image = (ArrayImage.Group)((Object)entry.getValue());
            IndexCompoundColorGetter tintMap = IndexCompoundColorGetter.createDefault((Set<Integer>)image.keySet(), true);
            ColormapsManager.tryAcceptingTextureGroup(textures, id, (class_322)tintMap, usedTextures, true);
            BlockPropertyModifier modifier = BlockPropertyModifier.ofBlockColor(tintMap);
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(class_2960 fileId, BlockPropertyModifier mod) {
        for (class_6880 block : mod.targets().compute(fileId, class_7923.field_41175)) {
            this.modifiers.merge((class_2248)block.comp_349(), mod, BlockPropertyModifier::merge);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.optifineColormapsToBlocks.clear();
        this.particleAndSoundEmitters.clear();
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            class_2248 target = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            Optional<List<BlockParticleEmitter>> particle = value.particleEmitters();
            particle.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).addAll((List<? extends BlockClientTickable>)emitters));
            Optional<List<BlockSoundEmitter>> sound = value.soundEmitters();
            sound.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).addAll((List<? extends BlockClientTickable>)emitters));
            if (!value.disableParticles().booleanValue()) continue;
            this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).cancelsExisting();
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Block Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }

    public void addSimpleColormap(class_2960 path, String str) {
        this.optifineColormapsToBlocks.put(path, str);
    }

    public boolean maybeEmitParticle(class_2248 block, class_2680 state, class_1937 level, class_2338 pos) {
        ClientTickModifier m = this.particleAndSoundEmitters.get(block);
        if (m != null) {
            for (BlockClientTickable p : m.tickables) {
                p.tick(level, pos, state);
            }
            return m.cancelExisting;
        }
        return false;
    }

    public record Resources(Map<class_2960, JsonElement> jsons, Map<class_2960, ArrayImage> textures, Map<class_2960, Properties> ofProperties) {
    }

    private static class ClientTickModifier {
        final List<BlockClientTickable> tickables = new ArrayList<BlockClientTickable>();
        boolean cancelExisting;

        private ClientTickModifier() {
        }

        public void add(BlockClientTickable tickable) {
            this.tickables.add(tickable);
        }

        public void cancelsExisting() {
            this.cancelExisting = true;
        }

        public void addAll(List<? extends BlockClientTickable> emitters) {
            this.tickables.addAll(emitters);
        }
    }
}

