/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.ConcurrentExpression;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;
import org.jetbrains.annotations.Nullable;

public final class ColormapExpressionProvider
implements IColormapNumberProvider {
    private static final String TEMPERATURE = "TEMPERATURE";
    private static final String DOWNFALL = "DOWNFALL";
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String BIOME_VALUE = "BIOME_VALUE";
    private static final String DAMAGE = "DAMAGE";
    private static final String TIME = "TIME";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String SUN_TIME = "SUN_TIME";
    private static final String RAIN = "RAIN";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return (float)values.indexOf(blockState.method_11654(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return values.indexOf(blockState.method_11654(p));
        }
    };
    private static final ThreadLocal<class_2680> STATE_HACK = new ThreadLocal();
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            ConcurrentExpression compiled = ColormapExpressionProvider.createExpression(s);
            return DataResult.success((Object)new ColormapExpressionProvider(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    private final String unparsed;
    private final ConcurrentExpression expression;
    private final boolean hasTemperature;
    private final boolean hasDownfall;
    private final boolean hasRain;
    private final boolean hasTime;
    private final boolean hasDayTime;
    private final boolean hasSunTime;

    private static ConcurrentExpression createExpression(String s) {
        return ConcurrentExpression.of(new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{TEMPERATURE, DOWNFALL, POS_X, POS_Y, POS_Z, BIOME_VALUE, TIME, RAIN, DAY_TIME}).operator(ExpressionUtils.defOp(new Operator[0])));
    }

    private ColormapExpressionProvider(ConcurrentExpression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTemperature = unparsed.contains(TEMPERATURE);
        this.hasDownfall = unparsed.contains(DOWNFALL);
        this.hasRain = unparsed.contains(RAIN);
        this.hasTime = unparsed.contains(TIME);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasSunTime = unparsed.contains(SUN_TIME);
    }

    public static ColormapExpressionProvider make(String s) {
        return new ColormapExpressionProvider(ColormapExpressionProvider.createExpression(s), s);
    }

    @Override
    public boolean usesBiome() {
        return this.unparsed.contains(TEMPERATURE) || this.unparsed.contains(DOWNFALL) || this.unparsed.contains(BIOME_VALUE);
    }

    @Override
    public boolean usesPos() {
        return this.unparsed.contains(POS_X) || this.unparsed.contains(POS_Y) || this.unparsed.contains(POS_Z);
    }

    @Override
    public boolean usesState() {
        return this.unparsed.contains(STATE_FUNC);
    }

    @Override
    public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
        float result = 0.0f;
        try {
            ConcurrentExpression exp = this.expression;
            if (this.hasTemperature) {
                exp.setVariable(TEMPERATURE, biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_844 : 0.0);
            }
            if (this.hasDownfall) {
                exp.setVariable(DOWNFALL, biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_846 : 0.0);
            }
            exp.setVariable(POS_X, pos != null ? (double)pos.method_10263() : 0.0);
            exp.setVariable(POS_Y, pos != null ? (double)pos.method_10264() : 0.0);
            exp.setVariable(POS_Z, pos != null ? (double)pos.method_10260() : 0.0);
            if (this.hasRain) {
                exp.setVariable(RAIN, ClientFrameTicker.getRainAndThunder());
            }
            if (this.hasTime) {
                exp.setVariable(TIME, ClientFrameTicker.getGameTime());
            }
            if (this.hasDayTime) {
                exp.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
            }
            if (this.hasSunTime) {
                exp.setVariable(SUN_TIME, ClientFrameTicker.getSunTime());
            }
            if (stack != null) {
                float damage = 1.0f - (float)stack.method_7919() / (float)stack.method_7936();
                exp.setVariable(DAMAGE, damage);
            } else {
                exp.setVariable(DAMAGE, 0.0);
            }
            STATE_HACK.set(state);
            if (pos != null) {
                ExpressionUtils.seedRandom((long)pos.hashCode() * pos.method_10063());
            } else {
                ExpressionUtils.randomizeRandom();
            }
            result = (float)exp.evaluate();
            STATE_HACK.remove();
        }
        catch (Exception e) {
            Polytone.LOGGER.error("Failed to evaluate expression with value: {}", (Object)this.unparsed, (Object)e);
        }
        return result;
    }
}

