/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class ColormapsManager
extends JsonImgPartialReloader {
    public static final IColorGetter GRASS_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? class_1163.method_4962((class_1920)l, (class_2338)p) : class_1933.method_49724());
    public static final IColorGetter FOLIAGE_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? class_1163.method_4966((class_1920)l, (class_2338)p) : class_1926.method_8341());
    public static final IColorGetter WATER_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? class_1163.method_4961((class_1920)l, (class_2338)p) : -16777216);
    private final MapRegistry<Supplier<IColorGetter>> colormaps = new MapRegistry("Polytone Colormaps");

    public Codec<IColorGetter> byNameCodec() {
        return this.colormaps.xmap(Supplier::get, s -> () -> s);
    }

    public ColormapsManager() {
        super("colormaps");
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        this.addBuiltinColormaps();
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id = entry.getKey();
            Colormap colormap = (Colormap)((Pair)Colormap.DIRECT_CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Colormap with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            colormap.inlined = false;
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)colormap, usedTextures, true);
            this.add(id, colormap);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            class_2960 id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            defaultColormap.inlined = false;
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.add(id, defaultColormap);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
    }

    private void addBuiltinColormaps() {
        this.colormaps.register(new class_2960("grass_color"), () -> GRASS_COLOR);
        this.colormaps.register(new class_2960("foliage_color"), () -> FOLIAGE_COLOR);
        this.colormaps.register(new class_2960("water_color"), () -> WATER_COLOR);
        this.colormaps.register(new class_2960("biome_sample"), Colormap::createDefSquare);
        this.colormaps.register(new class_2960("triangular_biome_sample"), Colormap::createDefTriangle);
        this.colormaps.register(new class_2960("fixed"), Colormap::createFixed);
        this.colormaps.register(new class_2960("grid"), Colormap::createBiomeId);
        this.colormaps.register(new class_2960("damage"), Colormap::createDamage);
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.colormaps.clear();
    }

    public void add(class_2960 id, Colormap colormap) {
        this.colormaps.register(id, () -> colormap);
        if (!colormap.hasTexture()) {
            throw new IllegalStateException("Did not find any texture png for colormap " + String.valueOf(id));
        }
    }

    public static void tryAcceptingTextureGroup(Map<class_2960, ArrayImage.Group> availableTextures, class_2960 defaultPath, class_322 col, Set<class_2960> usedTexture, boolean strict) {
        if (col instanceof IndexCompoundColorGetter) {
            IndexCompoundColorGetter c = (IndexCompoundColorGetter)col;
            ColormapsManager.tryAcceptingTextureGroup(availableTextures, defaultPath, c, usedTexture, strict);
        } else if (col instanceof Colormap) {
            Colormap c = (Colormap)col;
            ColormapsManager.tryAcceptingTextureGroup(availableTextures, defaultPath, c, usedTexture, strict);
        }
    }

    private static void tryAcceptingTextureGroup(Map<class_2960, ArrayImage.Group> availableTextures, class_2960 defaultPath, Colormap c, Set<class_2960> usedTexture, boolean strict) {
        class_2960 textureLoc = c.getTargetTexture(defaultPath);
        ArrayImage.Group group = availableTextures.get(textureLoc);
        ArrayImage texture = group != null ? group.getDefault() : null;
        ColormapsManager.tryAcceptingTexture(texture, textureLoc, c, usedTexture, strict);
    }

    private static void tryAcceptingTextureGroup(Map<class_2960, ArrayImage.Group> textures, class_2960 id, IndexCompoundColorGetter colormap, Set<class_2960> usedTextures, boolean strict) {
        Int2ObjectMap<IColorGetter> blockColorGetters = colormap.getGetters();
        for (Int2ObjectMap.Entry g : blockColorGetters.int2ObjectEntrySet()) {
            Colormap c;
            int index = g.getIntKey();
            class_322 inner = (class_322)g.getValue();
            if (!(inner instanceof Colormap) || (c = (Colormap)inner).hasTexture()) continue;
            ArrayImage.Group textureMap = textures.get(c.getTargetTexture(id));
            if (strict && textureMap == null) {
                throw new IllegalStateException("Could not find a texture for tint index " + index + " for compound colormap " + String.valueOf(id) + ".Expected " + String.valueOf(id) + "_" + index);
            }
            if (blockColorGetters.size() == 1 || index == 0) {
                ColormapsManager.tryAcceptingTexture(textureMap.getDefault(), id, c, usedTextures, false);
            }
            try {
                ColormapsManager.tryAcceptingTexture((ArrayImage)textureMap.get(index), id, c, usedTextures, strict);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to apply a texture for tint index " + index + " for compound colormap " + String.valueOf(id) + ".Expected " + String.valueOf(id) + "_" + index + " : ", e);
            }
        }
    }

    public static void tryAcceptingTexture(Map<class_2960, ArrayImage> availableTextures, class_2960 defaultPath, @Nullable Object col, Set<class_2960> usedTexture, boolean strict) {
        if (col instanceof Colormap) {
            Colormap colormap = (Colormap)col;
            class_2960 textureLoc = colormap.getTargetTexture(defaultPath);
            ArrayImage texture = availableTextures.get(textureLoc);
            ColormapsManager.tryAcceptingTexture(texture, textureLoc, colormap, usedTexture, strict);
        }
    }

    private static void tryAcceptingTexture(@Nullable ArrayImage selectedTexture, class_2960 textureLoc, Colormap colormap, Set<class_2960> usedTexture, boolean strict) {
        String colormapName;
        if (colormap.hasTexture()) {
            return;
        }
        String string = colormapName = colormap.inlined ? "Inlined Colormap from modifier " + textureLoc.toString() : "Colormap at " + textureLoc.toString();
        if (selectedTexture != null) {
            usedTexture.add(textureLoc);
            colormap.acceptTexture(selectedTexture);
            if (selectedTexture.pixels().length == 0) {
                throw new IllegalStateException("Colormap texture at location " + String.valueOf(textureLoc) + " had invalid 0 dimension");
            }
        } else {
            class_2960 explTarget = colormap.getExplicitTargetTexture();
            if (explTarget != null) {
                Polytone.LOGGER.error("Could not resolve explicit texture at location {}.png. Skipping", (Object)explTarget);
            }
            if (strict) {
                throw new IllegalStateException("Could not find any colormap texture .png associated with path " + String.valueOf(textureLoc) + " for colormap '" + colormapName + "'");
            }
        }
    }
}

