/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7923;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<class_1792, ItemModifier> modifiers = new HashMap<class_1792, ItemModifier>();
    private final Map<class_1792, ItemModifier> vanillaProperties = new HashMap<class_1792, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        Object modifier;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, Parsed<ItemModifier>> parsedModifiers = new HashMap<class_2960, Parsed<ItemModifier>>();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id = entry.getKey();
            modifier = Parsed.parseFull(ItemModifier.CODEC, json, ops, id, "item modifier");
            parsedModifiers.put(id, (Parsed<ItemModifier>)modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            class_2960 tintId = (class_2960)entry.getKey();
            Parsed result = (Parsed)entry.getValue();
            modifier = (ItemModifier)result.getResultOrPartial();
            if (!((ItemModifier)modifier).hasTint() && textures.containsKey(tintId)) {
                modifier = ((ItemModifier)modifier).merge(ItemModifier.ofItemColor(Colormap.createDefTriangle()));
            }
            class_2960 barId = tintId.method_48331("_bar");
            if (!((ItemModifier)modifier).hasBarColor() && textures.containsKey(barId)) {
                modifier = ((ItemModifier)modifier).merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, tintId, ((ItemModifier)modifier).getTint(), usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, barId, ((ItemModifier)modifier).getBarColor(), usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(tintId, (ItemModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            Colormap defaultColormap;
            class_2960 id = (class_2960)entry.getKey();
            if (id.method_12832().endsWith("_bar")) {
                defaultColormap = Colormap.createDamage();
                ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
                this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
                continue;
            }
            defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofItemColor(defaultColormap));
        }
    }

    private void addModifier(class_2960 id, ItemModifier mod) {
        for (class_6880 item : mod.targets().compute(id, class_7923.field_41178)) {
            class_1792 i = (class_1792)item.comp_349();
            this.modifiers.merge(i, mod, ItemModifier::merge);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<class_1792, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        for (Map.Entry<class_1792, ItemModifier> e : this.modifiers.entrySet()) {
            class_1792 target = e.getKey();
            ItemModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            if (!value.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(value);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

