/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.ConcurrentExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_703;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class ParticleContextExpression {
    private final ConcurrentExpression expression;
    private final String unparsed;
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String TIME = "TIME";
    private static final String RAIN = "RAIN";
    private static final String SKY_LIGHT = "SKY_LIGHT";
    private static final String BLOCK_LIGHT = "BLOCK_LIGHT";
    private static final String TEMPERATURE = "TEMPERATURE";
    private static final String DOWNFALL = "DOWNFALL";
    private static final String PLAYER_X = "PLAYER_X";
    private static final String PLAYER_Y = "PLAYER_Y";
    private static final String PLAYER_Z = "PLAYER_Z";
    private static final String DISTANCE_SQUARED = "DISTANCE_SQUARED";
    private static final String PLAYER_SPEED_SQUARED = "PLAYER_SPEED_SQUARED";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            ConcurrentExpression compiled = ParticleContextExpression.createExpression(s);
            return DataResult.success((Object)new ParticleContextExpression(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    private final boolean hasTime;
    private final boolean hasRain;
    private final boolean hasDayTime;
    private final boolean hasCustom;
    private final boolean hasSkyLight;
    private final boolean hasBlockLight;
    private final boolean hasTemperature;
    private final boolean hasDownfall;
    private final boolean hasDistance;
    private final boolean hasPlayer;
    private final boolean hasPlayerSpeed;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        this(ParticleContextExpression.createExpression(expression), expression);
    }

    public ParticleContextExpression(ConcurrentExpression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTime = unparsed.contains(TIME);
        this.hasRain = unparsed.contains(RAIN);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasCustom = unparsed.contains(CUSTOM);
        this.hasSkyLight = unparsed.contains(SKY_LIGHT);
        this.hasBlockLight = unparsed.contains(BLOCK_LIGHT);
        this.hasTemperature = unparsed.contains(TEMPERATURE);
        this.hasDownfall = unparsed.contains(DOWNFALL);
        this.hasDistance = unparsed.contains(DISTANCE_SQUARED);
        this.hasPlayerSpeed = unparsed.contains(DISTANCE_SQUARED);
        this.hasPlayer = unparsed.contains(PLAYER_X) || unparsed.contains(PLAYER_Y) || unparsed.contains(PLAYER_Z);
    }

    public static ParticleContextExpression parse(String s) {
        return new ParticleContextExpression(ParticleContextExpression.createExpression(s), s);
    }

    private static ConcurrentExpression createExpression(String s) {
        return ConcurrentExpression.of(new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(new Function[0])).variables(new String[]{COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, ROLL, AGE, PLAYER_X, PLAYER_Y, PLAYER_Z, PLAYER_SPEED_SQUARED, CUSTOM, TIME, RAIN, DAY_TIME, SKY_LIGHT, BLOCK_LIGHT, DOWNFALL, TEMPERATURE, DISTANCE_SQUARED}).operator(ExpressionUtils.defOp(new Operator[0])));
    }

    public double getValue(class_703 particle, class_1937 level) {
        class_1297 e;
        this.expression.setVariable(LIFE, particle.method_3082());
        int pack = ColorUtils.pack(particle.field_3861, particle.field_3842, particle.field_3859);
        this.expression.setVariable(COLOR, pack);
        this.expression.setVariable(RED, particle.field_3861);
        this.expression.setVariable(GREEN, particle.field_3842);
        this.expression.setVariable(BLUE, particle.field_3859);
        this.expression.setVariable(SPEED, class_3532.method_33825((double)particle.field_3852, (double)particle.field_3869, (double)particle.field_3850));
        this.expression.setVariable(ALPHA, particle.field_3841);
        this.expression.setVariable(SIZE, ((class_3940)particle).field_17867);
        this.expression.setVariable(DX, particle.field_3852);
        this.expression.setVariable(DY, particle.field_3869);
        this.expression.setVariable(DZ, particle.field_3850);
        this.expression.setVariable(X, particle.field_3874);
        this.expression.setVariable(Y, particle.field_3854);
        this.expression.setVariable(Z, particle.field_3871);
        this.expression.setVariable(AGE, particle.field_3866);
        this.expression.setVariable(ROLL, particle.field_3839);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            this.expression.setVariable(CUSTOM, i.getCustom());
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, ClientFrameTicker.getGameTime());
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable(SKY_LIGHT, ClientFrameTicker.getSkyLight());
        }
        if (this.hasBlockLight) {
            this.expression.setVariable(BLOCK_LIGHT, ClientFrameTicker.getBlockLight());
        }
        if (this.hasTemperature) {
            this.expression.setVariable(TEMPERATURE, ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            this.expression.setVariable(DOWNFALL, ClientFrameTicker.getDownfall());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = particle.field_3874 - e.method_23317();
            double y = particle.field_3854 - e.method_23318();
            double z = particle.field_3871 - e.method_23321();
            this.expression.setVariable(DISTANCE_SQUARED, x * x + y * y + z * z);
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            this.expression.setVariable(PLAYER_X, e.method_23317());
            this.expression.setVariable(PLAYER_Y, e.method_23318());
            this.expression.setVariable(PLAYER_Z, e.method_23321());
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable(PLAYER_SPEED_SQUARED, ClientFrameTicker.getPlayerSpeed());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate();
    }
}

