/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ParticleModifier {
    public static final Codec<ParticleModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Filter.CODEC, "filter").forGetter(p -> Optional.ofNullable(p.filter)), (App)StrOpt.of(Colormap.CODEC, "colormap").forGetter(p -> Optional.ofNullable(p.colormap)), (App)StrOpt.of(ParticleContextExpression.CODEC, "color").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "life").forGetter(p -> Optional.ofNullable(p.lifeGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "size").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "red").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "green").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "blue").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "alpha").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)StrOpt.of(ParticleContextExpression.CODEC, "speed").forGetter(p -> Optional.ofNullable(p.speedGetter)), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(p -> p.targets)).apply((Applicative)instance, ParticleModifier::new));
    @Nullable
    private final Filter filter;
    @Nullable
    public final IColorGetter colormap;
    @Nullable
    public final ParticleContextExpression colorGetter;
    @Nullable
    public final ParticleContextExpression lifeGetter;
    @Nullable
    public final ParticleContextExpression sizeGetter;
    @Nullable
    public final ParticleContextExpression speedGetter;
    @Nullable
    public final ParticleContextExpression redGetter;
    @Nullable
    public final ParticleContextExpression blueGetter;
    @Nullable
    public final ParticleContextExpression greenGetter;
    @Nullable
    public final ParticleContextExpression alphaGetter;
    public final Targets targets;

    private ParticleModifier(Optional<Filter> filter, Optional<IColorGetter> colormap, Optional<ParticleContextExpression> color, Optional<ParticleContextExpression> life, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> speed, Targets targets) {
        this((Filter)filter.orElse(null), (IColorGetter)colormap.orElse(null), (ParticleContextExpression)color.orElse(null), (ParticleContextExpression)life.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)speed.orElse(null), targets);
    }

    public ParticleModifier(@Nullable Filter filter, @Nullable IColorGetter colormap, @Nullable ParticleContextExpression color, @Nullable ParticleContextExpression life, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression speed, Targets explicitTargets) {
        this.colorGetter = color;
        this.lifeGetter = life;
        this.sizeGetter = size;
        this.redGetter = red;
        this.greenGetter = green;
        this.blueGetter = blue;
        this.alphaGetter = alpha;
        this.speedGetter = speed;
        this.targets = explicitTargets;
        this.filter = filter;
        this.colormap = colormap;
    }

    public static ParticleModifier ofColor(String color) {
        ParticleContextExpression expression = ParticleContextExpression.parse(color);
        return new ParticleModifier(null, null, expression, null, null, null, null, null, null, null, Targets.EMPTY);
    }

    public Targets targets() {
        return this.targets;
    }

    public void modify(class_703 particle, class_1937 level, class_2394 options) {
        if (this.filter != null && !this.filter.test(options)) {
            return;
        }
        if (this.colorGetter != null) {
            float[] unpack = ColorUtils.unpack((int)this.colorGetter.getValue(particle, level));
            particle.method_3084(unpack[0], unpack[1], unpack[2]);
        }
        if (this.colormap != null) {
            class_2680 state = null;
            if (options instanceof class_2388) {
                class_2388 bo = (class_2388)options;
                state = bo.method_10278();
            }
            float[] unpack = ColorUtils.unpack(this.colormap.getColor(state, (class_1920)level, class_2338.method_49637((double)particle.field_3874, (double)particle.field_3854, (double)particle.field_3871), 0));
            particle.method_3084(unpack[0], unpack[1], unpack[2]);
        }
        if (this.lifeGetter != null) {
            particle.method_3077((int)this.lifeGetter.getValue(particle, level));
        }
        if (this.sizeGetter != null) {
            particle.method_3087((float)this.sizeGetter.getValue(particle, level));
        }
        if (this.redGetter != null) {
            particle.field_3861 = (float)this.redGetter.getValue(particle, level);
        }
        if (this.greenGetter != null) {
            particle.field_3842 = (float)this.greenGetter.getValue(particle, level);
        }
        if (this.blueGetter != null) {
            particle.field_3859 = (float)this.blueGetter.getValue(particle, level);
        }
        if (this.speedGetter != null) {
            double speed = this.speedGetter.getValue(particle, level);
            particle.field_3852 *= speed;
            particle.field_3869 *= speed;
            particle.field_3850 *= speed;
        }
        if (this.alphaGetter != null) {
            particle.field_3841 = (float)this.alphaGetter.getValue(particle, level);
        }
    }

    private record Filter(@Nullable class_2248 forBlock, @Nullable class_1792 forItem) implements Predicate<class_2394>
    {
        public static final Codec<Filter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(class_7923.field_41175.method_39673(), "block").forGetter(p -> Optional.ofNullable(p.forBlock)), (App)StrOpt.of(class_7923.field_41178.method_39673(), "item").forGetter(p -> Optional.ofNullable(p.forItem))).apply((Applicative)instance, Filter::new));

        Filter(Optional<class_2248> state, Optional<class_1792> item) {
            this((class_2248)state.orElse(null), (class_1792)item.orElse(null));
        }

        @Override
        public boolean test(class_2394 particleOptions) {
            if (this.forBlock != null && particleOptions instanceof class_2388) {
                class_2388 bo = (class_2388)particleOptions;
                return bo.method_10278().method_26204() == this.forBlock;
            }
            if (this.forItem != null && particleOptions instanceof class_2392) {
                class_2392 io = (class_2392)particleOptions;
                return io.method_10289().method_7909() == this.forItem;
            }
            return true;
        }
    }
}

