/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Multimap<class_2396<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(class_2394 options, class_1937 level, class_703 particle) {
        Collection mod = this.particleModifiers.get((Object)options.method_10295());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            Optional<ParticleModifier> modifier = Parsed.parseOptional(ParticleModifier.CODEC, json, ops, id, "particle modifier");
            modifier.ifPresent(m -> this.addModifier(id, (ParticleModifier)m));
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(class_2960 pathId, ParticleModifier mod) {
        for (class_6880 p : mod.targets().compute(pathId, class_7923.field_41180)) {
            this.particleModifiers.put((Object)((class_2396)p.comp_349()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(class_2960 id, String color) {
        Optional opt = class_7923.field_41180.method_17966(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

