/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.mehvahdjukaar.polytone.texture.DayTimeTexture;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7768;
import org.jetbrains.annotations.Nullable;

public class DayTimeTextureTicker
implements class_7768 {
    private final class_7764.class_5790 animationInfo;
    @Nullable
    private final InterpolationData interpolationData;
    private final float animationScaleFactor;
    private final TreeMap<Float, Integer> frameMap = new TreeMap();
    private final int timeCycleDuration;
    private final DayTimeTexture.Mode mode;
    private int lastFrameIndex = 0;

    public DayTimeTextureTicker(class_7764.class_5790 animationInfo, class_7764 spriteContents, boolean interpolateFrames, int dayDuration, DayTimeTexture.Mode mode) {
        this.animationInfo = animationInfo;
        this.timeCycleDuration = dayDuration;
        this.mode = mode;
        this.interpolationData = interpolateFrames ? new InterpolationData(spriteContents) : null;
        int totalDuration = 0;
        for (class_7764.class_5791 frameInfo : animationInfo.field_28472) {
            totalDuration += frameInfo.field_28476;
        }
        this.animationScaleFactor = 1.0f / (float)totalDuration;
        float accumulatedTime = 0.0f;
        for (int i = 0; i < animationInfo.field_28472.size(); ++i) {
            class_7764.class_5791 frameInfo = (class_7764.class_5791)animationInfo.field_28472.get(i);
            float scaledDuration = (float)frameInfo.field_28476 * this.animationScaleFactor;
            this.frameMap.put(Float.valueOf(accumulatedTime), i);
            accumulatedTime += scaledDuration;
        }
    }

    public void method_45824(int x, int y) {
        Float delta = this.getDelta();
        if (delta == null) {
            return;
        }
        Map.Entry<Float, Integer> currentFrame = this.frameMap.floorEntry(delta);
        Integer frameOrdinal = currentFrame.getValue();
        List frames = this.animationInfo.field_28472;
        class_7764.class_5791 frameInfo = (class_7764.class_5791)frames.get(frameOrdinal);
        if (frameInfo.field_28475 != this.lastFrameIndex) {
            this.animationInfo.method_33455(x, y, frameInfo.field_28475);
        }
        if (this.interpolationData != null) {
            class_7764.class_5791 nextFrameInfo = (class_7764.class_5791)frames.get((frameOrdinal + 1) % frames.size());
            float floorKey = currentFrame.getKey().floatValue();
            float frameDelta = (delta.floatValue() - floorKey) / this.animationScaleFactor;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo));
            } else {
                this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo);
            }
        }
        this.lastFrameIndex = frameInfo.field_28475;
    }

    @Nullable
    private Float getDelta() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        if (this.mode == DayTimeTexture.Mode.WEATHER) {
            float rainAndThunder = ClientFrameTicker.getRainAndThunder() * 2.0f / 3.0f;
            return Float.valueOf(rainAndThunder + 0.0f);
        }
        if (this.mode == DayTimeTexture.Mode.GAME_TIME) {
            double gameTime = level.method_8510() % (long)this.timeCycleDuration;
            return Float.valueOf((float)(gameTime / (double)this.timeCycleDuration));
        }
        double dayTime = ClientFrameTicker.getDayTime() % (double)this.timeCycleDuration;
        return Float.valueOf((float)(dayTime / (double)this.timeCycleDuration));
    }

    public void close() {
        if (this.interpolationData != null) {
            this.interpolationData.close();
        }
    }

    public static final class InterpolationData
    implements AutoCloseable {
        private final class_1011[] activeFrame;
        private final class_7764 spriteContents;

        InterpolationData(class_7764 spriteContents) {
            this.spriteContents = spriteContents;
            this.activeFrame = new class_1011[spriteContents.field_40540.length];
            for (int i = 0; i < this.activeFrame.length; ++i) {
                int j = spriteContents.method_45807() >> i;
                int k = spriteContents.method_45815() >> i;
                this.activeFrame[i] = new class_1011(j, k, false);
            }
        }

        void uploadInterpolatedFrame(int x, int y, class_7764.class_5791 currentFrame, class_7764.class_5791 nextFrame, float frameDelta, class_7764.class_5790 animatedTexture) {
            double time = currentFrame.field_28476;
            double delta = 1.0 - (double)frameDelta / time;
            int currentFrameIndex = currentFrame.field_28475;
            int nextFrameIndex = nextFrame.field_28475;
            if (currentFrameIndex != nextFrameIndex) {
                for (int k = 0; k < this.activeFrame.length; ++k) {
                    int l = this.spriteContents.method_45807() >> k;
                    int m = this.spriteContents.method_45815() >> k;
                    for (int n = 0; n < m; ++n) {
                        for (int o = 0; o < l; ++o) {
                            int p = this.getPixel(animatedTexture, currentFrameIndex, k, o, n);
                            int q = this.getPixel(animatedTexture, nextFrameIndex, k, o, n);
                            int r = this.mix(delta, p >> 16 & 0xFF, q >> 16 & 0xFF);
                            int s = this.mix(delta, p >> 8 & 0xFF, q >> 8 & 0xFF);
                            int t = this.mix(delta, p & 0xFF, q & 0xFF);
                            this.activeFrame[k].method_4305(o, n, p & 0xFF000000 | r << 16 | s << 8 | t);
                        }
                    }
                }
                this.spriteContents.method_45811(x, y, 0, 0, this.activeFrame);
            }
        }

        private int getPixel(class_7764.class_5790 animatedTexture, int frameIndex, int mipLevel, int x, int y) {
            return this.spriteContents.field_40540[mipLevel].method_4315(x + (animatedTexture.method_33446(frameIndex) * this.spriteContents.method_45807() >> mipLevel), y + (animatedTexture.method_33451(frameIndex) * this.spriteContents.method_45815() >> mipLevel));
        }

        private int mix(double delta, int color1, int color2) {
            return (int)(delta * (double)color1 + (1.0 - delta) * (double)color2);
        }

        @Override
        public void close() {
            for (class_1011 nativeImage : this.activeFrame) {
                nativeImage.close();
            }
        }
    }
}

