/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.Streams;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class AlternativeMapCodec<A>
extends MapCodec<A> {
    private final MapCodec<A> first;
    private final MapCodec<A> second;
    private final A defaultValue;

    public AlternativeMapCodec(MapCodec<A> first, MapCodec<A> second, A defaultValue) {
        this.first = first;
        this.second = second;
        this.defaultValue = defaultValue;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Streams.concat((Stream[])new Stream[]{this.first.keys(ops), this.second.keys(ops)});
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult firstRead = this.first.decode(ops, input);
        if (firstRead.result().isPresent()) {
            return firstRead;
        }
        DataResult secondRead = this.second.decode(ops, input);
        if (secondRead.result().isPresent()) {
            return secondRead;
        }
        if (firstRead.result().isPresent()) {
            return firstRead;
        }
        if (secondRead.result().isPresent()) {
            return secondRead;
        }
        if (this.defaultValue != null) {
            return DataResult.success(this.defaultValue);
        }
        return DataResult.error(() -> "Failed to parse either. First: " + ((DataResult.PartialResult)firstRead.error().orElseThrow()).message() + "; Second: " + ((DataResult.PartialResult)secondRead.error().orElseThrow()).message());
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return this.first.encode(input, ops, prefix);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AlternativeMapCodec that = (AlternativeMapCodec)((Object)obj);
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "AlternativeMapCodec[first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "]";
    }

    public static <B> MapCodec<Optional<B>> optionalAlias(Codec<B> codec, String primaryName, String alias) {
        return new AlternativeMapCodec<Optional<B>>(codec.fieldOf(primaryName).xmap(Optional::of, Optional::get), codec.fieldOf(alias).xmap(Optional::of, Optional::get), Optional.empty());
    }

    public static <B> MapCodec<B> alias(Codec<B> codec, String primaryName, String alias) {
        return new AlternativeMapCodec<Object>(codec.fieldOf(primaryName), codec.fieldOf(alias), null);
    }
}

