/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.mehvahdjukaar.polytone.mixins.accessor.BiomeAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;

public class ColorUtils {
    public static final Codec<Integer> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.flatXmap(ColorUtils::isValidStringOrError, s -> ColorUtils.isValidStringOrError(s).map(ColorUtils::formatString))).xmap(either -> (Integer)either.map(integer -> integer, s -> Integer.parseUnsignedInt(s, 16)), integer -> Either.right((Object)("#" + String.format("%08X", integer))));

    private static String formatString(String s) {
        return "#" + s.toUpperCase(Locale.ROOT);
    }

    public static DataResult<String> isValidStringOrError(String s) {
        String st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        if (st.length() > 8) {
            return DataResult.error(() -> "Invalid color format. Hex value must have up to 8 characters.");
        }
        try {
            int parsedValue = Integer.parseUnsignedInt(st, 16);
            return DataResult.success((Object)st);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid color format. Must be in hex format (0xff00ff00, #ff00ff00, ff00ff00) or integer value");
        }
    }

    public static boolean isValidString(String s) {
        return ColorUtils.isValidStringOrError(s).result().isPresent();
    }

    public static int pack(float ... components) {
        int n = (int)(components[0] * 255.0f) << 16;
        int o = (int)(components[1] * 255.0f) << 8;
        int p = (int)(components[2] * 255.0f);
        return n & 0xFF0000 | o & 0xFF00 | p & 0xFF;
    }

    public static float[] unpack(int value) {
        int n = (value & 0xFF0000) >> 16;
        int o = (value & 0xFF00) >> 8;
        int p = value & 0xFF;
        return new float[]{(float)n / 255.0f, (float)o / 255.0f, (float)p / 255.0f};
    }

    public static class_1959.class_5482 getClimateSettings(class_1937 level, class_2338 pos) {
        return ColorUtils.getClimateSettings((class_1959)level.method_23753(pos).comp_349());
    }

    public static class_1959.class_5482 getClimateSettings(class_1959 biome) {
        return ((BiomeAccessor)biome).getClimateSettings();
    }
}

