/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements Codec<T> {
    private final BiMap<class_2960, T> map = HashBiMap.create();
    private final List<class_2960> orderedKeys = new ArrayList<class_2960>();
    private final String name;

    public MapRegistry(String name) {
        this.name = name;
    }

    public static <B> CodecMap<B> ofCodec(String name) {
        return new CodecMap(name);
    }

    public <E> Codec<E> dispatch(Function<? super E, ? extends T> type) {
        return super.dispatch(type, c -> (Codec)c);
    }

    public <B extends T> T register(class_2960 name, B value) {
        this.map.put((Object)name, value);
        if (!this.orderedKeys.contains(name)) {
            this.orderedKeys.add(name);
        }
        return value;
    }

    public <B extends T> T register(String name, B value) {
        this.register(new class_2960(name), value);
        return value;
    }

    public void unregister(class_2960 name) {
        this.map.remove((Object)name);
        this.orderedKeys.remove(name);
    }

    @Nullable
    public T getValue(class_2960 name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public T getValue(String name) {
        return this.getValue(new class_2960(name));
    }

    @Nullable
    public class_2960 getKey(T value) {
        return (class_2960)this.map.inverse().get(value);
    }

    public Set<class_2960> keySet() {
        return this.map.keySet();
    }

    public List<class_2960> orderedKeys() {
        return this.orderedKeys;
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public Set<Map.Entry<class_2960, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(class_2960 name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return class_2960.field_25139.decode(ops, json).flatMap(pair -> {
            class_2960 id = (class_2960)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Could not find any entry with key '" + String.valueOf(id) + "' in registry [" + this.name + "] \n Known keys: " + String.valueOf(this.keySet())) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        class_2960 id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Could not find element '" + String.valueOf(object) + "' in registry [" + this.name + "]") : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }

    public void clear() {
        this.orderedKeys.clear();
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public static class CodecMap<T>
    extends MapRegistry<Codec<? extends T>> {
        public CodecMap(String name) {
            super(name);
        }

        @Override
        public <B extends T> Codec<B> register(class_2960 name, Codec<B> value) {
            super.register(name, value);
            return value;
        }

        @Override
        public <B extends T> Codec<B> register(String name, Codec<B> value) {
            return this.register(new class_2960(name), value);
        }
    }
}

