/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.apache.commons.lang3.StringUtils;

public abstract class PartialReloader<T> {
    public static final Gson GSON = new Gson();
    protected String[] names;

    protected PartialReloader(String ... name) {
        this.names = name;
    }

    public String toString() {
        return StringUtils.capitalize((String)(this.names[0].replace("_", " ") + " Reloader"));
    }

    protected Map<class_2960, JsonElement> getJsonsInDirectories(class_3300 resourceManager) {
        HashMap<class_2960, JsonElement> jsons = new HashMap<class_2960, JsonElement>();
        for (String name : this.names) {
            HashMap js = new HashMap();
            class_4309.method_51148((class_3300)resourceManager, (String)("polytone/" + name), (Gson)GSON, js);
            PartialReloader.greedyAddAll(js, jsons);
        }
        return jsons;
    }

    private static <T> void greedyAddAll(Map<class_2960, T> js, Map<class_2960, T> jsons) {
        for (Map.Entry<class_2960, T> entry : js.entrySet()) {
            class_2960 r = entry.getKey();
            T j = entry.getValue();
            if (jsons.containsKey(r)) {
                Polytone.LOGGER.warn("Duplicate data file ignored with ID {}", (Object)r);
            }
            jsons.put(r, j);
        }
    }

    protected Map<class_2960, ArrayImage> getImagesInDirectories(class_3300 resourceManager) {
        HashMap<class_2960, ArrayImage> images = new HashMap<class_2960, ArrayImage>();
        for (String name : this.names) {
            HashMap<class_2960, ArrayImage> im = new HashMap<class_2960, ArrayImage>();
            ArrayImage.scanDirectory(resourceManager, "polytone/" + name, im);
            PartialReloader.greedyAddAll(im, images);
        }
        return images;
    }

    protected Map<class_2960, ArrayImage.Group> getGroupedImagesInDirectories(class_3300 manager) {
        return ArrayImage.groupTextures(this.getImagesInDirectories(manager));
    }

    protected void earlyProcess(class_3300 resourceManager) {
    }

    protected abstract T prepare(class_3300 var1);

    protected abstract void parseWithLevel(T var1, class_6903<JsonElement> var2, class_5455 var3);

    protected abstract void applyWithLevel(class_5455 var1, boolean var2);

    protected abstract void resetWithLevel(boolean var1);
}

