/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.string.number;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.controllers.slider.LongSliderController;
import dev.isxander.yacl3.gui.controllers.string.number.NumberFieldController;
import java.util.function.Function;
import net.minecraft.class_2561;

public class LongFieldController
extends NumberFieldController<Long> {
    private final long min;
    private final long max;

    public LongFieldController(Option<Long> option, long min, long max, Function<Long, class_2561> formatter) {
        super(option, formatter);
        this.min = min;
        this.max = max;
    }

    public LongFieldController(Option<Long> option, long min, long max) {
        this(option, min, max, LongSliderController.DEFAULT_FORMATTER);
    }

    public LongFieldController(Option<Long> option, Function<Long, class_2561> formatter) {
        this(option, -9223372036854775807L, Long.MAX_VALUE, formatter);
    }

    public LongFieldController(Option<Long> option) {
        this(option, -9223372036854775807L, Long.MAX_VALUE, LongSliderController.DEFAULT_FORMATTER);
    }

    public static LongFieldController createInternal(Option<Long> option, long min, long max, ValueFormatter<Long> formatter) {
        return new LongFieldController(option, min, max, formatter::format);
    }

    @Override
    public boolean isInputValid(String input) {
        return input.matches("(?:-?\\d+|)");
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public String getString() {
        return String.valueOf(this.option().pendingValue());
    }

    @Override
    public void setPendingValue(double value) {
        this.option().requestSet((long)value);
    }

    @Override
    public double pendingValue() {
        return ((Long)this.option().pendingValue()).longValue();
    }
}

