/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.text.WordUtils;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    String dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.INSTANCE.getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            Minecraft mc;
            String serverName;
            block9: {
                serverName = null;
                mc = Minecraft.getInstance();
                if (!mc.hasSingleplayerServer()) {
                    try {
                        RealmsScreen realmsScreen;
                        ClientPacketListener netHandler = mc.getConnection();
                        Screen callbackScreen = netHandler.postDisconnectScreen;
                        if (!(callbackScreen instanceof RealmsScreen) || !((realmsScreen = (RealmsScreen)callbackScreen) instanceof RealmsMainScreen)) break block9;
                        RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                        RealmsServer selectedServer = mainScreen.getSelectedServer();
                        List realmsServers = StreamSupport.stream(mainScreen.serverList.spliterator(), false).toList();
                        for (RealmsServer realmsServer : realmsServers) {
                            if (realmsServer.id != selectedServer.id) continue;
                            serverName = realmsServer.name;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                    }
                }
            }
            if (serverName != null) {
                return serverName.replaceAll("\\W+", "~").trim();
            }
            mc = Minecraft.getInstance();
            ServerData serverData = mc.getCurrentServer();
            if (serverData != null && (serverName = serverData.name) != null) {
                serverName = serverName.replaceAll("\\W+", "~").trim();
                if (Services.COMMON_SERVICE.isModLoaded("essential") || Strings.isNullOrEmpty((String)serverName.replaceAll("~", ""))) {
                    serverName = serverData.ip;
                }
                return serverName.replaceAll("\\W+", "~").trim();
            }
            return null;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName().replaceAll("\\W+", "~").trim();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            Connection netManager = Minecraft.getInstance().getConnection().getConnection();
            if (netManager != null && (socketAddress = netManager.getRemoteAddress()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(Minecraft mc) {
        String serverName = null;
        if (mc.hasSingleplayerServer()) {
            return mc.getSingleplayerServer().storageSource.getLevelId();
        }
        serverName = WorldData.getServerName();
        if (serverName == null) {
            return "offline";
        }
        if (Strings.isNullOrEmpty((String)serverName.trim())) {
            serverName = "unnamed";
        }
        return serverName.trim();
    }

    public static List<DimensionProvider> getDimensionProviders() {
        return WorldData.getDimensionProviders(Lists.newArrayList());
    }

    public static List<DimensionProvider> getDimensionProviders(List<String> requiredDimensionList) {
        try {
            HashSet<String> requiredDims = new HashSet<String>(requiredDimensionList);
            HashMap<String, DimensionProvider> dimProviders = new HashMap<String, DimensionProvider>();
            org.apache.logging.log4j.Level logLevel = org.apache.logging.log4j.Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Minecraft mc = Minecraft.getInstance();
            ResourceKey<Level> dimension = DimensionHelper.getDimension((Entity)mc.player);
            String dimId = DimensionHelper.getDimKeyName(dimension);
            WrappedProvider playerDimProvider = new WrappedProvider(dimension);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (ResourceKey<Level> resourceKey : DimensionHelper.getClientDimList()) {
                try {
                    WrappedProvider dimProvider = new WrappedProvider(resourceKey);
                    dimProviders.put(DimensionHelper.getDimKeyName(resourceKey), dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", resourceKey, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.throwLogOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", resourceKey, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (String string : requiredDims) {
                if (dimProviders.containsKey(string)) continue;
                dimProviders.put(string, new DummyProvider(DimensionHelper.getWorldKeyForName(string)));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", string));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, (o1, o2) -> String.valueOf(o1.getDimensionId()).compareTo(o2.getDimensionId()));
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getDimensionId() == null) {
            return null;
        }
        try {
            return dimensionProvider.getDimensionId();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.getInstance();
            return Constants.getString("jm.common.dimension", DimensionHelper.getDimName((Level)mc.level));
        }
    }

    public static String getDimension() {
        LocalPlayer player = Minecraft.getInstance().player;
        String dim = DimensionHelper.getDimName((Entity)player);
        String dimName = WorldData.getSafeDimensionName(new WrappedProvider((ResourceKey<Level>)Minecraft.getInstance().player.level().dimension()));
        return dimName + " (" + dim + ")";
    }

    public static String getCurrentWeather() {
        String weather = "jm.common.info_slot.weather.clear";
        if (Minecraft.getInstance().level.isRaining()) {
            weather = "jm.common.info_slot.weather.rain";
            if (Minecraft.getInstance().level.isThundering()) {
                weather = "jm.common.info_slot.weather.thunder";
            }
        }
        return Constants.getString("jm.common.info_slot.weather.label", Constants.getString(weather));
    }

    public static String getDay() {
        long days = Minecraft.getInstance().level.getGameTime() / 24000L;
        return Constants.getString("jm.theme.infoslot.day", days);
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel.ClientLevelData worldInfo = mc.level.getLevelData();
        IntegratedServer server = mc.getSingleplayerServer();
        boolean multiplayer = server == null || server.isPublished();
        this.name = WorldData.getWorldName(mc);
        this.dimension = DimensionHelper.getDimKeyName((Level)mc.level);
        this.hardcore = worldInfo.isHardcore();
        this.singlePlayer = !multiplayer;
        this.time = mc.level.getDayTime() % 24000L;
        this.features = FeatureManager.getInstance().getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = SharedConstants.getCurrentVersion().name();
        return this;
    }

    public static String getLightLevel() {
        BlockPos blockpos = Minecraft.getInstance().player.blockPosition();
        ClientLevel world = Minecraft.getInstance().level;
        LevelChunk chunk = world.getChunkAt(blockpos);
        int light = chunk.getLevel().getLightEngine().getRawBrightness(blockpos, 0);
        int lightSky = world.getBrightness(LightLayer.SKY, blockpos);
        int lightBlock = world.getBrightness(LightLayer.BLOCK, blockpos);
        return String.format("Light: %s (%s sky, %s block)", light, lightSky, lightBlock);
    }

    public static String getRegion() {
        BlockPos blockpos = Minecraft.getInstance().player.blockPosition();
        LevelChunk chunk = Minecraft.getInstance().level.getChunkAt(blockpos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunk.getPos().x, chunk.getPos().z);
        return "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
    }

    public static String getRealGameTime() {
        String format = JourneymapClient.getInstance().getActiveMiniMapProperties().infoSlotTimeFormat.get();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        Minecraft minecraft = Minecraft.getInstance();
        long time = minecraft.level.getDayTime();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        double ticks = (double)time - Math.floor((double)time / 16.666666666666668) * 16.666666666666668;
        long seconds = (long)Math.floor(ticks / 0.2777777777777778);
        try {
            String timeString = String.format(Locale.ENGLISH, "%02d:%02d:%02d", Math.max(0L, hour), Math.max(0L, minute), Math.max(0L, seconds));
            String formattedTime = LocalTime.parse(timeString).format(dtf);
            return formattedTime + " " + WorldData.getContextTime(time % 24000L);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Unable to calculate time for GameTimeReal time:{}, hour:{}, minute:{}, seconds:{}, ticks:{}", (Object)time, (Object)hour, (Object)minute, (Object)ticks, (Object)seconds, (Object)e);
            return "00e:00e:00e";
        }
    }

    public static String getGameTime() {
        if (Minecraft.getInstance().level != null) {
            long worldTime = Minecraft.getInstance().level.getDayTime() % 24000L;
            long allSecs = worldTime / 20L;
            String format = JourneymapClient.getInstance().getActiveMiniMapProperties().infoSlotTimeFormat.get().replace(":ss", "").replace(" a", "");
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
            String timeString = String.format(Locale.ENGLISH, "%02d:%02d", Math.max(0L, (long)Math.floor((double)allSecs / 60.0)), Math.max(0L, (long)Math.ceil(allSecs % 60L)));
            String formattedTime = LocalTime.parse(timeString).format(dtf);
            return formattedTime + " " + WorldData.getContextTime(worldTime);
        }
        return "";
    }

    public static String getMovementSpeed() {
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 playerPos = player.position();
        double travelX = playerPos.x - player.xOld;
        double travelZ = playerPos.z - player.zOld;
        double currentSpeed = Mth.sqrt((float)((float)(travelX * travelX + travelZ * travelZ))) / 0.05f;
        double currentVertSpeed = (playerPos.y - player.yOld) / (double)0.05f;
        return Constants.getString("jm.common.info_slot.movement_speed.game", String.format("%.2f", currentSpeed));
    }

    public static String getMoonPhase() {
        int phase = Minecraft.getInstance().level.getMoonPhase();
        long worldTime = Minecraft.getInstance().level.getDayTime() % 24000L;
        if (WorldData.isDay(worldTime)) {
            phase = 10;
        }
        return MoonPhase.fromPhase(phase);
    }

    public static String getSystemTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat(JourneymapClient.getInstance().getActiveMiniMapProperties().systemTimeRealFormat.get());
        return timeFormat.format(new Date());
    }

    private static String getContextTime(long worldTime) {
        if (worldTime < 12000L) {
            return TimeValue.DAYTIME.getText();
        }
        if (worldTime < 13800L) {
            return TimeValue.SUNSET.getText();
        }
        if (worldTime < 22200L) {
            return TimeValue.NIGHT.getText();
        }
        return TimeValue.SUNRISE.getText();
    }

    public static boolean isDay(long worldTime) {
        return worldTime % 24000L < 13800L;
    }

    public static boolean isNight(long worldTime) {
        return worldTime % 24000L >= 13800L;
    }

    public long getTTL() {
        return 1000L;
    }

    public static class WrappedProvider
    implements DimensionProvider {
        ResourceKey<Level> dimension;

        public WrappedProvider(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dimension);
        }

        @Override
        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        @Override
        public String getName() {
            Object dim = DimensionHelper.getDimName(this.dimension).replace("_", " ");
            if (((String)dim).length() > 25) {
                String pre = ((String)dim).substring(0, 9);
                String suffix = ((String)dim).substring(((String)dim).length() - 5, ((String)dim).length() - 1);
                dim = pre + " ... " + suffix;
            }
            return WordUtils.capitalize((String)dim);
        }
    }

    public static interface DimensionProvider {
        public String getDimensionId();

        public ResourceKey<Level> getDimension();

        public String getName();
    }

    static class DummyProvider
    implements DimensionProvider {
        final ResourceKey<Level> dim;

        DummyProvider(ResourceKey<Level> dim) {
            this.dim = dim;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dim);
        }

        @Override
        public ResourceKey<Level> getDimension() {
            return null;
        }

        @Override
        public String getName() {
            return "Dimension " + DimensionHelper.getDimName(this.dim);
        }
    }

    static enum MoonPhase {
        DAY_TIME(10, "jm.theme.labelsource.moonphase.day"),
        FULL_MOON(0, "jm.theme.labelsource.moonphase.full_moon"),
        WANING_GIBBOUS(1, "jm.theme.labelsource.moonphase.waning_gibbous"),
        THIRD_QUARTER(2, "jm.theme.labelsource.moonphase.third_quarter"),
        WANING_CRESCENT(3, "jm.theme.labelsource.moonphase.waning_crescent"),
        NEW_MOON(4, "jm.theme.labelsource.moonphase.new_moon"),
        WAXING_CRESCENT(5, "jm.theme.labelsource.moonphase.waxing_crescent"),
        FIRST_QUARTER(6, "jm.theme.labelsource.moonphase.first_quarter"),
        WAXING_GIBBOUS(7, "jm.theme.labelsource.moonphase.waxing_gibbous");

        final int phase;
        final String key;
        static final Map<Integer, String> PHASE_MAP;

        private MoonPhase(int phase, String key) {
            this.phase = phase;
            this.key = key;
        }

        public static String fromPhase(int phase) {
            String phaseName = Constants.getString(PHASE_MAP.get(phase));
            String moonPhase = Constants.getString("jm.theme.labelsource.moonphase.pre");
            return moonPhase + phaseName;
        }

        static {
            PHASE_MAP = Stream.of(MoonPhase.values()).collect(Collectors.toMap(e -> e.phase, e -> e.key));
        }
    }

    static enum TimeValue {
        DAYTIME("jm.theme.labelsource.gametime.day"),
        SUNRISE("jm.theme.labelsource.gametime.sunrise"),
        SUNSET("jm.theme.labelsource.gametime.sunset"),
        NIGHT("jm.theme.labelsource.gametime.night");

        final String key;

        private TimeValue(String key) {
            this.key = key;
        }

        public String getText() {
            return Constants.getString(this.key);
        }
    }
}

