/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import journeymap.client.event.ForgeEventHandlerManager;
import journeymap.client.event.handlers.ChatEventHandler;
import journeymap.client.event.handlers.ChunkMonitorHandler;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.event.handlers.PlayerConnectHandler;
import journeymap.client.event.handlers.ScreenEventHandler;
import journeymap.client.event.handlers.StateTickHandler;
import journeymap.client.event.handlers.WorldEventHandler;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeEvents
implements ForgeEventHandlerManager.EventHandler {
    private final WorldEventHandler worldEventHandler = new WorldEventHandler();
    private final StateTickHandler stateTickHandler = new StateTickHandler();
    private final PlayerConnectHandler playerConnectHandler = new PlayerConnectHandler();

    @SubscribeEvent(priority=0)
    public void onRenderOverlayDebug(CustomizeGuiOverlayEvent.DebugText event) {
        if (CustomizeGuiOverlayEvent.DebugText.Side.Left == event.getSide()) {
            HudOverlayHandler.getInstance().onRenderOverlayDebug(event.getText());
        }
    }

    @SubscribeEvent
    public void onConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        this.playerConnectHandler.onConnect();
    }

    @SubscribeEvent
    public void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        this.playerConnectHandler.onDisconnect();
    }

    @SubscribeEvent
    public boolean onScreenMousePressedEvent(ScreenEvent.MouseButtonPressed.Pre event) {
        return ScreenEventHandler.getInstance().onScreenMousePressedEvent(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getButton());
    }

    @SubscribeEvent
    public boolean onScreenMouseDraggedEvent(ScreenEvent.MouseDragged.Pre event) {
        return ScreenEventHandler.getInstance().onScreenMouseDraggedEvent(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getDragX(), event.getDragY(), event.getMouseButton());
    }

    @SubscribeEvent
    public boolean onScreenMouseReleasedEvent(ScreenEvent.MouseButtonReleased.Pre event) {
        return ScreenEventHandler.getInstance().onScreenMouseReleasedEvent(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getButton());
    }

    @SubscribeEvent
    public void onScreenMouseReleasedEvent(ScreenEvent.Closing event) {
        ScreenEventHandler.getInstance().onScreenClosedEvent(event.getScreen());
    }

    @SubscribeEvent
    public void onChatRecieved(ClientChatReceivedEvent event) {
        Component component = ChatEventHandler.getInstance().onClientChatEventReceived(event.getMessage());
        if (component != null) {
            event.setMessage(component);
        }
    }

    @SubscribeEvent
    public void onClientCommandRegistration(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"jmc").then(((RequiredArgumentBuilder)Commands.argument((String)"sub", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ChatEventHandler.getInstance().onChatEvent(context.getInput());
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ChatEventHandler.getInstance().onChatEvent(context.getInput());
            return 1;
        }))));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent.Pre event) {
        this.stateTickHandler.onClientTick();
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload event) {
        this.worldEventHandler.onUnload(event.getLevel());
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent event) {
        ChunkMonitorHandler.getInstance().onBlockUpdate(event.getLevel(), event.getPos());
    }

    @SubscribeEvent
    public void onChunkUpdate(ChunkWatchEvent event) {
        ChunkMonitorHandler.getInstance().onChunkUpdate((LevelAccessor)event.getLevel(), event.getPos());
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkMonitorHandler.getInstance().onChunkLoad(event.getLevel(), event.getChunk());
    }
}

