/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.DraggableListPane;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.ResetButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.minimap.Effect;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class MinimapOptions
extends JmUILegacy {
    protected Button buttonClose;
    protected DraggableListPane<CategorySlot> minimapPositionPane;
    private final MiniMapProperties miniMapProperties;
    private final MiniMap minimap;
    private final Effect effect;
    private Selectable selected;
    boolean dragging = false;
    private Selectable notSelected;
    private Map<Holder<MobEffect>, MobEffectInstance> activeEffects;
    private Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private static final Map<Holder<MobEffect>, MobEffectInstance> FAKE_EFFECT_MAP;

    public MinimapOptions(Screen returnDisplay, MiniMapProperties miniMapProperties) {
        super(Constants.getString("jm.common.minimap_options.title"), returnDisplay);
        this.miniMapProperties = miniMapProperties;
        UIManager.INSTANCE.switchMiniMapPreset(miniMapProperties.getId());
        this.minimap = UIManager.INSTANCE.getMiniMap();
        UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(true);
        this.effect = Effect.getInstance();
        this.slotMap.put(ClientCategory.MinimapPosition, miniMapProperties);
        this.activeEffects = Maps.newHashMap((Map)Minecraft.getInstance().player.getActiveEffectsMap());
        Minecraft.getInstance().player.getActiveEffectsMap().clear();
    }

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        super.setRenderBottomBar(true);
        super.init(minecraft, width, height);
        Objects.requireNonNull(this);
        this.drawOptionsPane(20, 36);
        this.buttonClose = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonClose.fitWidth(minecraft.font);
        this.buttonClose.setX(minecraft.getWindow().getGuiScaledWidth() / 2 - this.buttonClose.getWidth() / 2);
        this.buttonClose.setY(minecraft.getWindow().getGuiScaledHeight() - 25);
    }

    protected void drawOptionsPane(int x, int y) {
        Objects.requireNonNull(this);
        this.minimapPositionPane = new DraggableListPane(this.minecraft, 0, 36, x, y);
        List<CategorySlot> slotList = OptionSlotFactory.getOptionSlots(this.getToolbars(this.minimapPositionPane), this.slotMap, false, true);
        this.minimapPositionPane.setAlignTop(false);
        this.minimapPositionPane.setSlots(slotList);
        this.minimapPositionPane.updateSlots();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars(ScrollListPane<CategorySlot> pane) {
        HashMap<Category, List<SlotMetadata>> toolbars = new HashMap<Category, List<SlotMetadata>>();
        for (Category category : ClientCategory.values) {
            String name = Constants.getString("jm.config.reset");
            String tooltip = Constants.getString("jm.config.reset.tooltip");
            SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category, button -> this.refreshOptions(category, pane, true)), name, tooltip);
            toolbars.put(category, Arrays.asList(toolbarSlotMetadata));
        }
        return toolbars;
    }

    protected void refreshOptions(Category category, ScrollListPane<CategorySlot> pane, boolean reset) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : pane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (reset) {
                    slotMetadata.resetToDefaultValue();
                }
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (reset) {
                    if (properties instanceof MiniMapProperties) {
                        this.miniMapProperties.effectTranslateX.setToDefault();
                        this.miniMapProperties.effectTranslateY.setToDefault();
                        this.miniMapProperties.positionX.set(Float.valueOf(0.82f));
                        this.miniMapProperties.positionY.set(Float.valueOf(0.05f));
                    }
                    this.miniMapProperties.effectTranslateX.set((Object)0);
                }
                if (properties != null) {
                    updatedProperties.add(properties);
                }
                slotMetadata.getButton().refresh();
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.minimapPositionPane.updateSlots();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        PoseStack pose = new PoseStack();
        this.effect.renderBorder(graphics, this.effect == this.selected ? -16711936 : -65536);
        this.minimap.drawMap(graphics, true);
        this.minimap.renderBorder(graphics, this.minimap == this.selected ? -16711936 : -65536);
        if (!this.dragging) {
            super.render(graphics, x, y, partialTicks);
        }
        if (this.minimapPositionPane != null) {
            List lastTooltip = this.minimapPositionPane.lastTooltip;
            long lastTooltipTime = this.minimapPositionPane.lastTooltipTime;
            this.minimapPositionPane.lastTooltip = null;
            if (!this.dragging) {
                this.minimapPositionPane.render(graphics, x, y, partialTicks);
            }
            this.minimap.updateDisplayVars(true, true);
            this.renderTooltip(graphics, pose, x, lastTooltipTime, lastTooltip);
        }
        this.minecraft.player.getActiveEffectsMap().putAll(FAKE_EFFECT_MAP);
    }

    @Override
    protected void drawTitle(GuiGraphics graphics, PoseStack pose) {
        Objects.requireNonNull(this);
        int top = 36 >> 1;
        Font font = Minecraft.getInstance().font;
        MutableComponent title = Component.translatable((String)"jm.common.minimap_options.title").withStyle(ChatFormatting.UNDERLINE);
        MutableComponent titleText = Component.translatable((String)"jm.common.minimap_options.title_text");
        String apiVersion = "API v2.0.0-SNAPSHOT";
        pose.pushPose();
        pose.translate(0.0f, 0.0f, -100.0f);
        graphics.fill(0, 0, this.width, 36, RGB.toArgb(0, 0.5f));
        graphics.drawCenteredString(font, (Component)title, this.width / 2, top - 10, Color.CYAN.getRGB());
        graphics.drawCenteredString(font, (Component)titleText, this.width / 2, top, Color.CYAN.getRGB());
        pose.scale(0.5f, 0.5f, 0.0f);
        graphics.drawString(font, apiVersion, this.width * 2 - 10 - font.width(apiVersion), top + 10, 0xCCCCCC);
        pose.popPose();
    }

    protected void drawLogo(GuiGraphics graphics) {
    }

    private void renderTooltip(GuiGraphics graphics, PoseStack pose, int x, long lastTooltipTime, List<FormattedCharSequence> lastTooltip) {
        if (this.minimapPositionPane.lastTooltip != null && !this.minimapPositionPane.lastTooltip.equals(lastTooltip)) {
            this.minimapPositionPane.lastTooltipTime = lastTooltipTime;
            if (System.currentTimeMillis() - this.minimapPositionPane.lastTooltipTime > this.minimapPositionPane.hoverDelay) {
                Button button = this.minimapPositionPane.lastTooltipMetadata.getButton();
                graphics.setTooltipForNextFrame(this.font, this.minimapPositionPane.lastTooltip, x, button.getBottomY() + 15);
            }
        }
    }

    @Override
    protected void closeAndReturn() {
        this.cleanup();
        super.closeAndReturn();
    }

    public void onClose() {
        this.cleanup();
        super.onClose();
    }

    private void cleanup() {
        UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(false);
        this.removeTempEffects();
    }

    private void removeTempEffects() {
        this.minecraft.player.getActiveEffectsMap().clear();
        this.minecraft.player.getActiveEffectsMap().putAll(this.activeEffects);
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics, PoseStack pose) {
        if (this.getRenderables().isEmpty()) {
            this.init();
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.minimapPositionPane.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.minimap.updateDisplayVars(true, true);
        } else {
            if (this.minimap.mouseClicked(pMouseX, pMouseY, pButton)) {
                if (!Position.Custom.equals(this.miniMapProperties.position.get())) {
                    int oldX = this.minimapPositionPane.getX();
                    int oldY = this.minimapPositionPane.getY();
                    this.miniMapProperties.position.set(Position.Custom);
                    this.miniMapProperties.position.save();
                    this.drawOptionsPane(oldX, oldY);
                    ((CategorySlot)this.minimapPositionPane.getRootSlots().get(0)).setSelected(true);
                    this.minimapPositionPane.updateSlots();
                    this.minimapPositionPane.setClicked(true);
                }
                this.selected = this.minimap;
                this.notSelected = this.effect;
                return true;
            }
            if (this.effect.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.selected = this.effect;
                this.notSelected = this.minimap;
                return true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        this.minimapPositionPane.mouseScrolled(x, y, f, scroll);
        return super.mouseScrolled(x, y, f, scroll);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.minimapPositionPane.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY) && this.selected != null && this.selected.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            this.dragging = true;
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        this.minimapPositionPane.mouseReleased(mouseX, mouseY, mouseButton);
        this.minimap.mouseReleased(mouseX, mouseY, mouseButton);
        this.effect.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        if (this.selected != null) {
            this.selected.tick();
        }
    }

    static {
        ArrayList fakeEffect = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.UNLUCK), new MobEffectInstance(MobEffects.BLINDNESS), new MobEffectInstance(MobEffects.POISON), new MobEffectInstance(MobEffects.REGENERATION), new MobEffectInstance(MobEffects.RESISTANCE), new MobEffectInstance(MobEffects.WATER_BREATHING), new MobEffectInstance(MobEffects.INVISIBILITY)});
        FAKE_EFFECT_MAP = fakeEffect.stream().collect(Collectors.toMap(MobEffectInstance::getEffect, e -> e));
    }
}

