/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.awt.geom.Point2D;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ThemeCompassPoints {
    final MutableComponent textNorth = Component.translatable((String)"jm.minimap.compass.n");
    final MutableComponent textSouth = Component.translatable((String)"jm.minimap.compass.s");
    final MutableComponent textEast = Component.translatable((String)"jm.minimap.compass.e");
    final MutableComponent textWest = Component.translatable((String)"jm.minimap.compass.w");
    final Point2D pointNorth;
    final Point2D pointSouth;
    final Point2D pointWest;
    final Point2D pointEast;
    final boolean showNorth;
    final boolean showSouth;
    final boolean showEast;
    final boolean showWest;
    final float fontScale;
    final float compassLabelHeight;
    final Theme.LabelSpec compassLabel;
    final Theme.ImageSpec compassPoint;
    final ResourceLocation compassPointTex;
    final int xOffset;
    final int yOffset;
    final double shiftVert;
    final double shiftHorz;
    final int labelShiftVert;
    private double x;
    private double y;

    public ThemeCompassPoints(double x, double y, double halfWidth, double halfHeight, Theme.Minimap.MinimapSpec minimapSpec, MiniMapProperties miniMapProperties, ResourceLocation compassPointTex, float labelHeight) {
        this.x = x;
        this.y = y;
        this.pointNorth = new Point2D.Double(x + halfWidth, y);
        this.pointSouth = new Point2D.Double(x + halfWidth, y + halfHeight + halfHeight);
        this.pointWest = new Point2D.Double(x, y + halfHeight);
        this.pointEast = new Point2D.Double(x + halfWidth + halfWidth, y + halfHeight);
        this.fontScale = miniMapProperties.compassFontScale.get().floatValue();
        this.compassLabelHeight = labelHeight;
        this.compassLabel = minimapSpec.compassLabel;
        this.compassPoint = minimapSpec.compassPoint;
        this.compassPointTex = compassPointTex;
        if (this.compassPointTex != null) {
            this.shiftVert = Math.floor(minimapSpec.compassPointOffset * (double)this.fontScale);
            this.shiftHorz = Math.floor(minimapSpec.compassPointOffset * (double)this.fontScale);
            this.pointNorth.setLocation(this.pointNorth.getX(), this.pointNorth.getY() - this.shiftVert);
            this.pointSouth.setLocation(this.pointSouth.getX(), this.pointSouth.getY() + this.shiftVert);
            this.pointWest.setLocation(this.pointWest.getX() - this.shiftHorz, this.pointWest.getY());
            this.pointEast.setLocation(this.pointEast.getX() + this.shiftHorz, this.pointEast.getY());
            this.xOffset = (int)((float)this.compassPoint.width * this.fontScale / 2.0f);
            this.yOffset = (int)((float)this.compassPoint.height * this.fontScale / 2.0f);
        } else {
            this.xOffset = 0;
            this.yOffset = 0;
            this.shiftHorz = 0.0;
            this.shiftVert = 0.0;
        }
        this.labelShiftVert = 0;
        this.showNorth = minimapSpec.compassShowNorth;
        this.showSouth = minimapSpec.compassShowSouth;
        this.showEast = minimapSpec.compassShowEast;
        this.showWest = minimapSpec.compassShowWest;
    }

    public static float getCompassPointScale(float compassLabelHeight, Theme.Minimap.MinimapSpec minimapSpec) {
        return (compassLabelHeight + (float)minimapSpec.compassPointLabelPad) / ((float)minimapSpec.compassPoint.height * 1.0f);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void drawPoints(GuiGraphics graphics) {
        if (this.compassPointTex != null) {
            int color = this.compassPoint.getColor();
            float alpha = this.compassPoint.alpha;
            if (this.showNorth) {
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.compassPointTex, color, alpha, this.pointNorth.getX(), this.pointNorth.getY(), this.compassPoint.width, this.compassPoint.height, this.fontScale, 0.0, false);
            }
            if (this.showSouth) {
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.compassPointTex, color, alpha, this.pointSouth.getX(), this.pointSouth.getY(), this.compassPoint.width, this.compassPoint.height, this.fontScale, 180.0, false);
            }
            if (this.showWest) {
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.compassPointTex, color, alpha, this.pointWest.getX(), this.pointWest.getY(), this.compassPoint.width, this.compassPoint.height, this.fontScale, 90.0, false);
            }
            if (this.showEast) {
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.compassPointTex, color, alpha, this.pointEast.getX(), this.pointEast.getY(), this.compassPoint.width, this.compassPoint.height, this.fontScale, -90.0, false);
            }
        }
    }

    public void drawLabels(GuiGraphics graphics, double rotation) {
        Theme.LabelSpec labelSpec = this.compassLabel;
        int color = RGB.toArgb(labelSpec.foreground.getColor(), labelSpec.foreground.alpha);
        if (this.showNorth) {
            DrawUtil.drawLabel(graphics, (Component)this.textNorth, this.pointNorth.getX(), this.pointNorth.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, color, labelSpec.foreground.alpha, this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showSouth) {
            DrawUtil.drawLabel(graphics, (Component)this.textSouth, this.pointSouth.getX(), this.pointSouth.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, color, labelSpec.foreground.alpha, this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showWest) {
            DrawUtil.drawLabel(graphics, (Component)this.textWest, this.pointWest.getX(), this.pointWest.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, color, labelSpec.foreground.alpha, this.fontScale, labelSpec.shadow, rotation);
        }
        if (this.showEast) {
            DrawUtil.drawLabel(graphics, (Component)this.textEast, this.pointEast.getX(), this.pointEast.getY() + (double)this.labelShiftVert, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelSpec.background.getColor(), this.compassLabel.background.alpha, color, labelSpec.foreground.alpha, this.fontScale, labelSpec.shadow, rotation);
        }
    }
}

