/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ImplementedContainer
extends Container {
    public static final Logger LOGGER = LoggerFactory.getLogger(ImplementedContainer.class);

    public static ImplementedContainer of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedContainer ofSize(int size) {
        return ImplementedContainer.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    @Deprecated(forRemoval=true, since="1.22")
    public static NonNullList<ItemStack> deserializeInventory(CompoundTag tag, int minimumSize, HolderLookup.Provider provider) {
        int size = Math.max(minimumSize, tag.getIntOr("Size", minimumSize));
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        tag.getList("Items").ifPresent(itemTags -> {
            for (int i = 0; i < itemTags.size(); ++i) {
                itemTags.getCompound(i).ifPresent(itemTag -> {
                    int slot = itemTag.getIntOr("Slot", -1);
                    if (slot >= 0 && slot < items.size()) {
                        ItemStack itemStack = ItemStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(key -> LOGGER.error("Tried to load invalid item: '{}'", key)).orElse(ItemStack.EMPTY);
                        items.set(slot, (Object)itemStack);
                    }
                });
            }
        });
        return items;
    }

    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        this.slotChanged(slot);
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem(this.getItems(), (int)slot);
        this.slotChanged(slot);
        return itemStack;
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
        this.slotChanged(slot);
    }

    default public void clearContent() {
        this.getItems().clear();
        for (int i = 0; i < this.getItems().size(); ++i) {
            this.slotChanged(i);
        }
    }

    default public void setChanged() {
    }

    default public void slotChanged(int slot) {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    @Deprecated(forRemoval=true, since="1.22")
    default public CompoundTag serializeInventory(HolderLookup.Provider provider) {
        NonNullList<ItemStack> items = this.getItems();
        ListTag itemTags = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            Tag result = (Tag)ItemStack.CODEC.encode((Object)((ItemStack)items.get(i)), (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemTag).getOrThrow();
            itemTags.add((Object)result);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)itemTags);
        nbt.putInt("Size", items.size());
        return nbt;
    }

    default public void copyFrom(Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            this.setItem(i, container.getItem(i));
        }
    }
}

