/*
 * Decompiled with CFR 0.152.
 */
package com.mars.deimos.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mars.deimos.platform.Services;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class DeimosConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, Class<? extends DeimosConfig>> configClass = new HashMap<String, Class<? extends DeimosConfig>>();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{2, 128}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        for (EntryInfo e : entries) {
            if (!modid.equals(e.modid) || !entry.equals(e.field.getName())) continue;
            return e.defaultValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String modid, Class<? extends DeimosConfig> config) {
        Path configPath = Services.PLATFORM.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        List<EntryInfo> list = entries;
        synchronized (list) {
            for (Field field : config.getFields()) {
                EntryInfo info = new EntryInfo();
                if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && Services.PLATFORM.isClientEnv()) {
                    DeimosConfig.initClient(modid, field, info);
                }
                if (field.isAnnotationPresent(Comment.class)) {
                    info.centered = field.getAnnotation(Comment.class).centered();
                }
                if (!field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                if (Files.notExists(configPath, new LinkOption[0])) {
                    Files.createFile(configPath, new FileAttribute[0]);
                    DeimosConfig.write(modid);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create config file for " + modid, e);
            }
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                gson.fromJson((Reader)reader, config);
            }
            catch (Exception e) {
                DeimosConfig.write(modid);
            }
            for (EntryInfo info : entries) {
                if (!info.modid.equals(modid) || !info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    private static void initClient(String modid, Field field, EntryInfo info) {
        info.dataType = DeimosConfig.getUnderlyingType(field);
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.modid = modid;
        if (e != null) {
            if (!e.name().isEmpty()) {
                info.name = Component.translatable((String)e.name());
            }
            if (info.dataType == Integer.TYPE) {
                DeimosConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                DeimosConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                DeimosConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == ResourceLocation.class) {
                DeimosConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.translatable((String)(modid + ".deimosconfig.enum." + modid + "." + info.dataType.getSimpleName()));
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        if (field.getType() == List.class) {
            Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            try {
                return (Class)listType.getField("TYPE").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                return listType;
            }
        }
        return field.getType();
    }

    public static Tooltip getTooltip(EntryInfo info) {
        String key = info.modid + ".deimosconfig." + info.modid + ".tooltip";
        return Tooltip.create((Component)(info.error != null ? info.error : (I18n.exists((String)key) ? Component.translatable((String)key) : Component.empty())));
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).withStyle(ChatFormatting.RED);
                t.setTooltip(DeimosConfig.getTooltip(info));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == ResourceLocation.class) {
                    info.setValue(ResourceLocation.tryParse((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static DeimosConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        Path configPath = Services.PLATFORM.getConfigDirectory().resolve(modid + ".json");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (Files.notExists(configPath, new LinkOption[0])) {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            String json = gson.toJson((Object)DeimosConfig.getClass(modid));
            Files.write(configPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config for " + modid, e);
        }
    }

    public static class EntryInfo {
        Field field;
        Class<?> dataType;
        int width;
        int listIndex;
        boolean centered;
        Object defaultValue;
        Object value;
        Object function;
        String modid;
        String tempValue;
        boolean inLimits = true;
        Component name;
        Component error;
        AbstractWidget actionButton;
        Tab tab;

        public void setValue(Object value) {
            if (this.field.getType() != List.class) {
                this.value = value;
                this.tempValue = value.toString();
            } else {
                this.writeList(this.listIndex, value);
                this.tempValue = this.toTemporaryValue();
            }
        }

        public String toTemporaryValue() {
            if (this.field.getType() != List.class) {
                return this.value.toString();
            }
            try {
                return ((List)this.value).get(this.listIndex).toString();
            }
            catch (Exception ignored) {
                return "";
            }
        }

        public <T> void writeList(int index, T value) {
            List list = (List)this.value;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class DeimosSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public DeimosSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.field.getAnnotation(Entry.class);
            this.info = info;
        }

        public void updateMessage() {
            this.setMessage(Component.nullToEmpty((String)this.info.tempValue));
        }

        public void applyValue() {
            if (this.info.dataType == Integer.TYPE) {
                this.info.setValue(Double.valueOf(this.e.min() + this.value * (this.e.max() - this.e.min())).intValue());
            } else if (this.info.field.getType() == Double.TYPE) {
                this.info.setValue(Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (long)this.e.precision());
            } else if (this.info.field.getType() == Float.TYPE) {
                this.info.setValue(Float.valueOf((float)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision()));
            }
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.getInstance().font;
        public final Component text;
        public final List<AbstractWidget> buttons;
        public final EntryInfo info;
        public boolean centered = false;

        public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            if (info != null) {
                this.centered = info.centered;
            }
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.setY(y);
                b.render(context, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                int wrappedY = y;
                Iterator textIterator = textRenderer.split((FormattedText)this.text, this.buttons.size() > 1 ? this.buttons.get(1).getX() - 24 : Minecraft.getInstance().getWindow().getGuiScaledWidth() - 24).iterator();
                while (textIterator.hasNext()) {
                    context.drawString(textRenderer, (FormattedCharSequence)textIterator.next(), this.centered ? Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - textRenderer.width((FormattedText)this.text) / 2 : 12, wrappedY + 5, -1);
                    wrappedY += 9;
                }
            }
        }

        public List<? extends GuiEventListener> children() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList(this.buttons);
        }
    }

    public static class DeimosConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        public boolean renderHeaderSeparator = true;

        public DeimosConfigListWidget(Minecraft client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        public int getScrollbarPosition() {
            return this.width - 7;
        }

        protected void renderListSeparators(GuiGraphics context) {
            if (this.renderHeaderSeparator) {
                super.renderListSeparators(context);
            } else {
                context.blit(RenderPipelines.GUI_TEXTURED, this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            }
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.clearEntries();
        }

        public int getRowWidth() {
            return 10000;
        }
    }

    public static class DeimosConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final String modid;
        public final Screen parent;
        public DeimosConfigListWidget list;
        public TabManager tabManager = new TabManager(a -> {}, a -> {});
        public Map<String, Tab> tabs = new HashMap<String, Tab>();
        public Tab prevTab;
        public TabNavigationBar tabNavigation;
        public Button done;
        public double scrollProgress = 0.0;

        protected DeimosConfigScreen(Screen parent, String modid) {
            super((Component)Component.translatable((String)(modid + ".deimosconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".deimosconfig.";
            this.loadValues();
            for (EntryInfo e : entries) {
                if (!e.modid.equals(modid)) continue;
                String tabId = e.field.isAnnotationPresent(Entry.class) ? e.field.getAnnotation(Entry.class).category() : e.field.getAnnotation(Comment.class).category();
                String name = this.translationPrefix + "category." + this.translationPrefix;
                if (!I18n.exists((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    GridLayoutTab gridLayoutTab = new GridLayoutTab((Component)Component.translatable((String)name));
                    e.tab = gridLayoutTab;
                    this.tabs.put(name, (Tab)gridLayoutTab);
                    continue;
                }
                e.tab = this.tabs.get(name);
            }
            this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs((Tab[])this.tabs.values().toArray((Object[])new Tab[0])).build();
            this.tabNavigation.selectTab(0, false);
            this.tabNavigation.arrangeElements();
            this.prevTab = this.tabManager.getCurrentTab();
        }

        public static Screen getScreen(Screen parent, String modid) {
            return new DeimosConfigScreen(parent, modid);
        }

        public void tick() {
            super.tick();
            if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
                this.prevTab = this.tabManager.getCurrentTab();
                this.list.clear();
                this.fillList();
                this.list.setScrollAmount(0.0);
            }
            this.scrollProgress = this.list.scrollAmount();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateButtons();
        }

        public void updateButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget widget;
                    if (entry.buttons == null || entry.buttons.size() <= 1) continue;
                    AbstractWidget abstractWidget = entry.buttons.get(0);
                    if (abstractWidget instanceof AbstractWidget && ((widget = abstractWidget).isFocused() || widget.isHovered())) {
                        widget.setTooltip(DeimosConfig.getTooltip(entry.info));
                    }
                    if (!((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.active = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadValues() {
            Path configPath = Services.PLATFORM.getConfigDirectory().resolve(this.modid + ".json");
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                gson.fromJson((Reader)reader, configClass.get(this.modid));
            }
            catch (Exception e) {
                DeimosConfig.write(this.modid);
            }
            List<EntryInfo> list = entries;
            synchronized (list) {
                for (EntryInfo info : entries) {
                    if (!info.modid.equals(this.modid) || !info.field.isAnnotationPresent(Entry.class)) continue;
                    try {
                        info.value = info.field.get(null);
                        info.tempValue = info.toTemporaryValue();
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.tabNavigation.keyPressed(keyCode)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void onClose() {
            this.loadValues();
            this.cleanup();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }

        private void cleanup() {
            entries.forEach(info -> {
                info.error = null;
                info.value = null;
                info.tempValue = null;
                info.actionButton = null;
                info.listIndex = 0;
                info.tab = null;
                info.inLimits = true;
            });
        }

        public void init() {
            super.init();
            this.tabNavigation.setWidth(this.width);
            this.tabNavigation.arrangeElements();
            if (this.tabs.size() > 1) {
                this.addRenderableWidget((GuiEventListener)this.tabNavigation);
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
            this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
                for (EntryInfo info : entries) {
                    if (!info.modid.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                DeimosConfig.write(this.modid);
                this.cleanup();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
            this.list = new DeimosConfigListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
            this.addWidget((GuiEventListener)this.list);
            this.fillList();
            if (this.tabs.size() > 1) {
                this.list.renderHeaderSeparator = false;
            }
        }

        public void fillList() {
            for (EntryInfo info : entries) {
                if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.getCurrentTab())) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> Component.translatable((String)(this.translationPrefix + info.field.getName())));
                    Button resetButton = Button.builder((Component)Component.literal((String)"R").withStyle(ChatFormatting.RED), button -> {
                        info.value = info.defaultValue;
                        info.listIndex = 0;
                        info.tempValue = info.toTemporaryValue();
                        this.list.clear();
                        this.fillList();
                    }).size(20, 20).build();
                    resetButton.setPosition(this.width - 205 + 150 + 25, 0);
                    if (info.function != null) {
                        Object editBox;
                        Entry e = info.field.getAnnotation(Entry.class);
                        if (info.function instanceof Map.Entry) {
                            Map.Entry values = (Map.Entry)info.function;
                            if (info.dataType.isEnum()) {
                                values.setValue(value -> Component.translatable((String)(this.translationPrefix + "enum." + this.translationPrefix + "." + info.field.getType().getSimpleName())));
                            }
                            editBox = Button.builder((Component)((Component)((Function)values.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)values.getKey())).bounds(this.width - 185, 0, 150, 20).tooltip(DeimosConfig.getTooltip(info)).build();
                        } else {
                            editBox = e.isSlider() ? new DeimosSliderWidget(this.width - 185, 0, 150, 20, Component.nullToEmpty((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.font, this.width - 185, 0, 150, 20, (Component)Component.empty());
                        }
                        if (editBox instanceof EditBox) {
                            EditBox textField = editBox;
                            textField.setMaxLength(info.width);
                            textField.setValue(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                            textField.setFilter(processor);
                        }
                        editBox.setTooltip(DeimosConfig.getTooltip(info));
                        Button cycleButton = null;
                        if (info.field.getType() == List.class) {
                            cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.listIndex)).withStyle(ChatFormatting.GOLD), button -> {
                                List values = (List)info.value;
                                values.remove("");
                                ++info.listIndex;
                                if (info.listIndex > values.size()) {
                                    info.listIndex = 0;
                                }
                                info.tempValue = info.toTemporaryValue();
                                if (info.listIndex == values.size()) {
                                    info.tempValue = "";
                                }
                                this.list.clear();
                                this.fillList();
                            }).bounds(this.width - 185, 0, 20, 20).build();
                        }
                        if (e.isColor()) {
                            Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> {}).bounds(this.width - 185, 0, 20, 20).build();
                            try {
                                colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.actionButton = colorButton;
                        } else if (e.selectionMode() > -1) {
                            SpriteIconButton spriteIconButton = SpriteIconButton.builder((Component)Component.empty(), button -> {}, (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"deimoslib", (String)"icon/explorer"), 12, 12).size(20, 20).build();
                            spriteIconButton.setPosition(this.width - 185, 0);
                            info.actionButton = spriteIconButton;
                        }
                        ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{editBox, resetButton});
                        if (info.actionButton != null) {
                            if (Minecraft.ON_OSX) {
                                info.actionButton.active = false;
                            }
                            editBox.setWidth(editBox.getWidth() - 22);
                            editBox.setX(editBox.getX() + 22);
                            widgets.add(info.actionButton);
                        }
                        if (cycleButton != null) {
                            if (info.actionButton != null) {
                                info.actionButton.setX(info.actionButton.getX() + 22);
                            }
                            editBox.setWidth(editBox.getWidth() - 22);
                            editBox.setX(editBox.getX() + 22);
                            widgets.add(cycleButton);
                        }
                        this.list.addButton(widgets, name, info);
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.setScrollAmount(this.scrollProgress);
                this.updateButtons();
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.render(context, mouseX, mouseY, delta);
            this.list.render(context, mouseX, mouseY, delta);
            if (this.tabs.size() < 2) {
                context.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
            }
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget object;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((object = entry.buttons.getFirst()) instanceof AbstractWidget)) continue;
                    AbstractWidget widget = object;
                    int idMode = entry.info.field.getAnnotation(Entry.class).idMode();
                    if (idMode == -1) continue;
                    context.renderItem(idMode == 0 ? ((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)entry.info.tempValue))).getDefaultInstance() : ((Block)BuiltInRegistries.BLOCK.getValue(ResourceLocation.tryParse((String)entry.info.tempValue))).asItem().getDefaultInstance(), widget.getX() + widget.getWidth() - 18, widget.getY() + 2);
                }
            }
        }
    }
}

