/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.ChatFormatting;

public class InventoryConfigScreen
extends ConfigScreen {
    public InventoryConfigScreen(boolean inGame) {
        super(0, inGame);
    }

    @Override
    protected void init() {
        super.init();
        String toggle = (Boolean)InventoryHUD.getClientConfig().byDefault.get() != false ? String.valueOf(ChatFormatting.DARK_GREEN) + "ON" : String.valueOf(ChatFormatting.DARK_RED) + "OFF";
        this.addButton(0, toggle, this::ToggleSwitch);
        this.addButton(1, ((Boolean)InventoryHUD.getClientConfig().invVert.get()).toString(), this::VerticalModeSwitch);
        this.addButton(2, ((Boolean)InventoryHUD.getClientConfig().invMini.get()).toString(), this::MiniModeSwitch);
        this.addNumericField(3, 0, 100, (Integer)InventoryHUD.getClientConfig().invAlpha.get(), this::AlphaChanged, 5);
        this.addButton(4, ((Boolean)InventoryHUD.getClientConfig().animatedInv.get()).toString(), this::AnimatedChanged);
        this.addButton(5, ((Boolean)InventoryHUD.getClientConfig().hideBackground.get()).toString(), this::HideBGChanged);
        this.addButton(6, ((Boolean)InventoryHUD.getClientConfig().invWithDebug.get()).toString(), this::WithDebug);
        this.addButton(8, ((Boolean)InventoryHUD.getClientConfig().keepNotifying.get()).toString(), this::NotifyChanged);
        this.addText(8, Translation.KEEP_NOTIFY.getString(), Translation.KEEP_NOTIFY_TT);
        this.addText(6, Translation.WITH_DEBUG.getString(), Translation.INV_DEBUG_TT);
        this.addText(5, Translation.INV_HIDEBG.getString(), Translation.INV_HIDEBG_TT);
        this.addText(4, Translation.INV_ANIMATED.getString(), Translation.INV_ANIMATED_TT);
        this.addText(3, Translation.INV_ALPHA.getString(), Translation.INV_ALPHA_TT);
        this.addText(2, Translation.INV_MINI.getString(), Translation.INV_MINI_TT);
        this.addText(1, Translation.INV_VERT.getString(), Translation.INV_VERT_TT);
        this.addText(0, Translation.INV_TOGGLE.getString(), Translation.INV_TOGGLE_TT);
    }

    private void WithDebug(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().invWithDebug.get() == false;
        InventoryGui.withDebug = bd;
        InventoryHUD.getClientConfig().invWithDebug.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void NotifyChanged(ButtonWidget btn) {
        Boolean nt = (Boolean)InventoryHUD.getClientConfig().keepNotifying.get() == false;
        InventoryHUD.getClientConfig().keepNotifying.set((Object)nt);
        btn.setMessage(nt.toString());
        InventoryHUD.saveConfig();
    }

    private void AnimatedChanged(ButtonWidget btn) {
        Boolean mm = (Boolean)InventoryHUD.getClientConfig().animatedInv.get() == false;
        InventoryGui.animated = mm;
        InventoryHUD.getClientConfig().animatedInv.set((Object)mm);
        btn.setMessage(mm.toString());
        InventoryHUD.saveConfig();
    }

    private void HideBGChanged(ButtonWidget btn) {
        Boolean mm = (Boolean)InventoryHUD.getClientConfig().hideBackground.get() == false;
        InventoryGui.hideBackground = mm;
        InventoryHUD.getClientConfig().hideBackground.set((Object)mm);
        btn.setMessage(mm.toString());
        InventoryHUD.saveConfig();
    }

    private void AlphaChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.invAlpha = (float)a / 100.0f;
        InventoryHUD.getClientConfig().invAlpha.set((Object)a);
        InventoryHUD.saveConfig();
    }

    private void MiniModeSwitch(ButtonWidget btn) {
        Boolean mm = (Boolean)InventoryHUD.getClientConfig().invMini.get() == false;
        InventoryGui.invMini = mm;
        InventoryHUD.getClientConfig().invMini.set((Object)mm);
        btn.setMessage(mm.toString());
        InventoryHUD.saveConfig();
    }

    private void VerticalModeSwitch(ButtonWidget btn) {
        Boolean vm = (Boolean)InventoryHUD.getClientConfig().invVert.get() == false;
        InventoryGui.invVert = vm;
        InventoryHUD.getClientConfig().invVert.set((Object)vm);
        btn.setMessage(vm.toString());
        InventoryHUD.saveConfig();
    }

    private void ToggleSwitch(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().byDefault.get() == false;
        InventoryHUD.isActive = bd;
        InventoryHUD.getClientConfig().byDefault.set((Object)bd);
        String toggle = bd != false ? String.valueOf(ChatFormatting.DARK_GREEN) + "ON" : String.valueOf(ChatFormatting.DARK_RED) + "OFF";
        btn.setMessage(toggle);
        InventoryHUD.saveConfig();
    }
}

