/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.compression;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import info.journeymap.shaded.io.javalin.compression.Brotli;
import info.journeymap.shaded.io.javalin.compression.Brotli4jCompressor;
import info.journeymap.shaded.io.javalin.compression.Compressor;
import info.journeymap.shaded.io.javalin.compression.Gzip;
import info.journeymap.shaded.io.javalin.compression.GzipCompressor;
import info.journeymap.shaded.io.javalin.util.CoreDependency;
import info.journeymap.shaded.io.javalin.util.DependencyUtil;
import info.journeymap.shaded.io.javalin.util.JavalinLogger;
import info.journeymap.shaded.io.javalin.util.Util;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.JvmField;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.DefaultConstructorMarker;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.SourceDebugExtension;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\r\u00a8\u0006\u001c"}, d2={"Linfo/journeymap/shaded/io/javalin/compression/CompressionStrategy;", "", "brotli", "Linfo/journeymap/shaded/io/javalin/compression/Brotli;", "gzip", "Linfo/journeymap/shaded/io/javalin/compression/Gzip;", "(Lio/javalin/compression/Brotli;Lio/javalin/compression/Gzip;)V", "allowedMimeTypes", "", "", "getAllowedMimeTypes", "()Ljava/util/List;", "setAllowedMimeTypes", "(Ljava/util/List;)V", "compressors", "Linfo/journeymap/shaded/io/javalin/compression/Compressor;", "getCompressors", "defaultMinSizeForCompression", "", "getDefaultMinSizeForCompression", "()I", "setDefaultMinSizeForCompression", "(I)V", "excludedMimeTypes", "getExcludedMimeTypes", "setExcludedMimeTypes", "tryLoadBrotli", "Companion", "javalin"})
@SourceDebugExtension(value={"SMAP\nCompressionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionStrategy.kt\nio/javalin/compression/CompressionStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class CompressionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Compressor> compressors;
    private int defaultMinSizeForCompression;
    @NotNull
    private List<String> allowedMimeTypes;
    @NotNull
    private List<String> excludedMimeTypes;
    @JvmField
    @NotNull
    public static final CompressionStrategy NONE = new CompressionStrategy(null, null, 3, null);
    @JvmField
    @NotNull
    public static final CompressionStrategy GZIP = new CompressionStrategy(null, new Gzip(0, 1, null));

    public CompressionStrategy(@Nullable Brotli brotli, @Nullable Gzip gzip) {
        List comp = new ArrayList();
        if (brotli != null) {
            Compressor compressor = this.tryLoadBrotli(brotli);
            if (compressor != null) {
                Compressor it = compressor;
                boolean bl = false;
                comp.add(it);
            }
        }
        if (gzip != null) {
            comp.add(new GzipCompressor(gzip.getLevel()));
        }
        this.compressors = CollectionsKt.toList(comp);
        this.defaultMinSizeForCompression = 1500;
        this.allowedMimeTypes = CollectionsKt.listOf("image/svg+xml");
        String[] stringArray = new String[]{"image/", "audio/", "video/", "application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed"};
        this.excludedMimeTypes = CollectionsKt.listOf(stringArray);
    }

    public /* synthetic */ CompressionStrategy(Brotli brotli, Gzip gzip, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            brotli = null;
        }
        if ((n & 2) != 0) {
            gzip = null;
        }
        this(brotli, gzip);
    }

    @NotNull
    public final List<Compressor> getCompressors() {
        return this.compressors;
    }

    public final int getDefaultMinSizeForCompression() {
        return this.defaultMinSizeForCompression;
    }

    public final void setDefaultMinSizeForCompression(int n) {
        this.defaultMinSizeForCompression = n;
    }

    @NotNull
    public final List<String> getAllowedMimeTypes() {
        return this.allowedMimeTypes;
    }

    public final void setAllowedMimeTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.allowedMimeTypes = list;
    }

    @NotNull
    public final List<String> getExcludedMimeTypes() {
        return this.excludedMimeTypes;
    }

    public final void setExcludedMimeTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.excludedMimeTypes = list;
    }

    private final Compressor tryLoadBrotli(Brotli brotli) {
        if (!Companion.brotli4jPresent()) {
            throw new IllegalStateException(DependencyUtil.INSTANCE.missingDependencyMessage(CoreDependency.BROTLI4J));
        }
        if (Brotli4jLoader.isAvailable()) {
            return new Brotli4jCompressor(brotli.getLevel());
        }
        JavalinLogger.warn$default("\nFailed to enable Brotli compression, because the brotli4j native library couldn't be loaded.\nbrotli4j is currently only supported on Windows, Linux and Mac OSX.\nIf you are running Javalin on a supported system, but are still getting this error,\ntry re-importing your Maven and/or Gradle dependencies. If that doesn't resolve it,\nplease create an issue at https://github.com/javalin/javalin/\n---------------------------------------------------------------\nIf you still want compression, please ensure GZIP is enabled!\n---------------------------------------------------------------", null, 2, null);
        return null;
    }

    public CompressionStrategy() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Linfo/journeymap/shaded/io/javalin/compression/CompressionStrategy$Companion;", "", "()V", "GZIP", "Linfo/journeymap/shaded/io/javalin/compression/CompressionStrategy;", "NONE", "brotli4jAvailable", "", "brotli4jPresent", "brotliImplAvailable", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean brotli4jPresent() {
            return Util.INSTANCE.classExists(CoreDependency.BROTLI4J.getTestClass());
        }

        public final boolean brotli4jAvailable() {
            boolean bl;
            try {
                bl = Brotli4jLoader.isAvailable();
            }
            catch (Throwable t) {
                bl = false;
            }
            return bl;
        }

        public final boolean brotliImplAvailable() {
            return this.brotli4jPresent() && this.brotli4jAvailable();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

