/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.jetty;

import info.journeymap.shaded.io.javalin.config.JavalinConfig;
import info.journeymap.shaded.io.javalin.http.HandlerType;
import info.journeymap.shaded.io.javalin.http.servlet.JavalinServlet;
import info.journeymap.shaded.io.javalin.http.servlet.JavalinServletContext;
import info.journeymap.shaded.io.javalin.http.servlet.JavalinServletContextConfig;
import info.journeymap.shaded.io.javalin.http.servlet.Task;
import info.journeymap.shaded.io.javalin.jetty.JavalinJettyServlet;
import info.journeymap.shaded.io.javalin.router.ParsedEndpoint;
import info.journeymap.shaded.io.javalin.util.ConcurrencyUtilKt;
import info.journeymap.shaded.io.javalin.websocket.WsConnection;
import info.journeymap.shaded.io.javalin.websocket.WsHandlerEntry;
import info.journeymap.shaded.jakarta.servlet.ServletRequest;
import info.journeymap.shaded.jakarta.servlet.ServletResponse;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletRequest;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.kotlin.kotlin.Lazy;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.Unit;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.functions.Function0;
import info.journeymap.shaded.kotlin.kotlin.jvm.functions.Function1;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.SourceDebugExtension;
import info.journeymap.shaded.kotlin.kotlin.sequences.Sequence;
import info.journeymap.shaded.kotlin.kotlin.sequences.SequencesKt;
import info.journeymap.shaded.kotlin.kotlin.text.StringsKt;
import info.journeymap.shaded.org.eclipse.jetty.server.session.Session;
import info.journeymap.shaded.org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import info.journeymap.shaded.org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import info.journeymap.shaded.org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import info.journeymap.shaded.org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Linfo/journeymap/shaded/io/javalin/jetty/JavalinJettyServlet;", "Linfo/journeymap/shaded/org/eclipse/jetty/websocket/server/JettyWebSocketServlet;", "cfg", "Linfo/journeymap/shaded/io/javalin/config/JavalinConfig;", "(Lio/javalin/config/JavalinConfig;)V", "getCfg", "()Lio/javalin/config/JavalinConfig;", "httpServlet", "Linfo/journeymap/shaded/io/javalin/http/servlet/JavalinServlet;", "servletContextConfig", "Linfo/journeymap/shaded/io/javalin/http/servlet/JavalinServletContextConfig;", "getServletContextConfig", "()Lio/javalin/http/servlet/JavalinServletContextConfig;", "servletContextConfig$delegate", "Linfo/journeymap/shaded/kotlin/kotlin/Lazy;", "configure", "", "factory", "Linfo/journeymap/shaded/org/eclipse/jetty/websocket/server/JettyWebSocketServletFactory;", "service", "req", "Linfo/journeymap/shaded/jakarta/servlet/http/HttpServletRequest;", "res", "Linfo/journeymap/shaded/jakarta/servlet/http/HttpServletResponse;", "setWsProtocolHeader", "javalin"})
@SourceDebugExtension(value={"SMAP\nJavalinJettyServlet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavalinJettyServlet.kt\nio/javalin/jetty/JavalinJettyServlet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1855#2,2:94\n1549#2:96\n1620#2,3:97\n1#3:100\n759#4,2:101\n775#4,4:103\n*S KotlinDebug\n*F\n+ 1 JavalinJettyServlet.kt\nio/javalin/jetty/JavalinJettyServlet\n*L\n40#1:94,2\n88#1:96\n88#1:97,3\n45#1:101,2\n45#1:103,4\n*E\n"})
public final class JavalinJettyServlet
extends JettyWebSocketServlet {
    @NotNull
    private final JavalinConfig cfg;
    @NotNull
    private final JavalinServlet httpServlet;
    @NotNull
    private final Lazy servletContextConfig$delegate;

    public JavalinJettyServlet(@NotNull JavalinConfig cfg) {
        Intrinsics.checkNotNullParameter(cfg, "cfg");
        this.cfg = cfg;
        this.httpServlet = new JavalinServlet(this.cfg);
        this.servletContextConfig$delegate = ConcurrencyUtilKt.javalinLazy$default(null, new Function0<JavalinServletContextConfig>(this){
            final /* synthetic */ JavalinJettyServlet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JavalinServletContextConfig invoke() {
                return JavalinServletContextConfig.Companion.of(this.this$0.getCfg());
            }
        }, 1, null);
    }

    @NotNull
    public final JavalinConfig getCfg() {
        return this.cfg;
    }

    private final JavalinServletContextConfig getServletContextConfig() {
        Lazy lazy = this.servletContextConfig$delegate;
        return (JavalinServletContextConfig)lazy.getValue();
    }

    @Override
    protected void configure(@NotNull JettyWebSocketServletFactory factory) {
        Intrinsics.checkNotNullParameter(factory, "factory");
        Iterable $this$forEach$iv = this.cfg.pvt.jetty.wsFactoryConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.accept(factory);
        }
        factory.setCreator((arg_0, arg_1) -> JavalinJettyServlet.configure$lambda$2(this, arg_0, arg_1));
    }

    @Override
    protected void service(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter(req, "req");
        Intrinsics.checkNotNullParameter(res, "res");
        if (req.getHeader("Sec-WebSocket-Key") == null) {
            this.httpServlet.service((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String string = req.getRequestURI();
        Intrinsics.checkNotNullExpressionValue(string, "getRequestURI(...)");
        String string2 = req.getContextPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getContextPath(...)");
        String requestUri = StringsKt.removePrefix(string, (CharSequence)string2);
        WsHandlerEntry wsHandlerEntry = this.cfg.pvt.wsRouter.getWsPathMatcher().findEndpointHandlerEntry(requestUri);
        if (wsHandlerEntry == null) {
            res.sendError(404, "WebSocket handler not found");
            return;
        }
        WsHandlerEntry entry = wsHandlerEntry;
        JavalinServletContext upgradeContext = new JavalinServletContext(this.getServletContextConfig(), null, false, null, req, res, null, null, null, entry.getPath(), entry.extractPathParams(requestUri), null, null, null, 0, 31182, null);
        upgradeContext.setRouteRoles$javalin(entry.getRoles());
        req.setAttribute("javalin-ws-upgrade-context", upgradeContext);
        this.setWsProtocolHeader(req, res);
        this.cfg.pvt.internalRouter.findHttpHandlerEntries(HandlerType.WEBSOCKET_BEFORE_UPGRADE, requestUri).forEach(arg_0 -> JavalinJettyServlet.service$lambda$3(new Function1<ParsedEndpoint, Unit>(upgradeContext, requestUri){
            final /* synthetic */ JavalinServletContext $upgradeContext;
            final /* synthetic */ String $requestUri;
            {
                this.$upgradeContext = $upgradeContext;
                this.$requestUri = $requestUri;
                super(1);
            }

            public final void invoke(ParsedEndpoint handler) {
                this.$upgradeContext.getTasks().offer(new Task(false, () -> service.1.invoke$lambda$0(handler, this.$upgradeContext, this.$requestUri), 1, null));
            }

            private static final Unit invoke$lambda$0(ParsedEndpoint $handler, JavalinServletContext $upgradeContext, String $requestUri) {
                Intrinsics.checkNotNullParameter($upgradeContext, "$upgradeContext");
                Intrinsics.checkNotNullParameter($requestUri, "$requestUri");
                $handler.handle($upgradeContext, $requestUri);
                return Unit.INSTANCE;
            }
        }, arg_0));
        upgradeContext.getTasks().offer(new Task(false, () -> JavalinJettyServlet.service$lambda$4(this, req, res), 1, null));
        this.cfg.pvt.internalRouter.findHttpHandlerEntries(HandlerType.WEBSOCKET_AFTER_UPGRADE, requestUri).forEach(arg_0 -> JavalinJettyServlet.service$lambda$5(new Function1<ParsedEndpoint, Unit>(upgradeContext, requestUri){
            final /* synthetic */ JavalinServletContext $upgradeContext;
            final /* synthetic */ String $requestUri;
            {
                this.$upgradeContext = $upgradeContext;
                this.$requestUri = $requestUri;
                super(1);
            }

            public final void invoke(ParsedEndpoint handler) {
                this.$upgradeContext.getTasks().offer(new Task(false, () -> service.3.invoke$lambda$0(handler, this.$upgradeContext, this.$requestUri), 1, null));
            }

            private static final Unit invoke$lambda$0(ParsedEndpoint $handler, JavalinServletContext $upgradeContext, String $requestUri) {
                Intrinsics.checkNotNullParameter($upgradeContext, "$upgradeContext");
                Intrinsics.checkNotNullParameter($requestUri, "$requestUri");
                $handler.handle($upgradeContext, $requestUri);
                return Unit.INSTANCE;
            }
        }, arg_0));
        while (!((Collection)upgradeContext.getTasks()).isEmpty()) {
            try {
                Task task = upgradeContext.getTasks().poll();
                task.getHandler().handle();
            }
            catch (Exception e) {
                this.cfg.pvt.internalRouter.handleHttpException(upgradeContext, e);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setWsProtocolHeader(HttpServletRequest req, HttpServletResponse res) {
        Object v2;
        block4: {
            void $this$mapTo$iv$iv;
            String string = req.getHeader("Sec-WebSocket-Protocol");
            if (string == null) {
                return;
            }
            String wsProtocolHeader = string;
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)wsProtocolHeader, cArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                String it = (String)e;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank(it);
                if (!bl2) continue;
                v2 = e;
                break block4;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return;
        }
        String firstProtocol = string;
        res.setHeader("Sec-WebSocket-Protocol", firstProtocol);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object configure$lambda$2(JavalinJettyServlet this$0, JettyServerUpgradeRequest req, JettyServerUpgradeResponse jettyServerUpgradeResponse) {
        Map map;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Object object = req.getHttpServletRequest().getAttribute("javalin-ws-upgrade-context");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.javalin.http.servlet.JavalinServletContext");
        JavalinServletContext preUpgradeContext = (JavalinServletContext)object;
        HttpServletRequest httpServletRequest = req.getHttpServletRequest();
        HttpServletRequest httpServletRequest2 = req.getHttpServletRequest();
        Intrinsics.checkNotNullExpressionValue(httpServletRequest2, "getHttpServletRequest(...)");
        httpServletRequest.setAttribute("javalin-ws-upgrade-context", preUpgradeContext.changeBaseRequest(httpServletRequest2));
        Object object2 = req.getSession();
        Session session = object2 instanceof Session ? (Session)object2 : null;
        HttpServletRequest httpServletRequest3 = req.getHttpServletRequest();
        String string = "javalin-ws-upgrade-http-session";
        Object object3 = session;
        if (object3 != null && (object3 = ((Session)object3).getAttributeNames()) != null && (object3 = SequencesKt.asSequence(CollectionsKt.iterator(object3))) != null) {
            Map map2;
            void $this$associateWith$iv;
            Sequence sequence = object3;
            String string2 = string;
            HttpServletRequest httpServletRequest4 = httpServletRequest3;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string3 = (String)element$iv$iv;
                Object t = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                Object object4 = session.getAttribute((String)it);
                map2.put(t, object4);
            }
            map2 = result$iv;
            httpServletRequest3 = httpServletRequest4;
            string = string2;
            map = map2;
        } else {
            map = null;
        }
        httpServletRequest3.setAttribute(string, map);
        return new WsConnection(this$0.cfg.pvt.wsRouter.getWsPathMatcher(), this$0.cfg.pvt.wsRouter.getWsExceptionMapper(), this$0.cfg.pvt.wsLogger);
    }

    private static final void service$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit service$lambda$4(JavalinJettyServlet this$0, HttpServletRequest $req, HttpServletResponse $res) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($req, "$req");
        Intrinsics.checkNotNullParameter($res, "$res");
        super.service($req, $res);
        return Unit.INSTANCE;
    }

    private static final void service$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

