/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.router.exception;

import info.journeymap.shaded.io.javalin.config.RouterConfig;
import info.journeymap.shaded.io.javalin.http.Context;
import info.journeymap.shaded.io.javalin.http.ExceptionHandler;
import info.journeymap.shaded.io.javalin.http.HttpResponseException;
import info.journeymap.shaded.io.javalin.http.HttpStatus;
import info.journeymap.shaded.io.javalin.http.InternalServerErrorResponse;
import info.journeymap.shaded.io.javalin.router.exception.ExceptionMapperKt;
import info.journeymap.shaded.io.javalin.router.exception.HttpResponseExceptionMapper;
import info.journeymap.shaded.io.javalin.util.JavalinLogger;
import info.journeymap.shaded.io.javalin.util.Util;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.Unit;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0019J\u001c\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u001b\u001a\u00060\bj\u0002`\tH\u0002R5\u0010\u0005\u001a&\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0\u0007\u0012\u0010\u0012\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Linfo/journeymap/shaded/io/javalin/router/exception/ExceptionMapper;", "", "routerConfig", "Linfo/journeymap/shaded/io/javalin/config/RouterConfig;", "(Lio/javalin/config/RouterConfig;)V", "handlers", "", "Ljava/lang/Class;", "Ljava/lang/Exception;", "Linfo/journeymap/shaded/kotlin/kotlin/Exception;", "Linfo/journeymap/shaded/io/javalin/http/ExceptionHandler;", "getHandlers", "()Ljava/util/Map;", "handle", "", "ctx", "Linfo/journeymap/shaded/io/javalin/http/Context;", "t", "", "handle$javalin", "handleUnexpectedThrowable", "", "res", "Linfo/journeymap/shaded/jakarta/servlet/http/HttpServletResponse;", "throwable", "handleUnexpectedThrowable$javalin", "uncaughtException", "exception", "javalin"})
public final class ExceptionMapper {
    @NotNull
    private final RouterConfig routerConfig;
    @NotNull
    private final Map<Class<? extends Exception>, ExceptionHandler<Exception>> handlers;

    public ExceptionMapper(@NotNull RouterConfig routerConfig) {
        Intrinsics.checkNotNullParameter(routerConfig, "routerConfig");
        this.routerConfig = routerConfig;
        this.handlers = new LinkedHashMap();
        this.handlers.put(HttpResponseException.class, ExceptionMapper::_init_$lambda$0);
    }

    @NotNull
    public final Map<Class<? extends Exception>, ExceptionHandler<Exception>> getHandlers() {
        return this.handlers;
    }

    public final void handle$javalin(@NotNull Context ctx, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(t, "t");
        if (t instanceof CompletionException && t.getCause() instanceof Exception) {
            Throwable throwable = t.getCause();
            Intrinsics.checkNotNull(throwable, "null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
            this.handle$javalin(ctx, (Exception)throwable);
            return;
        }
        if (ExceptionMapperKt.access$isSomewhatExpectedException(t)) {
            ExceptionMapperKt.access$logDebugAndSetError(t, ctx.res());
        } else if (t instanceof Exception) {
            Unit unit;
            ExceptionHandler<Exception> exceptionHandler = Util.INSTANCE.findByClass(this.handlers, t.getClass());
            if (exceptionHandler != null) {
                exceptionHandler.handle((Exception)t, ctx);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.uncaughtException(ctx, (Exception)t);
            }
        } else {
            this.handleUnexpectedThrowable$javalin(ctx.res(), t);
        }
    }

    private final void uncaughtException(Context ctx, Exception exception) {
        JavalinLogger.warn("Uncaught exception", exception);
        HttpResponseExceptionMapper.INSTANCE.handle(new InternalServerErrorResponse(null, null, 3, null), ctx);
    }

    @Nullable
    public final Void handleUnexpectedThrowable$javalin(@NotNull HttpServletResponse res, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(res, "res");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.getCode());
        if (throwable instanceof Error) {
            this.routerConfig.getJavaLangErrorHandler$javalin().handle(res, (Error)throwable);
        } else if (ExceptionMapperKt.access$isSomewhatExpectedException(throwable)) {
            ExceptionMapperKt.access$logDebugAndSetError(throwable, res);
        } else {
            JavalinLogger.error("Exception occurred while servicing http-request", throwable);
        }
        return null;
    }

    private static final void _init_$lambda$0(Exception e, Context ctx) {
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        HttpResponseExceptionMapper.INSTANCE.handle((HttpResponseException)e, ctx);
    }
}

