/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.http;

import info.journeymap.shaded.org.eclipse.jetty.util.BufferUtil;
import info.journeymap.shaded.org.eclipse.jetty.util.Index;
import java.nio.ByteBuffer;

public enum HttpScheme {
    HTTP("http", 80),
    HTTPS("https", 443),
    WS("ws", 80),
    WSS("wss", 443);

    public static final Index<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private final int _defaultPort;

    private HttpScheme(String s, int port) {
        this._string = s;
        this._buffer = BufferUtil.toBuffer(s);
        this._defaultPort = port;
    }

    public ByteBuffer asByteBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public boolean is(String s) {
        return this._string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this._string;
    }

    public int getDefaultPort() {
        return this._defaultPort;
    }

    public int normalizePort(int port) {
        return port == this._defaultPort ? 0 : port;
    }

    public String toString() {
        return this._string;
    }

    public static int getDefaultPort(String scheme2) {
        HttpScheme httpScheme = scheme2 == null ? null : CACHE.get(scheme2);
        return httpScheme == null ? HTTP.getDefaultPort() : httpScheme.getDefaultPort();
    }

    public static int normalizePort(String scheme2, int port) {
        HttpScheme httpScheme = scheme2 == null ? null : CACHE.get(scheme2);
        return httpScheme == null ? port : httpScheme.normalizePort(port);
    }

    static {
        CACHE = new Index.Builder().caseSensitive(false).withAll(HttpScheme.values(), HttpScheme::asString).build();
    }
}

