/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.websocket.core.internal.messages;

import info.journeymap.shaded.org.eclipse.jetty.io.ByteBufferCallbackAccumulator;
import info.journeymap.shaded.org.eclipse.jetty.util.BufferUtil;
import info.journeymap.shaded.org.eclipse.jetty.util.Callback;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.CoreSession;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.Frame;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.internal.messages.AbstractMessageSink;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

public class ByteArrayMessageSink
extends AbstractMessageSink {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private ByteBufferCallbackAccumulator out;

    public ByteArrayMessageSink(CoreSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        if (methodHandle.type().changeReturnType(Void.TYPE) != onMessageType.changeReturnType(Void.TYPE)) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            long size = (this.out == null ? 0 : this.out.getLength()) + frame.getPayloadLength();
            long maxBinaryMessageSize = this.session.getMaxBinaryMessageSize();
            if (maxBinaryMessageSize > 0L && size > maxBinaryMessageSize) {
                throw new MessageTooLargeException(String.format("Binary message too large: (actual) %,d > (configured max binary message size) %,d", size, maxBinaryMessageSize));
            }
            if (frame.isFin() && (this.out == null || this.out.getLength() == 0)) {
                if (frame.hasPayload()) {
                    byte[] buf = BufferUtil.toArray(frame.getPayload());
                    this.methodHandle.invoke(buf, 0, buf.length);
                } else {
                    this.methodHandle.invoke(EMPTY_BUFFER, 0, 0);
                }
                callback.succeeded();
                this.session.demand(1L);
                return;
            }
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                if (this.out == null) {
                    this.out = new ByteBufferCallbackAccumulator();
                }
                this.out.addEntry(payload, callback);
                callback = Callback.NOOP;
            }
            if (frame.isFin()) {
                byte[] buf = this.out.takeByteArray();
                this.methodHandle.invoke(buf, 0, buf.length);
            }
            callback.succeeded();
            this.session.demand(1L);
        }
        catch (Throwable t) {
            this.fail(t);
            callback.failed(t);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.out != null) {
            this.out.fail(failure);
        }
    }
}

