/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.internal;

import info.journeymap.shaded.jakarta.servlet.ServletContext;
import info.journeymap.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.Configuration;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.FrameHandler;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketNegotiation;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class CreatorNegotiator
extends WebSocketNegotiator.AbstractNegotiator {
    private final WebSocketCreator creator;
    private final FrameHandlerFactory factory;

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory) {
        this(creator, factory, null);
    }

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory, Configuration.Customizer customizer) {
        super(customizer);
        this.creator = creator;
        this.factory = factory;
    }

    public WebSocketCreator getWebSocketCreator() {
        return this.creator;
    }

    @Override
    public FrameHandler negotiate(WebSocketNegotiation negotiation) throws IOException {
        ServletContext servletContext = negotiation.getRequest().getServletContext();
        if (servletContext == null) {
            throw new IllegalStateException("null servletContext from request");
        }
        ServerUpgradeRequest upgradeRequest = new ServerUpgradeRequest(negotiation);
        ServerUpgradeResponse upgradeResponse = new ServerUpgradeResponse(negotiation);
        AtomicReference result = new AtomicReference();
        ((ContextHandler.Context)servletContext).getContextHandler().handle(() -> result.set(this.creator.createWebSocket(upgradeRequest, upgradeResponse)));
        Object websocketPojo = result.get();
        if (upgradeResponse.isCommitted()) {
            return null;
        }
        if (websocketPojo == null) {
            upgradeResponse.sendError(503, "WebSocket Endpoint Creation Refused");
            return null;
        }
        return this.factory.newFrameHandler(websocketPojo, upgradeRequest, upgradeResponse);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.creator, this.factory);
    }
}

