/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.internal;

import info.journeymap.shaded.jakarta.servlet.http.HttpServletRequest;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.org.eclipse.jetty.http.BadMessageException;
import info.journeymap.shaded.org.eclipse.jetty.http.HttpField;
import info.journeymap.shaded.org.eclipse.jetty.http.HttpHeader;
import info.journeymap.shaded.org.eclipse.jetty.http.QuotedCSV;
import info.journeymap.shaded.org.eclipse.jetty.server.Request;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.WebSocketComponents;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketNegotiation;

public class RFC6455Negotiation
extends WebSocketNegotiation {
    private boolean successful;
    private String key;

    public RFC6455Negotiation(Request baseRequest, HttpServletRequest request, HttpServletResponse response, WebSocketComponents components) throws BadMessageException {
        super(baseRequest, request, response, components);
    }

    @Override
    protected void negotiateHeaders(Request baseRequest) {
        super.negotiateHeaders(baseRequest);
        boolean upgrade = false;
        QuotedCSV connectionCSVs = null;
        for (HttpField field : baseRequest.getHttpFields()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case UPGRADE: {
                    upgrade = "websocket".equalsIgnoreCase(field.getValue());
                    break;
                }
                case CONNECTION: {
                    if (connectionCSVs == null) {
                        connectionCSVs = new QuotedCSV(new String[0]);
                    }
                    connectionCSVs.addValue(field.getValue());
                    break;
                }
                case SEC_WEBSOCKET_KEY: {
                    this.key = field.getValue();
                    break;
                }
            }
        }
        this.successful = upgrade && connectionCSVs != null && connectionCSVs.getValues().stream().anyMatch(s -> s.equalsIgnoreCase("upgrade"));
    }

    @Override
    public boolean validateHeaders() {
        return this.successful;
    }

    public String getKey() {
        return this.key;
    }
}

