/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.websocket.server.config;

import info.journeymap.shaded.jakarta.servlet.ServletContainerInitializer;
import info.journeymap.shaded.jakarta.servlet.ServletContext;
import info.journeymap.shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.WebSocketComponents;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import info.journeymap.shaded.org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import info.journeymap.shaded.org.slf4j.Logger;
import info.journeymap.shaded.org.slf4j.LoggerFactory;
import java.util.Set;

public class JettyWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServletContainerInitializer.class);
    private final Configurator configurator;

    public JettyWebSocketServletContainerInitializer() {
        this(null);
    }

    public JettyWebSocketServletContainerInitializer(Configurator configurator) {
        this.configurator = configurator;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        if (!context.isStopped()) {
            throw new IllegalStateException("configure should be called before starting");
        }
        context.addServletContainerInitializer(new JettyWebSocketServletContainerInitializer(configurator));
    }

    private static JettyWebSocketServerContainer initialize(ServletContextHandler context) {
        WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents(context.getServer(), context.getServletContext());
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.ensureContainer(context.getServletContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialize {} {}", (Object)container, (Object)components);
        }
        return container;
    }

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext context) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(context, "Jetty WebSocket SCI");
        JettyWebSocketServerContainer container = JettyWebSocketServletContainerInitializer.initialize(contextHandler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("onStartup {}", (Object)container);
        }
        if (this.configurator != null) {
            this.configurator.accept(context, container);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, JettyWebSocketServerContainer var2);
    }
}

