/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.slf4j.simple;

import info.journeymap.shaded.org.slf4j.ILoggerFactory;
import info.journeymap.shaded.org.slf4j.Logger;
import info.journeymap.shaded.org.slf4j.simple.SimpleLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SimpleLoggerFactory
implements ILoggerFactory {
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public SimpleLoggerFactory() {
        SimpleLogger.lazyInit();
    }

    @Override
    public Logger getLogger(String name) {
        return this.loggerMap.computeIfAbsent(name, this::createLogger);
    }

    protected Logger createLogger(String name) {
        return new SimpleLogger(name);
    }

    protected void reset() {
        this.loggerMap.clear();
    }
}

