/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.mojang.blaze3d.platform.NativeImage;
import info.journeymap.shaded.io.javalin.http.Context;
import info.journeymap.shaded.org.eclipse.jetty.io.EofException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap_webmap.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class Resources {
    private static final Logger logger = Journeymap.getLogger((String)"webmap/routes/resources");
    private static final List<String> ALLOWED_EXTENSIONS = Arrays.asList("png");

    public static void resourcesGet(Context ctx) {
        NativeImage img;
        String extension;
        String resource = ctx.queryParam("resource");
        ResourceLocation resourceLocation = resource != null ? ResourceLocation.parse((String)resource) : null;
        boolean close = false;
        String string = extension = resource != null ? resource.substring(resource.lastIndexOf(46) + 1) : null;
        if (Minecraft.getInstance().level == null || !JourneymapClient.getInstance().isMapping().booleanValue() || resource == null || "undefined".equals(resource)) {
            ctx.result("");
            return;
        }
        if (extension != null && extension.contains(":")) {
            extension = extension.split(":")[0];
        }
        if ("fake".equals(resourceLocation != null ? resourceLocation.getNamespace() : null)) {
            img = TextureCache.getTexture((ResourceLocation)resourceLocation).getPixels();
        } else {
            try {
                img = MobIconCache.getWebMapIcon((ResourceLocation)resourceLocation).getPixels();
                if (img == null) {
                    close = true;
                    img = NativeImage.read((InputStream)Constants.getResourceAsStream(resourceLocation));
                }
            }
            catch (FileNotFoundException | NullPointerException e) {
                logger.warn("File at resource location not found: {}", (Object)resource);
                ctx.status(404);
                close = true;
                img = Resources.getDefaultImage();
            }
            catch (EofException | IIOException e) {
                logger.info("Connection closed while writing image response. WebMap probably reloaded.");
                ctx.result("");
                return;
            }
            catch (Exception e) {
                logger.error("Exception thrown while retrieving resource at location: {}", (Object)resource, (Object)e);
                ctx.status(500);
                close = true;
                img = Resources.getDefaultImage();
            }
        }
        ctx.contentType("image/" + extension);
        if (img != null && img.pixels > 0L) {
            try {
                img.writeToChannel(Channels.newChannel(ctx.outputStream()));
                ctx.outputStream().flush();
            }
            catch (Exception e) {
                logger.warn("image not found {}", (Object)resource);
            }
            if (close) {
                img.close();
            }
        }
    }

    private static NativeImage getDefaultImage() {
        try {
            NativeImage img = NativeImage.read((InputStream)Resources.class.getResource("/assets/journeymap/ui/img/marker-dot-160.png").openStream());
            return img;
        }
        catch (IOException e) {
            return null;
        }
    }
}

