/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.optifine.Config;
import net.optifine.CustomItemProperties;
import net.optifine.CustomItems;
import net.optifine.CustomItemsComparator;
import net.optifine.config.NbtTagValue;
import net.optifine.shaders.Shaders;
import net.optifine.util.EnchantmentUtils;
import net.optifine.util.ItemUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static gze itemModelGenerator = new gze();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    private static AtomicBoolean modelSpritesUpdated = new AtomicBoolean(false);
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "item/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "item/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "item/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final Map<String, Integer> mapPotionDamages = CustomItems.makeMapPotionDamages();
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void update() {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        modelSpritesUpdated.set(false);
        if (!Config.isCustomItems()) {
            return;
        }
        CustomItems.readCitProperties((String)"optifine/cit.properties");
        awb[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            awb rp = rps[i];
            CustomItems.update((awb)rp);
        }
        CustomItems.update((awb)Config.getDefaultResourcePack());
        if (itemProperties.length <= 0) {
            itemProperties = null;
        }
        if (enchantmentProperties.length <= 0) {
            enchantmentProperties = null;
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            ame loc = new ame(fileName);
            InputStream in = Config.getResourceStream((ame)loc);
            if (in == null) {
                return;
            }
            Config.dbg((String)("CustomItems: Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            useGlint = Config.parseBoolean((String)props.getProperty("useGlint"), (boolean)true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void update(awb rp) {
        CustomItemProperties[] cips;
        int i;
        Object[] names = ResUtils.collectFiles((awb)rp, (String)"optifine/cit/", (String)".properties", null);
        Map mapAutoProperties = CustomItems.makeAutoImageProperties((awb)rp);
        if (mapAutoProperties.size() > 0) {
            Set keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray((Object[])names, (Object[])keysAuto);
        }
        Arrays.sort(names);
        List itemList = CustomItems.makePropertyList((CustomItemProperties[][])itemProperties);
        List enchantmentList = CustomItems.makePropertyList((CustomItemProperties[][])enchantmentProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg((String)("CustomItems: " + (String)name));
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = (CustomItemProperties)mapAutoProperties.get(name);
                }
                if (cip == null) {
                    ame locFile = new ame((String)name);
                    InputStream in = Config.getResourceStream((awb)rp, (awd)awd.a, (ame)locFile);
                    if (in == null) {
                        Config.warn((String)("CustomItems file not found: " + (String)name));
                        continue;
                    }
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    cip = new CustomItemProperties((Properties)props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                CustomItems.addToItemList((CustomItemProperties)cip, (List)itemList);
                CustomItems.addToEnchantmentList((CustomItemProperties)cip, (List)enchantmentList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn((String)("CustomItems file not found: " + (String)name));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray((List)itemList);
        enchantmentProperties = CustomItems.propertyListToArray((List)enchantmentList);
        Comparator comp = CustomItems.getPropertiesComparator();
        for (i = 0; i < itemProperties.length; ++i) {
            cips = itemProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
        for (i = 0; i < enchantmentProperties.length; ++i) {
            cips = enchantmentProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
    }

    private static Comparator getPropertiesComparator() {
        1 comp = new /* Unavailable Anonymous Inner Class!! */;
        return comp;
    }

    public static void registerIcons(hrr textureMap) {
        if (!Config.isCustomItems()) {
            return;
        }
        int counter = 0;
        while (!modelSpritesUpdated.get()) {
            if (++counter % 50 == 0) {
                Config.dbg((String)"Waiting for model sprites");
            }
            Config.sleep((long)100L);
        }
        Config.dbg((String)"CustomItems: Registering sprites");
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.registerIcons(textureMap);
        }
    }

    public static void updateIcons(hrr textureMap) {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.updateIcons(textureMap);
        }
    }

    public static void registerModels(Map<ame, axm> mapModelsIn) {
        CustomItems.registerModels(mapModelsIn, (boolean)true);
    }

    private static void registerModels(Map<ame, axm> mapModelsIn, boolean checkParents) {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.registerModels(mapModelsIn, checkParents);
        }
    }

    public static Map<ame, axm> getModelResources(boolean checkParents) {
        HashMap<ame, axm> map = new HashMap<ame, axm>();
        CustomItems.registerModels(map, (boolean)checkParents);
        return map;
    }

    public static void collectModelSprites(Map<ame, huo> mapModelsIn) {
        Config.dbg((String)"CustomItems: Collecting model sprites");
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.collectModelSprites(mapModelsIn);
        }
        modelSpritesUpdated.set(true);
    }

    public static void updateModels() {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            if (cip.type != 1) continue;
            hrr textureMap = Config.getTextureMap();
            cip.updateModelTexture(textureMap, itemModelGenerator);
            cip.updateModelsFull();
        }
    }

    private static List<CustomItemProperties> getAllProperties() {
        ArrayList<CustomItemProperties> list = new ArrayList<CustomItemProperties>();
        CustomItems.addAll((CustomItemProperties[][])itemProperties, list);
        CustomItems.addAll((CustomItemProperties[][])enchantmentProperties, list);
        return list;
    }

    private static void addAll(CustomItemProperties[][] cipsArr, List<CustomItemProperties> list) {
        if (cipsArr == null) {
            return;
        }
        for (int i = 0; i < cipsArr.length; ++i) {
            CustomItemProperties[] cips = cipsArr[i];
            if (cips == null) continue;
            for (int k2 = 0; k2 < cips.length; ++k2) {
                CustomItemProperties cip = cips[k2];
                if (cip == null) continue;
                list.add(cip);
            }
        }
    }

    private static Map<String, CustomItemProperties> makeAutoImageProperties(awb rp) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        map.putAll(CustomItems.makePotionImageProperties((awb)rp, (String)"normal", (ame)mm.g.b((Object)dcz.tK)));
        map.putAll(CustomItems.makePotionImageProperties((awb)rp, (String)"splash", (ame)mm.g.b((Object)dcz.wR)));
        map.putAll(CustomItems.makePotionImageProperties((awb)rp, (String)"linger", (ame)mm.g.b((Object)dcz.wU)));
        return map;
    }

    private static Map<String, CustomItemProperties> makePotionImageProperties(awb rp, String type, ame itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String typePrefix = type + "/";
        String[] prefixes = new String[]{"optifine/cit/potion/" + typePrefix, "optifine/cit/Potion/" + typePrefix};
        String[] suffixes = new String[]{".png"};
        String[] names = ResUtils.collectFiles((awb)rp, (String[])prefixes, (String[])suffixes);
        for (int i = 0; i < names.length; ++i) {
            String path;
            String name = path = names[i];
            Properties props = CustomItems.makePotionProperties((String)(name = StrUtils.removePrefixSuffix((String)name, (String[])prefixes, (String[])suffixes)), (String)type, (ame)itemId, (String)path);
            if (props == null) continue;
            String pathProp = StrUtils.removeSuffix((String)path, (String[])suffixes) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, ame itemId, String path) {
        if (StrUtils.endsWith((String)name, (String[])new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals("normal")) {
            itemId = mm.g.b((Object)dcz.tJ);
            PropertiesOrdered props = new PropertiesOrdered();
            props.put("type", "item");
            props.put("items", itemId.toString());
            return props;
        }
        ame potionItemId = itemId;
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn((String)("Potion not found for image: " + path));
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i = 0; i < damages.length; ++i) {
            int damage = damages[i];
            if (type.equals("splash")) {
                damage |= 0x4000;
            }
            if (i > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            damageMask |= 0x40;
        }
        PropertiesOrdered props = new PropertiesOrdered();
        props.put("type", "item");
        props.put("items", potionItemId.toString());
        props.put("damage", bufDamage.toString());
        props.put("damageMask", "" + damageMask);
        if (type.equals("splash")) {
            props.put("texture.potion_bottle_splash", name);
        } else {
            props.put("texture.potion_bottle_drinkable", name);
        }
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId((int)0, (int)0));
            mapPotionIds.put("awkward", CustomItems.getPotionId((int)0, (int)1));
            mapPotionIds.put("thick", CustomItems.getPotionId((int)0, (int)2));
            mapPotionIds.put("potent", CustomItems.getPotionId((int)0, (int)3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds((int)1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds((int)2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds((int)3));
            mapPotionIds.put("poison", CustomItems.getPotionIds((int)4));
            mapPotionIds.put("heal", CustomItems.getPotionIds((int)5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds((int)6));
            mapPotionIds.put("clear", CustomItems.getPotionId((int)7, (int)0));
            mapPotionIds.put("bungling", CustomItems.getPotionId((int)7, (int)1));
            mapPotionIds.put("charming", CustomItems.getPotionId((int)7, (int)2));
            mapPotionIds.put("rank", CustomItems.getPotionId((int)7, (int)3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds((int)8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds((int)9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds((int)10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds((int)11));
            mapPotionIds.put("harm", CustomItems.getPotionIds((int)12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds((int)13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds((int)14));
            mapPotionIds.put("thin", CustomItems.getPotionId((int)15, (int)0));
            mapPotionIds.put("debonair", CustomItems.getPotionId((int)15, (int)1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId((int)15, (int)2));
            mapPotionIds.put("stinky", CustomItems.getPotionId((int)15, (int)3));
            mapPotionIds.put("mundane", CustomItems.getPotionId((int)0, (int)4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "effect." + name;
        Set keys = mm.d.i();
        for (ame rl : keys) {
            byo potion;
            String potionName;
            if (!mm.d.d(rl) || !fullName.equals(potionName = (potion = (byo)mm.d.a(rl)).f())) continue;
            return PotionUtils.getId((byo)potion);
        }
        return -1;
    }

    private static List<List<CustomItemProperties>> makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<List<CustomItemProperties>> list = new ArrayList<List<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                CustomItemProperties[] props = propsArr[i];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List<List<CustomItemProperties>> itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i = 0; i < cp.items.length; ++i) {
            int itemId = cp.items[i];
            if (itemId <= 0) {
                Config.warn((String)("Invalid item ID: " + itemId));
                continue;
            }
            CustomItems.addToList((CustomItemProperties)cp, itemList, (int)itemId);
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List<List<CustomItemProperties>> enchantmentList) {
        if (cp.type != 2) {
            return;
        }
        if (cp.enchantmentIds == null) {
            return;
        }
        int countIds = CustomItems.getMaxEnchantmentId() + 1;
        for (int i = 0; i < countIds; ++i) {
            int id = i;
            if (!Config.equalsOne((int)id, (int[])cp.enchantmentIds)) continue;
            CustomItems.addToList((CustomItemProperties)cp, enchantmentList, (int)id);
        }
    }

    private static int getMaxEnchantmentId() {
        return EnchantmentUtils.getMaxEnchantmentId();
    }

    private static void addToList(CustomItemProperties cp, List<List<CustomItemProperties>> list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        List<CustomItemProperties> subList = list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static gzb getCustomItemModel(dcv itemStack, gzb model, ame modelLocation, boolean fullModel) {
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties((dcv)itemStack, (int)1);
        if (props == null) {
            return model;
        }
        gzb customModel = props.getBakedModel(modelLocation, fullModel);
        if (customModel != null) {
            return customModel;
        }
        return model;
    }

    public static ame getCustomArmorTexture(dcv itemStack, htz.d layerType, htz.c layer, ame locArmor) {
        String overlay;
        if (itemProperties == null) {
            return locArmor;
        }
        int armorType = CustomItems.getArmorType((htz.d)layerType);
        if (armorType == 0) {
            return locArmor;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties((dcv)itemStack, (int)armorType);
        if (props == null) {
            return locArmor;
        }
        boolean legSlot = layerType == htz.d.b;
        ame loc = CustomItems.getCustomArmorLocation((CustomItemProperties)props, (dcv)itemStack, (boolean)legSlot, (String)(overlay = layer.a().a().endsWith("_overlay") ? "_overlay" : ""));
        if (loc == null) {
            return locArmor;
        }
        return loc;
    }

    private static int getArmorType(htz.d layerType) {
        switch (2.$SwitchMap$net$minecraft$client$resources$model$EquipmentClientInfo$LayerType[layerType.ordinal()]) {
            case 1: 
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private static ame getCustomArmorLocation(CustomItemProperties props, dcv itemStack, boolean legSlot, String overlay) {
        if (props.mapTextureLocations == null) {
            return props.textureLocation;
        }
        dcr item = itemStack.h();
        dle equip = ItemUtils.getEquippable((dcr)item);
        if (equip == null) {
            return null;
        }
        String material = ItemUtils.getMaterial((dle)equip);
        if (material == null) {
            return null;
        }
        int layer = legSlot ? 2 : 1;
        StringBuffer sb = new StringBuffer();
        sb.append("texture.");
        sb.append(material);
        sb.append("_layer_");
        sb.append(layer);
        sb.append(overlay);
        String key = sb.toString();
        ame loc = (ame)props.mapTextureLocations.get(key);
        if (loc == null) {
            return props.textureLocation;
        }
        return loc;
    }

    public static ame getCustomElytraTexture(dcv itemStack, ame locElytra) {
        if (itemProperties == null) {
            return locElytra;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties((dcv)itemStack, (int)4);
        if (props == null) {
            return locElytra;
        }
        if (props.textureLocation == null) {
            return locElytra;
        }
        return props.textureLocation;
    }

    private static CustomItemProperties getCustomItemProperties(dcv itemStack, int type) {
        CustomItemProperties[] cips;
        CustomItemProperties[][] propertiesLocal = itemProperties;
        if (propertiesLocal == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        dcr item = itemStack.h();
        int itemId = dcr.a((dcr)item);
        if (itemId >= 0 && itemId < propertiesLocal.length && (cips = propertiesLocal[itemId]) != null) {
            for (int i = 0; i < cips.length; ++i) {
                CustomItemProperties cip = cips[i];
                if (cip.type != type || !CustomItems.matchesProperties((CustomItemProperties)cip, (dcv)itemStack, null)) continue;
                return cip;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, dcv itemStack, int[][] enchantmentIdLevels) {
        int i;
        dcr item = itemStack.h();
        if (cip.damage != null) {
            int damage = CustomItems.getItemStackDamage((dcv)itemStack);
            if (damage < 0) {
                return false;
            }
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int damageMax = itemStack.p();
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.M())) {
            return false;
        }
        int[][] idLevels = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels((dcv)itemStack);
            }
            boolean idMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int id = idLevels[i][0];
                if (!Config.equalsOne((int)id, (int[])cip.enchantmentIds)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels((dcv)itemStack);
            }
            boolean levelMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int level = idLevels[i][1];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            ui nbt = ItemUtils.getTag((dcv)itemStack);
            for (i = 0; i < cip.nbtTagValues.length; ++i) {
                NbtTagValue ntv = cip.nbtTagValues[i];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int getItemStackDamage(dcv itemStack) {
        dcr item = itemStack.h();
        if (item instanceof ddo) {
            return CustomItems.getPotionDamage((dcv)itemStack);
        }
        return itemStack.o();
    }

    private static int getPotionDamage(dcv itemStack) {
        dep p2 = PotionUtils.getPotion((dcv)itemStack);
        if (p2 == null) {
            return 0;
        }
        String name = PotionUtils.getPotionBaseName((dep)p2);
        if (name == null || name.equals("")) {
            return 0;
        }
        Integer value = (Integer)mapPotionDamages.get(name);
        if (value == null) {
            return -1;
        }
        int val = value;
        if (itemStack.h() == dcz.wR) {
            val |= 0x4000;
        }
        return val;
    }

    private static Map<String, Integer> makeMapPotionDamages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomItems.addPotion((String)"water", (int)0, (boolean)false, map);
        CustomItems.addPotion((String)"awkward", (int)16, (boolean)false, map);
        CustomItems.addPotion((String)"thick", (int)32, (boolean)false, map);
        CustomItems.addPotion((String)"mundane", (int)64, (boolean)false, map);
        CustomItems.addPotion((String)"regeneration", (int)1, (boolean)true, map);
        CustomItems.addPotion((String)"swiftness", (int)2, (boolean)true, map);
        CustomItems.addPotion((String)"fire_resistance", (int)3, (boolean)true, map);
        CustomItems.addPotion((String)"poison", (int)4, (boolean)true, map);
        CustomItems.addPotion((String)"healing", (int)5, (boolean)true, map);
        CustomItems.addPotion((String)"night_vision", (int)6, (boolean)true, map);
        CustomItems.addPotion((String)"weakness", (int)8, (boolean)true, map);
        CustomItems.addPotion((String)"strength", (int)9, (boolean)true, map);
        CustomItems.addPotion((String)"slowness", (int)10, (boolean)true, map);
        CustomItems.addPotion((String)"leaping", (int)11, (boolean)true, map);
        CustomItems.addPotion((String)"harming", (int)12, (boolean)true, map);
        CustomItems.addPotion((String)"water_breathing", (int)13, (boolean)true, map);
        CustomItems.addPotion((String)"invisibility", (int)14, (boolean)true, map);
        return map;
    }

    private static void addPotion(String name, int value, boolean extended, Map<String, Integer> map) {
        if (extended) {
            value |= 0x2000;
        }
        map.put("minecraft:" + name, value);
        if (extended) {
            int valueStrong = value | 0x20;
            map.put("minecraft:strong_" + name, valueStrong);
            int valueLong = value | 0x40;
            map.put("minecraft:long_" + name, valueLong);
        }
    }

    private static int[][] getEnchantmentIdLevels(dcv itemStack) {
        djo enchantments = (djo)itemStack.a(kq.l, (Object)djo.a);
        if (enchantments.d()) {
            enchantments = (djo)itemStack.a(kq.J, (Object)djo.a);
        }
        if (enchantments.d()) {
            return EMPTY_INT2_ARRAY;
        }
        Set entries = enchantments.b();
        int[][] arr = new int[entries.size()][2];
        int i = 0;
        for (Object2IntMap.Entry entry : entries) {
            jl holder = (jl)entry.getKey();
            if (!holder.b()) continue;
            dji en = (dji)holder.a();
            int id = EnchantmentUtils.getId((dji)en);
            int lvl = entry.getIntValue();
            arr[i][0] = id;
            arr[i][1] = lvl;
            ++i;
        }
        return arr;
    }

    public static boolean renderCustomEffect(hfd renderItem, dcv itemStack, gzb model) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels((dcv)itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean renderCustomArmorEffect(cam entity, dcv itemStack, gnh model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels((dcv)itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }

    public static void setRenderOffHand(boolean renderOffHand) {
        CustomItems.renderOffHand = renderOffHand;
    }
}

