/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Properties;
import net.optifine.Config;
import net.optifine.config.ConfigUtils;
import net.optifine.shaders.ITextureFormat;
import net.optifine.shaders.TextureFormatLabPbr;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureProperties {
    private static ITextureFormat textureFormat;
    private static final int ALPHA_CUTOUT = 16;
    private static int alphaCutout;

    public static void update() {
        textureFormat = null;
        alphaCutout = 16;
        try {
            Properties props = ConfigUtils.readProperties((String)"optifine/texture.properties");
            if (props == null) {
                return;
            }
            if (Config.isShaders()) {
                textureFormat = TextureProperties.parseTextureFormat((String)props.getProperty("format"));
            }
            alphaCutout = TextureProperties.parseAlphaCutout((String)props.getProperty("alpha.cutout"));
        }
        catch (Exception e) {
            Config.warn((String)"Error reading texture.properties", (Throwable)e);
        }
    }

    private static int parseAlphaCutout(String prop) {
        if (prop == null) {
            return 16;
        }
        int val = Config.parseInt((String)prop, (int)16);
        val = Config.limit((int)val, (int)1, (int)255);
        Config.log((String)("Alpha cutout: " + val));
        return val;
    }

    private static ITextureFormat parseTextureFormat(String formatStr) {
        String ver;
        if (formatStr == null) {
            return null;
        }
        String[] parts = Config.tokenize((String)formatStr, (String)"/");
        String name = parts[0];
        String string = ver = parts.length > 1 ? parts[1] : null;
        if (name.equals("lab-pbr")) {
            return new TextureFormatLabPbr(ver);
        }
        Config.warn((String)("Unknown texture format: " + formatStr));
        return null;
    }

    public static ITextureFormat getTextureFormat() {
        return textureFormat;
    }

    public static int getAlphaCutout() {
        return alphaCutout;
    }

    static {
        alphaCutout = 16;
    }
}

