/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.optifine.render.GuiRenderListener;
import net.optifine.util.HashMapMap;

public class GuiRenderCache
implements GuiRenderListener {
    private gcg guiRenderer;
    private gcy renderState;
    private long cacheTimeMs;
    private long updateTimeMs;
    private int cacheStratum;
    private boolean renderCached;
    private boolean addToMesh;
    private int stratum;
    private List<gcg.c> meshes = new ArrayList();
    private static HashMapMap<VertexFormat.b, VertexFormat, fnz> mapBufferBuilders = new HashMapMap();

    public GuiRenderCache(gcg guiRenderer, long cacheTimeMs) {
        this.guiRenderer = guiRenderer;
        this.renderState = guiRenderer.getRenderState();
        this.cacheTimeMs = cacheTimeMs;
        this.cacheStratum = -1;
    }

    public boolean drawCached(fxb graphicsIn) {
        if (!this.checkGraphics(graphicsIn)) {
            return false;
        }
        this.cacheStratum = this.renderState.getStratum();
        this.renderState.addFrameListener((GuiRenderListener)this);
        this.renderCached = System.currentTimeMillis() < this.updateTimeMs;
        return this.renderCached;
    }

    public void startRender(fxb graphicsIn) {
        if (!this.checkGraphics(graphicsIn)) {
            return;
        }
        for (gcg.c mesh : this.meshes) {
            mesh.a().setPersistent(false);
            mesh.close();
        }
        this.meshes.clear();
        for (fnz bb : mapBufferBuilders.values()) {
            bb.clear();
        }
    }

    public void stopRender(fxb graphicsIn) {
        if (!this.checkGraphics(graphicsIn)) {
            return;
        }
        this.updateTimeMs = System.currentTimeMillis() + this.cacheTimeMs;
    }

    private boolean checkGraphics(fxb graphicsIn) {
        return graphicsIn.getGuiRenderState() == this.renderState;
    }

    public void addToMeshBegin() {
        this.addToMesh = true;
    }

    public void traverseStratumBegin(int stratumIn) {
        if (!this.addToMesh) {
            return;
        }
        if (stratumIn == this.cacheStratum) {
            this.guiRenderer.flushMesh();
        }
        this.stratum = stratumIn;
        if (this.stratum != this.cacheStratum) {
            return;
        }
        if (this.renderCached) {
            this.guiRenderer.addMeshesToDraw(this.meshes);
        }
    }

    public void meshToDraw(gcg.c mesh) {
        if (!this.addToMesh) {
            return;
        }
        if (this.stratum != this.cacheStratum) {
            return;
        }
        if (this.renderCached) {
            return;
        }
        foc data = mesh.a();
        foc.a state = data.c();
        ByteBuffer vertexBuffer = data.a();
        fnz bufferBuilder = (fnz)mapBufferBuilders.computeIfAbsent((Object)state.d(), (Object)state.a(), (modeIn, formatIn) -> new fnz(new foa(10000), modeIn, formatIn));
        bufferBuilder.putBulkData(vertexBuffer);
        vertexBuffer.rewind();
        foc data2 = bufferBuilder.a();
        data2.setPersistent(true);
        gcg.c mesh2 = new gcg.c(data2, mesh.b(), mesh.c(), mesh.d());
        this.meshes.add(mesh2);
    }

    public void traverseStratumEnd(int stratumIn) {
        if (!this.addToMesh) {
            return;
        }
        if (stratumIn == this.cacheStratum) {
            this.guiRenderer.flushMesh();
        }
        this.stratum = -1;
    }

    public void addToMeshEnd() {
        this.addToMesh = false;
    }
}

