/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.optifine.render.RegionRenderData;
import net.optifine.render.VboRegion;
import net.optifine.util.PairInt;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class RegionRenderer {
    private hba layer;
    private Map<PairInt, Map<VboRegion, List<hbh>>> mapPosRegionBuffers = new LinkedHashMap(16);
    private int lastRegionX = Integer.MIN_VALUE;
    private int lastRegionZ = Integer.MIN_VALUE;
    private Map<VboRegion, List<hbh>> lastRegionBuffers;
    private VboRegion lastVboRegion;
    private List<hbh> lastBuffers;
    private static final Vector4f COLOR_MOD = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Matrix4f TEXTURE_MATRIX = new Matrix4f();

    public RegionRenderer(hba layer) {
        this.layer = layer;
    }

    public void addSection(int regionX, int regionZ, hbh buffersIn) {
        VboRegion vboRegion;
        if (regionX != this.lastRegionX || regionZ != this.lastRegionZ) {
            PairInt pos = PairInt.of((int)regionX, (int)regionZ);
            this.lastRegionBuffers = this.mapPosRegionBuffers.computeIfAbsent(pos, k2 -> new LinkedHashMap(8));
            this.lastRegionX = regionX;
            this.lastRegionZ = regionZ;
            this.lastVboRegion = null;
        }
        if ((vboRegion = buffersIn.getVboRegion()) != this.lastVboRegion) {
            this.lastBuffers = this.lastRegionBuffers.computeIfAbsent(vboRegion, k2 -> new ArrayList());
            this.lastVboRegion = vboRegion;
        }
        this.lastBuffers.add(buffersIn);
    }

    public void reset() {
        this.lastRegionX = Integer.MIN_VALUE;
        this.lastRegionZ = Integer.MIN_VALUE;
        this.lastRegionBuffers = null;
        this.lastVboRegion = null;
        this.lastBuffers = null;
    }

    public void finishPrepare(Matrix4fc viewIn, double xIn, double yIn, double zIn, List<gwz.a> transforms, EnumMap<hba, List<RenderPass.a<GpuBufferSlice[]>>> mapLayerDraws) {
        for (Map.Entry entryPos : this.mapPosRegionBuffers.entrySet()) {
            PairInt pos = (PairInt)entryPos.getKey();
            if (entryPos.getValue() == null) continue;
            Vector3f vecOffset = new Vector3f((float)((double)pos.getLeft() - xIn), (float)(0.0 - yIn), (float)((double)pos.getRight() - zIn));
            gwz.a transform = new gwz.a(viewIn, (Vector4fc)COLOR_MOD, (Vector3fc)vecOffset, (Matrix4fc)TEXTURE_MATRIX, 1.0f);
            int uniformIndex = transforms.size();
            transforms.add(transform);
            RegionRenderData renderData = new RegionRenderData(this, pos);
            BiConsumer<GpuBufferSlice[], RenderPass.b> uniformUploader = (buffers2In, uploader2In) -> uploader2In.upload("DynamicTransforms", buffers2In[uniformIndex]);
            RenderPass.a draw = new RenderPass.a(0, null, null, null, 0, 0, uniformUploader, renderData, null);
            mapLayerDraws.get(this.layer).add((RenderPass.a<GpuBufferSlice[]>)draw);
        }
    }

    public void renderRegion(PairInt positionIn) {
        Map mapRegionBuffers = (Map)this.mapPosRegionBuffers.get(positionIn);
        if (this.mapPosRegionBuffers == null) {
            return;
        }
        for (Map.Entry entryRegionBuffers : mapRegionBuffers.entrySet()) {
            VboRegion region = (VboRegion)entryRegionBuffers.getKey();
            List listBuffers = (List)entryRegionBuffers.getValue();
            if (listBuffers.isEmpty()) continue;
            for (hbh buffers : listBuffers) {
                buffers.drawInRegion();
            }
            region.finishDraw();
            listBuffers.clear();
        }
    }

    public void clear() {
        this.reset();
        this.mapPosRegionBuffers.clear();
    }

    public String toString() {
        return String.valueOf(this.layer);
    }
}

