/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Array;
import net.optifine.util.ArrayCache;

public class ArrayCaches {
    private int[] sizes;
    private Class elementClass;
    private ArrayCache[] caches;

    public ArrayCaches(int[] sizes, Class elementClass, int maxCacheSize) {
        this.sizes = sizes;
        this.elementClass = elementClass;
        this.caches = new ArrayCache[sizes.length];
        for (int i2 = 0; i2 < this.caches.length; ++i2) {
            this.caches[i2] = new ArrayCache(elementClass, maxCacheSize);
        }
    }

    public Object allocate(int size) {
        for (int i2 = 0; i2 < this.sizes.length; ++i2) {
            if (size != this.sizes[i2]) continue;
            return this.caches[i2].allocate(size);
        }
        return Array.newInstance(this.elementClass, size);
    }

    public void free(Object arr) {
        if (arr == null) {
            return;
        }
        int size = Array.getLength(arr);
        for (int i2 = 0; i2 < this.sizes.length; ++i2) {
            if (size != this.sizes[i2]) continue;
            this.caches[i2].free(arr);
            return;
        }
    }
}

